/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.ShardRouting;

public class ClusterInfo {
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    final Map<String, Long> shardSizes;
    public static final ClusterInfo EMPTY = new ClusterInfo();
    private final Map<ShardRouting, String> routingToDataPath;

    protected ClusterInfo() {
        this(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public ClusterInfo(Map<String, DiskUsage> leastAvailableSpaceUsage, Map<String, DiskUsage> mostAvailableSpaceUsage, Map<String, Long> shardSizes, Map<ShardRouting, String> routingToDataPath) {
        this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
        this.shardSizes = shardSizes;
        this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
        this.routingToDataPath = routingToDataPath;
    }

    public Map<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public Map<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardRouting));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.routingToDataPath.get(shardRouting);
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }
}

