/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClusterState
implements ToXContent,
Diffable<ClusterState> {
    public static final ClusterState PROTO = ClusterState.builder(ClusterName.DEFAULT).build();
    private static final Map<String, Custom> customPrototypes = new HashMap<String, Custom>();
    public static final String UNKNOWN_UUID = "_na_";
    public static final long UNKNOWN_VERSION = -1L;
    private final long version;
    private final String stateUUID;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final ImmutableOpenMap<String, Custom> customs;
    private final ClusterName clusterName;
    private final boolean wasReadFromDiff;
    private volatile RoutingNodes routingNodes;
    private volatile ClusterStateStatus status;

    public static void registerPrototype(String type, Custom proto) {
        customPrototypes.put(type, proto);
    }

    @Nullable
    public static <T extends Custom> T lookupPrototype(String type) {
        return (T)customPrototypes.get(type);
    }

    public static <T extends Custom> T lookupPrototypeSafe(String type) {
        Custom proto = customPrototypes.get(type);
        if (proto == null) {
            throw new IllegalArgumentException("No custom state prototype registered for type [" + type + "]");
        }
        return (T)proto;
    }

    public ClusterState(long version, String stateUUID, ClusterState state) {
        this(state.clusterName, version, stateUUID, state.metaData(), state.routingTable(), state.nodes(), state.blocks(), state.customs(), false);
    }

    public ClusterState(ClusterName clusterName, long version, String stateUUID, MetaData metaData, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks, ImmutableOpenMap<String, Custom> customs, boolean wasReadFromDiff) {
        this.version = version;
        this.stateUUID = stateUUID;
        this.clusterName = clusterName;
        this.metaData = metaData;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.blocks = blocks;
        this.customs = customs;
        this.status = ClusterStateStatus.UNKNOWN;
        this.wasReadFromDiff = wasReadFromDiff;
    }

    public ClusterStateStatus status() {
        return this.status;
    }

    public ClusterState status(ClusterStateStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public String stateUUID() {
        return this.stateUUID;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    boolean wasReadFromDiff() {
        return this.wasReadFromDiff;
    }

    public RoutingNodes getRoutingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        this.routingNodes = new RoutingNodes(this);
        return this.routingNodes;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("version: ").append(this.version).append("\n");
        sb.append("state uuid: ").append(this.stateUUID).append("\n");
        sb.append("from_diff: ").append(this.wasReadFromDiff).append("\n");
        sb.append("meta data version: ").append(this.metaData.version()).append("\n");
        sb.append(this.blocks().prettyPrint());
        sb.append(this.nodes().prettyPrint());
        sb.append(this.routingTable().prettyPrint());
        sb.append(this.getRoutingNodes().prettyPrint());
        return sb.toString();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        EnumSet<Metric> metrics = Metric.parseString(params.param("metric", "_all"), true);
        if (metrics.contains((Object)Metric.VERSION)) {
            builder.field("version", this.version);
            builder.field("state_uuid", this.stateUUID);
        }
        if (metrics.contains((Object)Metric.MASTER_NODE)) {
            builder.field("master_node", this.nodes().masterNodeId());
        }
        if (metrics.contains((Object)Metric.BLOCKS)) {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock block : this.blocks().global()) {
                    block.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().indices().isEmpty()) {
                builder.startObject("indices");
                for (Map.Entry entry : this.blocks().indices().entrySet()) {
                    builder.startObject((String)entry.getKey());
                    for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                        block.toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.NODES)) {
            builder.startObject("nodes");
            for (DiscoveryNode node : this.nodes) {
                node.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.METADATA)) {
            builder.startObject("metadata");
            builder.field("cluster_uuid", this.metaData().clusterUUID());
            builder.startObject("templates");
            for (ObjectObjectCursor cursor : this.metaData().templates().values()) {
                IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)cursor.value;
                builder.startObject(templateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("template", templateMetaData.template());
                builder.field("order", templateMetaData.order());
                builder.startObject("settings");
                Settings settings = templateMetaData.settings();
                settings.toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectObjectCursor cursor1 : templateMetaData.mappings()) {
                    byte[] mappingSource = ((CompressedXContent)cursor1.value).uncompressed();
                    XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    Map mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(cursor1.key)) {
                        mapping = (Map)mapping.get(cursor1.key);
                    }
                    builder.field((String)cursor1.key);
                    builder.map(mapping);
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : this.metaData()) {
                builder.startObject(indexMetaData.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("state", indexMetaData.getState().toString().toLowerCase(Locale.ENGLISH));
                builder.startObject("settings");
                Settings settings = indexMetaData.getSettings();
                settings.toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectCursor cursor : indexMetaData.getMappings()) {
                    byte[] mappingSource = ((MappingMetaData)cursor.value).source().uncompressed();
                    XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    Map mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(cursor.key)) {
                        mapping = (Map)mapping.get(cursor.key);
                    }
                    builder.field((String)cursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
                builder.startArray("aliases");
                for (ObjectCursor cursor : indexMetaData.getAliases().keys()) {
                    builder.value((String)cursor.value);
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            for (ObjectObjectCursor cursor : this.metaData.customs()) {
                builder.startObject((String)cursor.key);
                ((MetaData.Custom)cursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.ROUTING_TABLE)) {
            builder.startObject("routing_table");
            builder.startObject("indices");
            for (IndexRoutingTable indexRoutingTable : this.routingTable()) {
                builder.startObject(indexRoutingTable.index(), XContentBuilder.FieldCaseConversion.NONE);
                builder.startObject("shards");
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        shardRouting.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.ROUTING_NODES)) {
            builder.startObject("routing_nodes");
            builder.startArray("unassigned");
            for (ShardRouting shardRouting : this.getRoutingNodes().unassigned()) {
                shardRouting.toXContent(builder, params);
            }
            builder.endArray();
            builder.startObject("nodes");
            for (RoutingNode routingNode : this.getRoutingNodes()) {
                builder.startArray(routingNode.nodeId() == null ? "null" : routingNode.nodeId(), XContentBuilder.FieldCaseConversion.NONE);
                for (ShardRouting shardRouting : routingNode) {
                    shardRouting.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.CUSTOMS)) {
            for (ObjectObjectCursor cursor : this.customs) {
                builder.startObject((String)cursor.key);
                ((Custom)cursor.value).toXContent(builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public static Builder builder(ClusterName clusterName) {
        return new Builder(clusterName);
    }

    public static Builder builder(ClusterState state) {
        return new Builder(state);
    }

    @Override
    public Diff diff(ClusterState previousState) {
        return new ClusterStateDiff(previousState, this);
    }

    @Override
    public Diff<ClusterState> readDiffFrom(StreamInput in) throws IOException {
        return new ClusterStateDiff(in, this);
    }

    public ClusterState readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        ClusterName clusterName = ClusterName.readClusterName(in);
        Builder builder = new Builder(clusterName);
        builder.version = in.readLong();
        builder.uuid = in.readString();
        builder.metaData = MetaData.Builder.readFrom(in);
        builder.routingTable = RoutingTable.Builder.readFrom(in);
        builder.nodes = DiscoveryNodes.Builder.readFrom(in, localNode);
        builder.blocks = ClusterBlocks.Builder.readClusterBlocks(in);
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            Custom customIndexMetaData = (Custom)ClusterState.lookupPrototypeSafe(type).readFrom(in);
            builder.putCustom(type, customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public ClusterState readFrom(StreamInput in) throws IOException {
        return this.readFrom(in, this.nodes.localNode());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeLong(this.version);
        out.writeString(this.stateUUID);
        this.metaData.writeTo(out);
        this.routingTable.writeTo(out);
        this.nodes.writeTo(out);
        this.blocks.writeTo(out);
        out.writeVInt(this.customs.size());
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : this.customs) {
            out.writeString((String)objectObjectCursor.key);
            ((Custom)objectObjectCursor.value).writeTo(out);
        }
    }

    static {
        ClusterState.registerPrototype("snapshots", SnapshotsInProgress.PROTO);
        ClusterState.registerPrototype("restore", RestoreInProgress.PROTO);
    }

    private static class ClusterStateDiff
    implements Diff<ClusterState> {
        private final long toVersion;
        private final String fromUuid;
        private final String toUuid;
        private final ClusterName clusterName;
        private final Diff<RoutingTable> routingTable;
        private final Diff<DiscoveryNodes> nodes;
        private final Diff<MetaData> metaData;
        private final Diff<ClusterBlocks> blocks;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;

        public ClusterStateDiff(ClusterState before, ClusterState after) {
            this.fromUuid = before.stateUUID;
            this.toUuid = after.stateUUID;
            this.toVersion = after.version;
            this.clusterName = after.clusterName;
            this.routingTable = after.routingTable.diff(before.routingTable);
            this.nodes = after.nodes.diff(before.nodes);
            this.metaData = after.metaData.diff(before.metaData);
            this.blocks = after.blocks.diff(before.blocks);
            this.customs = DiffableUtils.diff(before.customs, after.customs);
        }

        public ClusterStateDiff(StreamInput in, ClusterState proto) throws IOException {
            this.clusterName = ClusterName.readClusterName(in);
            this.fromUuid = in.readString();
            this.toUuid = in.readString();
            this.toVersion = in.readLong();
            this.routingTable = proto.routingTable.readDiffFrom(in);
            this.nodes = proto.nodes.readDiffFrom(in);
            this.metaData = proto.metaData.readDiffFrom(in);
            this.blocks = proto.blocks.readDiffFrom(in);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, new DiffableUtils.KeyedReader<Custom>(){

                @Override
                public Custom readFrom(StreamInput in, String key) throws IOException {
                    return (Custom)ClusterState.lookupPrototypeSafe(key).readFrom(in);
                }

                @Override
                public Diff<Custom> readDiffFrom(StreamInput in, String key) throws IOException {
                    return ClusterState.lookupPrototypeSafe(key).readDiffFrom(in);
                }
            });
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            out.writeString(this.fromUuid);
            out.writeString(this.toUuid);
            out.writeLong(this.toVersion);
            this.routingTable.writeTo(out);
            this.nodes.writeTo(out);
            this.metaData.writeTo(out);
            this.blocks.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public ClusterState apply(ClusterState state) {
            Builder builder = new Builder(this.clusterName);
            if (this.toUuid.equals(state.stateUUID)) {
                return state;
            }
            if (!this.fromUuid.equals(state.stateUUID)) {
                throw new IncompatibleClusterStateVersionException(state.version, state.stateUUID, this.toVersion, this.fromUuid);
            }
            builder.stateUUID(this.toUuid);
            builder.version(this.toVersion);
            builder.routingTable(this.routingTable.apply(state.routingTable));
            builder.nodes(this.nodes.apply(state.nodes));
            builder.metaData(this.metaData.apply(state.metaData));
            builder.blocks(this.blocks.apply(state.blocks));
            builder.customs(this.customs.apply(state.customs));
            builder.fromDiff(true);
            return builder.build();
        }
    }

    public static class Builder {
        private final ClusterName clusterName;
        private long version = 0L;
        private String uuid = "_na_";
        private MetaData metaData = MetaData.EMPTY_META_DATA;
        private RoutingTable routingTable = RoutingTable.EMPTY_ROUTING_TABLE;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private boolean fromDiff;

        public Builder(ClusterState state) {
            this.clusterName = state.clusterName;
            this.version = state.version();
            this.uuid = state.stateUUID();
            this.nodes = state.nodes();
            this.routingTable = state.routingTable();
            this.metaData = state.metaData();
            this.blocks = state.blocks();
            this.customs = ImmutableOpenMap.builder(state.customs());
            this.fromDiff = false;
        }

        public Builder(ClusterName clusterName) {
            this.customs = ImmutableOpenMap.builder();
            this.clusterName = clusterName;
        }

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder routingTable(RoutingTable.Builder routingTable) {
            return this.routingTable(routingTable.build());
        }

        public Builder routingResult(RoutingAllocation.Result routingResult) {
            this.routingTable = routingResult.routingTable();
            return this;
        }

        public Builder routingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder metaData(MetaData.Builder metaDataBuilder) {
            return this.metaData(metaDataBuilder.build());
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder incrementVersion() {
            ++this.version;
            this.uuid = ClusterState.UNKNOWN_UUID;
            return this;
        }

        public Builder stateUUID(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder fromDiff(boolean fromDiff) {
            this.fromDiff = fromDiff;
            return this;
        }

        public ClusterState build() {
            if (ClusterState.UNKNOWN_UUID.equals(this.uuid)) {
                this.uuid = Strings.randomBase64UUID();
            }
            return new ClusterState(this.clusterName, this.version, this.uuid, this.metaData, this.routingTable, this.nodes, this.blocks, this.customs.build(), this.fromDiff);
        }

        public static byte[] toBytes(ClusterState state) throws IOException {
            BytesStreamOutput os = new BytesStreamOutput();
            state.writeTo(os);
            return os.bytes().toBytes();
        }

        public static ClusterState fromBytes(byte[] data, DiscoveryNode localNode) throws IOException {
            return Builder.readFrom(StreamInput.wrap(data), localNode);
        }

        public static ClusterState readFrom(StreamInput in, @Nullable DiscoveryNode localNode) throws IOException {
            return PROTO.readFrom(in, localNode);
        }
    }

    public static enum Metric {
        VERSION("version"),
        MASTER_NODE("master_node"),
        BLOCKS("blocks"),
        NODES("nodes"),
        METADATA("metadata"),
        ROUTING_TABLE("routing_table"),
        ROUTING_NODES("routing_nodes"),
        CUSTOMS("customs");

        private static Map<String, Metric> valueToEnum;
        private final String value;

        private Metric(String value) {
            this.value = value;
        }

        public static EnumSet<Metric> parseString(String param, boolean ignoreUnknown) {
            String[] metrics = Strings.splitStringByCommaToArray(param);
            EnumSet<Metric> result = EnumSet.noneOf(Metric.class);
            for (String metric : metrics) {
                if ("_all".equals(metric)) {
                    result = EnumSet.allOf(Metric.class);
                    break;
                }
                Metric m = valueToEnum.get(metric);
                if (m == null) {
                    if (ignoreUnknown) continue;
                    throw new IllegalArgumentException("Unknown metric [" + metric + "]");
                }
                result.add(m);
            }
            return result;
        }

        public String toString() {
            return this.value;
        }

        static {
            valueToEnum = new HashMap<String, Metric>();
            for (Metric metric : Metric.values()) {
                valueToEnum.put(metric.value, metric);
            }
        }
    }

    public static interface Custom
    extends Diffable<Custom>,
    ToXContent {
        public String type();
    }

    public static enum ClusterStateStatus {
        UNKNOWN(0),
        RECEIVED(1),
        BEING_APPLIED(2),
        APPLIED(3);

        private final byte id;

        private ClusterStateStatus(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }
}

