/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedTransferQueue;
import org.elasticsearch.common.util.concurrent.ConcurrentHashMapLong;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;

public abstract class ConcurrentCollections {
    private static final boolean useLinkedTransferQueue = Boolean.parseBoolean(System.getProperty("es.useLinkedTransferQueue", "false"));
    static final int aggressiveConcurrencyLevel = Math.max(Runtime.getRuntime().availableProcessors() * 2, 16);

    public static <K, V> ConcurrentMap<K, V> newConcurrentMapWithAggressiveConcurrency() {
        return new ConcurrentHashMap(16, 0.75f, aggressiveConcurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <V> ConcurrentMapLong<V> newConcurrentMapLongWithAggressiveConcurrency() {
        return new ConcurrentHashMapLong<V>(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency());
    }

    public static <V> ConcurrentMapLong<V> newConcurrentMapLong() {
        return new ConcurrentHashMapLong<V>(ConcurrentCollections.newConcurrentMap());
    }

    public static <V> Set<V> newConcurrentSet() {
        return Sets.newSetFromMap(ConcurrentCollections.newConcurrentMap());
    }

    public static <T> Queue<T> newQueue() {
        if (useLinkedTransferQueue) {
            return new LinkedTransferQueue();
        }
        return new ConcurrentLinkedQueue();
    }

    public static <T> Deque<T> newDeque() {
        return new ConcurrentLinkedDeque();
    }

    public static <T> BlockingQueue<T> newBlockingQueue() {
        return new LinkedTransferQueue();
    }

    private ConcurrentCollections() {
    }
}

