/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class OsInfo
implements Streamable,
ToXContent {
    long refreshInterval;
    int availableProcessors;
    int allocatedProcessors;
    String name = null;
    String arch = null;
    String version = null;

    OsInfo() {
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public int getAllocatedProcessors() {
        return this.allocatedProcessors;
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.OS);
        builder.timeValueField(Fields.REFRESH_INTERVAL_IN_MILLIS, Fields.REFRESH_INTERVAL, this.refreshInterval);
        if (this.name != null) {
            builder.field(Fields.NAME, this.name);
        }
        if (this.arch != null) {
            builder.field(Fields.ARCH, this.arch);
        }
        if (this.version != null) {
            builder.field(Fields.VERSION, this.version);
        }
        builder.field(Fields.AVAILABLE_PROCESSORS, this.availableProcessors);
        builder.field(Fields.ALLOCATED_PROCESSORS, this.allocatedProcessors);
        builder.endObject();
        return builder;
    }

    public static OsInfo readOsInfo(StreamInput in) throws IOException {
        OsInfo info = new OsInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        this.availableProcessors = in.readInt();
        if (in.getVersion().onOrAfter(Version.V_2_1_0)) {
            this.allocatedProcessors = in.readInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        out.writeInt(this.availableProcessors);
        if (out.getVersion().onOrAfter(Version.V_2_1_0)) {
            out.writeInt(this.allocatedProcessors);
        }
    }

    static final class Fields {
        static final XContentBuilderString OS = new XContentBuilderString("os");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString ARCH = new XContentBuilderString("arch");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");
        static final XContentBuilderString REFRESH_INTERVAL = new XContentBuilderString("refresh_interval");
        static final XContentBuilderString REFRESH_INTERVAL_IN_MILLIS = new XContentBuilderString("refresh_interval_in_millis");
        static final XContentBuilderString AVAILABLE_PROCESSORS = new XContentBuilderString("available_processors");
        static final XContentBuilderString ALLOCATED_PROCESSORS = new XContentBuilderString("allocated_processors");

        Fields() {
        }
    }
}

