/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.validate.template;

import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.validate.template.RenderSearchTemplateRequest;
import org.elasticsearch.action.admin.cluster.validate.template.RenderSearchTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.Template;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    @Inject
    public RestRenderSearchTemplateAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template/{id}", this);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        Template template;
        BytesReference source = RestActions.getRestContent(request);
        XContentParser parser = XContentFactory.xContent(source).createParser(source);
        String templateId = request.param("id");
        if (templateId == null) {
            template = Template.parse(parser, this.parseFieldMatcher);
        } else {
            Map<String, Object> params = null;
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse request. request body must be an object but found [{}] instead", new Object[]{token});
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (this.parseFieldMatcher.match(currentFieldName, Script.ScriptField.PARAMS)) {
                    if (token == XContentParser.Token.START_OBJECT) {
                        params = parser.map();
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse request. field [{}] is expected to be an object, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                throw new ElasticsearchParseException("failed to parse request. unknown field [{}] of type [{}]", new Object[]{currentFieldName, token});
            }
            template = new Template(templateId, ScriptService.ScriptType.INDEXED, "mustache", null, params);
        }
        RenderSearchTemplateRequest renderSearchTemplateRequest = new RenderSearchTemplateRequest();
        renderSearchTemplateRequest.template(template);
        client.admin().cluster().renderSearchTemplate(renderSearchTemplateRequest, (ActionListener<RenderSearchTemplateResponse>)new RestBuilderListener<RenderSearchTemplateResponse>(channel){

            @Override
            public RestResponse buildResponse(RenderSearchTemplateResponse response, XContentBuilder builder) throws Exception {
                builder.prettyPrint();
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

