/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchShardTarget;

public class SearchException
extends ElasticsearchException
implements ElasticsearchWrapperException {
    private final SearchShardTarget shardTarget;

    public SearchException(SearchShardTarget shardTarget, String msg) {
        this(shardTarget, msg, null);
    }

    public SearchException(SearchShardTarget shardTarget, String msg, Throwable cause) {
        super(msg, cause, new Object[0]);
        this.shardTarget = shardTarget;
    }

    public SearchException(StreamInput in) throws IOException {
        super(in);
        this.shardTarget = in.readBoolean() ? SearchShardTarget.readSearchShardTarget(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable(this.shardTarget);
    }

    public SearchShardTarget shard() {
        return this.shardTarget;
    }
}

