/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.InternalPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketParser;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class PercentilesBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles_bucket");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public PercentilesBucketPipelineAggregator readResult(StreamInput in) throws IOException {
            PercentilesBucketPipelineAggregator result = new PercentilesBucketPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private double[] percents;
    private List<Double> data;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
        InternalPercentilesBucket.registerStreams();
    }

    private PercentilesBucketPipelineAggregator() {
    }

    protected PercentilesBucketPipelineAggregator(String name, double[] percents, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
        this.percents = percents;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected void preCollection() {
        this.data = new ArrayList<Double>(1024);
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.data.add(bucketValue);
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        Collections.sort(this.data);
        double[] percentiles = new double[this.percents.length];
        if (this.data.size() == 0) {
            for (int i = 0; i < this.percents.length; ++i) {
                percentiles[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i < this.percents.length; ++i) {
                int index = (int)(this.percents[i] / 100.0 * (double)this.data.size());
                percentiles[i] = this.data.get(index);
            }
        }
        return new InternalPercentilesBucket(this.name(), this.percents, percentiles, this.formatter, pipelineAggregators, metadata);
    }

    @Override
    public void doReadFrom(StreamInput in) throws IOException {
        super.doReadFrom(in);
        this.percents = in.readDoubleArray();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDoubleArray(this.percents);
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private final BucketHelpers.GapPolicy gapPolicy;
        private final double[] percents;

        public Factory(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, double[] percents) {
            super(name, TYPE.name(), bucketsPaths);
            this.gapPolicy = gapPolicy;
            this.formatter = formatter;
            this.percents = percents;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new PercentilesBucketPipelineAggregator(this.name, this.percents, this.bucketsPaths, this.gapPolicy, this.formatter, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
            double[] arr$ = this.percents;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double p = arr$[i$];
                if (p != null && !(p < 0.0) && !(p > 100.0)) continue;
                throw new IllegalStateException(PercentilesBucketParser.PERCENTS.getPreferredName() + " must only contain non-null doubles from 0.0-100.0 inclusive");
            }
        }
    }
}

