/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.format;

import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueParser;
import org.joda.time.DateTimeZone;

public class ValueFormat {
    public static final ValueFormat RAW = new ValueFormat(ValueFormatter.RAW, ValueParser.RAW);
    public static final ValueFormat IPv4 = new ValueFormat(ValueFormatter.IPv4, ValueParser.IPv4);
    public static final ValueFormat BOOLEAN = new ValueFormat(ValueFormatter.BOOLEAN, ValueParser.BOOLEAN);
    private final ValueFormatter formatter;
    private final ValueParser parser;

    public ValueFormat(ValueFormatter formatter, ValueParser parser) {
        assert (formatter != null && parser != null);
        this.formatter = formatter;
        this.parser = parser;
    }

    public ValueFormatter formatter() {
        return this.formatter;
    }

    public ValueParser parser() {
        return this.parser;
    }

    public static class Number
    extends Patternable<Number> {
        public static Number format(String format) {
            return new Number(format, new ValueFormatter.Number.Pattern(format), new ValueParser.Number.Pattern(format));
        }

        public Number(String pattern, ValueFormatter formatter, ValueParser parser) {
            super(pattern, formatter, parser);
        }

        @Override
        public Number create(String pattern) {
            return Number.format(pattern);
        }
    }

    public static class DateTime
    extends Patternable<DateTime> {
        public static final DateTime DEFAULT = new DateTime(DateFieldMapper.Defaults.DATE_TIME_FORMATTER.format(), ValueFormatter.DateTime.DEFAULT, ValueParser.DateMath.DEFAULT);

        public static DateTime format(String format, DateTimeZone timezone) {
            return new DateTime(format, new ValueFormatter.DateTime(format, timezone), new ValueParser.DateMath(format, timezone));
        }

        public static DateTime mapper(DateFieldMapper.DateFieldType fieldType, DateTimeZone timezone) {
            return new DateTime(fieldType.dateTimeFormatter().format(), ValueFormatter.DateTime.mapper(fieldType, timezone), ValueParser.DateMath.mapper(fieldType, timezone));
        }

        private DateTime(String pattern, ValueFormatter formatter, ValueParser parser) {
            super(pattern, formatter, parser);
        }

        @Override
        public DateTime create(String pattern) {
            return DateTime.format(pattern, DateTimeZone.UTC);
        }
    }

    public static abstract class Patternable<VF extends Patternable<VF>>
    extends ValueFormat {
        private final String pattern;

        public Patternable(String pattern, ValueFormatter formatter, ValueParser parser) {
            super(formatter, parser);
            this.pattern = pattern;
        }

        public String pattern() {
            return this.pattern;
        }

        public abstract VF create(String var1);
    }
}

