/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;

public class LandMap {
    private static final Logger logger = Logger.getLogger(LandMap.class.getName());
    private final int width;
    private final int height;
    private boolean[][] map;
    private int numberOfLandTiles;
    private int preferredDistanceToEdge;
    private int minimumNumberOfTiles;

    public LandMap(int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new boolean[this.width][this.height];
        this.numberOfLandTiles = 0;
    }

    public LandMap(Game game) {
        this(game.getMap().getWidth(), game.getMap().getHeight());
        Map map = game.getMap();
        boolean[][] bmap = new boolean[this.width][this.height];
        int n = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                boolean bl = bmap[x][y] = map.isValid(x, y) ? map.getTile(x, y).isLand() : false;
                if (!bmap[x][y]) continue;
                ++n;
            }
        }
        this.map = bmap;
        this.numberOfLandTiles = n;
    }

    public LandMap(OptionGroup mgo, Random random) {
        this(mgo.getInteger("model.option.mapWidth"), mgo.getInteger("model.option.mapHeight"));
        int preferredDistanceToEdge = mgo.getInteger("model.option.preferredDistanceToEdge");
        int minimumNumberOfTiles = mgo.getInteger("model.option.landMass") * this.width * this.height / 100;
        int gen = mgo.getInteger("model.option.landGeneratorType");
        SelectOption so = (SelectOption)mgo.getOption("model.option.landGeneratorType");
        logger.info("Using land generator " + so.getItemValues().get(gen));
        this.generate(gen, preferredDistanceToEdge, minimumNumberOfTiles, random);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isValid(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public boolean isLand(int x, int y) {
        return this.isValid(x, y) ? this.map[x][y] : false;
    }

    private void generate(int type, int preferredDistanceToEdge, int minimumNumberOfTiles, Random random) {
        switch (type) {
            case 0: {
                this.createClassicLandMap(preferredDistanceToEdge, minimumNumberOfTiles, random);
                break;
            }
            case 1: {
                this.addPolarRegions();
                int contsize = minimumNumberOfTiles * 75 / 100;
                this.addLandMass(contsize, contsize, this.width / 2, this.height / 4 + RandomUtils.randomInt(logger, "Landmass", random, this.height / 2), preferredDistanceToEdge, random);
                while (this.numberOfLandTiles < minimumNumberOfTiles) {
                    this.addLandMass(15, 25, -1, -1, preferredDistanceToEdge, random);
                }
                break;
            }
            case 2: {
                this.addPolarRegions();
                int archsize = minimumNumberOfTiles * 10 / 100;
                for (int i = 0; i < 5; ++i) {
                    this.addLandMass(archsize - 5, archsize + 5, -1, -1, preferredDistanceToEdge, random);
                }
            }
            case 3: {
                this.addPolarRegions();
                while (this.numberOfLandTiles < minimumNumberOfTiles) {
                    int s = RandomUtils.randomInt(logger, "Island", random, 50) + 25;
                    this.addLandMass(25, s, -1, -1, preferredDistanceToEdge, random);
                }
                break;
            }
        }
        this.cleanMap();
    }

    private void createClassicLandMap(int preferredDistanceToEdge, int minimumNumberOfTiles, Random random) {
        while (this.numberOfLandTiles < minimumNumberOfTiles) {
            int y;
            int x;
            int failCounter = 0;
            do {
                x = RandomUtils.randomInt(logger, "ClassicW", random, this.width - preferredDistanceToEdge * 4) + preferredDistanceToEdge * 2;
                y = RandomUtils.randomInt(logger, "ClassicH", random, this.height - preferredDistanceToEdge * 4) + preferredDistanceToEdge * 2;
                if (++failCounter <= 100) continue;
                failCounter = 0;
                --minimumNumberOfTiles;
                break;
            } while (this.map[x][y]);
            this.setLand(x, y, preferredDistanceToEdge, random);
        }
        this.addPolarRegions();
    }

    private void addPolarRegions() {
        for (int x = 0; x < this.width; ++x) {
            int limit;
            for (int y = 0; y < 2; ++y) {
                if (this.map[x][y]) continue;
                this.map[x][y] = true;
                ++this.numberOfLandTiles;
            }
            for (int y = limit = this.height - 1 - 2; y < this.height; ++y) {
                if (this.map[x][y]) continue;
                this.map[x][y] = true;
                ++this.numberOfLandTiles;
            }
        }
    }

    private void cleanMap() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.isSingleTile(x, y)) continue;
                this.map[x][y] = false;
            }
        }
    }

    private boolean isSingleTile(int x, int y) {
        Map.Position p = new Map.Position(x, y);
        return CollectionUtils.none(Direction.values(), d -> {
            Map.Position n = new Map.Position(p, (Direction)d);
            return n.isValid(this.width, this.height) && this.map[n.getX()][n.getY()];
        });
    }

    private int setLand(int x, int y, int preferredDistanceToEdge, Random random) {
        if (this.map[x][y]) {
            return 0;
        }
        int ret = 1;
        this.map[x][y] = true;
        ++this.numberOfLandTiles;
        Map.Position p = new Map.Position(x, y);
        for (Direction direction : Direction.longSides) {
            Map.Position n = new Map.Position(p, direction);
            if (!n.isValid(this.width, this.height)) continue;
            ret += this.growLand(n.getX(), n.getY(), preferredDistanceToEdge, random);
        }
        return ret;
    }

    private int growLand(int x, int y, int preferredDistanceToEdge, Random random) {
        if (this.map[x][y]) {
            return 0;
        }
        int r = RandomUtils.randomInt(logger, "Grow", random, 8) + Math.max(-1, 1 + Math.max(preferredDistanceToEdge - Math.min(x, this.width - x), 2 * preferredDistanceToEdge - Math.min(y, this.height - y)));
        int sum = 0;
        Map.Position p = new Map.Position(x, y);
        for (Direction direction : Direction.values()) {
            Map.Position n = new Map.Position(p, direction);
            if (!n.isValid(this.width, this.height) || !this.map[n.getX()][n.getY()]) continue;
            ++sum;
        }
        return sum > r ? this.setLand(x, y, preferredDistanceToEdge, random) : 0;
    }

    private int addLandMass(int minSize, int maxSize, int x, int y, int preferredDistanceToEdge, Random random) {
        int size = 0;
        boolean[][] newLand = new boolean[this.width][this.height];
        if (x < 0 || y < 0) {
            while (this.map[x = RandomUtils.randomInt(logger, "LandW", random, this.width - preferredDistanceToEdge * 2) + preferredDistanceToEdge][y = RandomUtils.randomInt(logger, "LandH", random, this.height - preferredDistanceToEdge * 2) + preferredDistanceToEdge] || !this.isSingleTile(x, y)) {
            }
        }
        newLand[x][y] = true;
        ++size;
        ArrayList<Map.Position> l = new ArrayList<Map.Position>();
        Map.Position p = new Map.Position(x, y);
        for (Direction direction : Direction.longSides) {
            Map.Position n = new Map.Position(p, direction);
            if (!n.isValid(this.width, this.height) || !this.isSingleTile(n.getX(), n.getY()) || n.getX() <= preferredDistanceToEdge || n.getX() >= this.width - preferredDistanceToEdge) continue;
            l.add(n);
        }
        int enough = minSize + RandomUtils.randomInt(logger, "LandSize", random, maxSize - minSize + 1);
        while (size < enough && !l.isEmpty()) {
            int i = RandomUtils.randomInt(logger, "Lsiz", random, l.size());
            p = (Map.Position)l.remove(i);
            if (newLand[p.getX()][p.getY()]) continue;
            newLand[p.getX()][p.getY()] = true;
            ++size;
            for (Direction direction : Direction.longSides) {
                Map.Position n = new Map.Position(p, direction);
                if (!n.isValid(this.width, this.height) || !this.isSingleTile(n.getX(), n.getY()) || n.getX() <= preferredDistanceToEdge || n.getX() >= this.width - preferredDistanceToEdge) continue;
                l.add(n);
            }
        }
        if (size >= minSize) {
            for (x = 0; x < this.width; ++x) {
                for (y = 0; y < this.height; ++y) {
                    if (!newLand[x][y]) continue;
                    this.map[x][y] = true;
                    ++this.numberOfLandTiles;
                }
            }
        }
        return size >= minSize ? size : 0;
    }
}

