/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.freecol.common.debug.FreeColDebugger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Message {
    protected static final Logger logger = Logger.getLogger(Message.class.getName());
    private static final String FREECOL_PROTOCOL_VERSION = "0.1.6";
    private static final String INVALID_MESSAGE = "invalid";
    protected Document document;

    protected Message() {
    }

    public Message(String msg) throws SAXException, IOException {
        this(new InputSource(new StringReader(msg)));
    }

    public Message(InputStream inputStream) throws SAXException, IOException {
        this(new InputSource(inputStream));
    }

    private Message(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document tempDocument = null;
        boolean dumpMsgOnError = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS);
        if (dumpMsgOnError) {
            inputSource.setByteStream(new BufferedInputStream(inputSource.getByteStream()));
            inputSource.getByteStream().mark(1000000);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            tempDocument = builder.parse(inputSource);
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, "Parser error", pce);
        }
        catch (IOException | SAXException ex) {
            throw ex;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dumpMsgOnError) {
                int i;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                inputSource.getByteStream().reset();
                while (-1 != (i = inputSource.getByteStream().read())) {
                    baos.write(i);
                }
                logger.severe(baos.toString("UTF-8"));
            }
            throw e;
        }
        this.document = tempDocument;
    }

    public Message(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getType() {
        return this.document != null && this.document.getDocumentElement() != null ? this.document.getDocumentElement().getTagName() : INVALID_MESSAGE;
    }

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    public String getAttribute(String key) {
        return this.document.getDocumentElement().getAttribute(key);
    }

    public boolean hasAttribute(String attribute) {
        return this.document.getDocumentElement().hasAttribute(attribute);
    }

    public void setAttribute(String key, String value) {
        this.document.getDocumentElement().setAttribute(key, value);
    }

    public void setAttribute(String key, int value) {
        this.setAttribute(key, Integer.toString(value));
    }

    public Element toXMLElement() {
        return null;
    }

    public String toString() {
        return this.document.getDocumentElement().toString();
    }

    public static String getFreeColProtocolVersion() {
        return FREECOL_PROTOCOL_VERSION;
    }
}

