/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SellMessage
extends DOMMessage {
    private final String unitId;
    private final String settlementId;
    private final Goods goods;
    private final String goldString;

    public SellMessage(Unit unit, Settlement settlement, Goods goods, int gold) {
        super(SellMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
        this.goldString = Integer.toString(gold);
    }

    public SellMessage(Game game, Element element) {
        super(SellMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goods = new Goods(game, DOMMessage.getChildElement(element, Goods.getXMLElementTagName()));
        this.goldString = element.getAttribute("gold");
    }

    public int getGold() {
        try {
            return Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerIndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = (ServerIndianSettlement)unit.getAdjacentIndianSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != unit) {
            return DOMMessage.clientError("Goods " + this.goods.getId() + " is not with unit " + this.unitId);
        }
        int gold = this.getGold();
        if (gold < 0) {
            return DOMMessage.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().sellToSettlement(serverPlayer, unit, settlement, this.goods, gold);
    }

    @Override
    public Element toXMLElement() {
        Element result = SellMessage.createMessage(SellMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId, "gold", this.goldString);
        result.appendChild(this.goods.toXMLElement(result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "sell";
    }
}

