/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.sound;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.sound.OggVorbisDecoderFactory;

public class SoundPlayer {
    private static final Logger logger = Logger.getLogger(SoundPlayer.class.getName());
    private Mixer mixer;
    private int volume;
    private final SoundPlayerThread soundPlayerThread;

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volumeOption) {
        this.setMixer(mixerOption.getValue());
        if (this.mixer == null) {
            throw new IllegalStateException("Mixer unavailable.");
        }
        mixerOption.addPropertyChangeListener(e -> this.setMixer((AudioMixerOption.MixerWrapper)e.getNewValue()));
        this.setVolume(volumeOption.getValue());
        volumeOption.addPropertyChangeListener(e -> this.setVolume((Integer)e.getNewValue()));
        this.soundPlayerThread = new SoundPlayerThread();
        this.soundPlayerThread.start();
    }

    public static AudioInputStream getAudioInputStream(File file) throws Exception {
        AudioInputStream in = file.getName().endsWith(".ogg") ? new OggVorbisDecoderFactory().getOggStream(file) : AudioSystem.getAudioInputStream(file);
        return in;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    private void setMixer(AudioMixerOption.MixerWrapper mw) {
        try {
            this.mixer = AudioSystem.getMixer(mw.getMixerInfo());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not set mixer", e);
            this.mixer = null;
        }
    }

    public int getVolume() {
        return this.volume;
    }

    private void setVolume(int volume) {
        this.volume = volume;
    }

    public void playOnce(File file) {
        if (this.getMixer() == null) {
            return;
        }
        try {
            this.soundPlayerThread.add(SoundPlayer.getAudioInputStream(file));
            this.soundPlayerThread.awaken();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to play: " + file.getName(), e);
        }
    }

    public void stop() {
        this.soundPlayerThread.stopPlaying();
        this.soundPlayerThread.awaken();
    }

    private class SoundPlayerThread
    extends Thread {
        private static final int BUFSIZ = 8192;
        private final byte[] data;
        private final List<AudioInputStream> playList;
        private boolean playDone;

        public SoundPlayerThread() {
            super("FreeColClient:SoundPlayer");
            this.data = new byte[8192];
            this.playList = new ArrayList<AudioInputStream>();
            this.playDone = true;
        }

        private synchronized void awaken() {
            this.notify();
        }

        private synchronized void goToSleep() throws InterruptedException {
            this.wait();
        }

        public synchronized boolean keepPlaying() {
            return !this.playDone;
        }

        public synchronized void startPlaying() {
            this.playDone = false;
        }

        public synchronized void stopPlaying() {
            this.playDone = true;
        }

        public synchronized void add(AudioInputStream ais) {
            this.playList.add(ais);
        }

        @Override
        public void run() {
            while (true) {
                if (this.playList.isEmpty()) {
                    try {
                        this.goToSleep();
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    AudioInputStream in = this.playList.remove(0);
                    Throwable throwable = null;
                    try {
                        this.playSound(in);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failure playing audio.", e);
                    continue;
                }
                break;
            }
        }

        private void sleep(int t) {
            try {
                Thread.sleep(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void setVolume(SourceDataLine line, int vol) {
            FloatControl control;
            FloatControl.Type type;
            FloatControl.Type type2 = line.isControlSupported(FloatControl.Type.VOLUME) ? FloatControl.Type.VOLUME : (type = line.isControlSupported(FloatControl.Type.MASTER_GAIN) ? FloatControl.Type.MASTER_GAIN : null);
            if (type == null) {
                logger.warning("No volume or master gain controls.");
                return;
            }
            try {
                control = (FloatControl)line.getControl(type);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            float min = control.getMinimum();
            float max = control.getMaximum();
            float gain = vol <= 0 ? min : (vol >= 100 ? max : min + 0.5f * (max - min) * (float)Math.log10(vol));
            try {
                control.setValue(gain);
                logger.finest("Using volume " + vol + "%, " + control.getUnits() + "=" + gain + " control=" + type);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set volume  (control=" + type + " in [" + min + "," + max + "])" + " to " + gain + control.getUnits(), e);
            }
        }

        private SourceDataLine openLine(AudioFormat audioFormat) {
            SourceDataLine line = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            if (!SoundPlayer.this.mixer.isLineSupported(info)) {
                logger.log(Level.WARNING, "Mixer does not support " + info);
                return null;
            }
            try {
                line = (SourceDataLine)SoundPlayer.this.mixer.getLine(info);
                line.open(audioFormat, 8192);
                line.start();
                this.setVolume(line, SoundPlayer.this.volume);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Can not open SourceDataLine", e);
                return null;
            }
            return line;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean playSound(AudioInputStream in) throws IOException {
            boolean ret = false;
            SourceDataLine line = this.openLine(in.getFormat());
            if (line == null) {
                return false;
            }
            try {
                int rd;
                this.startPlaying();
                while (this.keepPlaying() && (rd = in.read(this.data)) > 0) {
                    line.write(this.data, 0, rd);
                }
                ret = true;
            }
            finally {
                this.stopPlaying();
                line.drain();
                line.stop();
                line.close();
            }
            return ret;
        }
    }
}

