/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Element;

public abstract class Wish
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(Wish.class.getName());
    protected Location destination;
    protected TransportableAIObject transportable;
    private static final String DESTINATION_TAG = "destination";
    private static final String TRANSPORTABLE_TAG = "transportable";

    public Wish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.destination = null;
        this.transportable = null;
    }

    public Wish(AIMain aiMain, Element element) {
        super(aiMain, element);
    }

    public Wish(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    public boolean shouldBeStored() {
        return this.transportable != null;
    }

    public TransportableAIObject getTransportable() {
        return this.transportable;
    }

    public void setTransportable(TransportableAIObject transportable) {
        this.transportable = transportable;
    }

    public Location getDestination() {
        return this.destination;
    }

    public AIColony getDestinationAIColony() {
        return this.destination instanceof Colony ? this.getAIMain().getAIColony((Colony)this.destination) : null;
    }

    @Override
    public void dispose() {
        this.destination = null;
        this.transportable = null;
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.transportable != null) {
            result = Math.min(result, this.transportable.checkIntegrity(fix));
        }
        if (this.destination == null || ((FreeColGameObject)((Object)this.destination)).isDisposed()) {
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.destination != null) {
            xw.writeAttribute(DESTINATION_TAG, this.destination.getId());
            if (this.transportable != null) {
                xw.writeAttribute(TRANSPORTABLE_TAG, this.transportable.getId());
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.destination = xr.getLocationAttribute(aiMain.getGame(), DESTINATION_TAG, false);
    }
}

