/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class UnitWanderHostileMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitWanderHostileMission.class.getName());
    private static final String tag = "AI hostile-wanderer";

    public UnitWanderHostileMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit, null);
    }

    public UnitWanderHostileMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        return !unit.isOffensiveUnit() ? "unit-not-offensive" : (!unit.hasTile() ? "unit-not-on-map" : null);
    }

    public static String invalidReason(AIUnit aiUnit) {
        String reason = Mission.invalidReason(aiUnit);
        return reason != null ? reason : ((reason = UnitWanderHostileMission.invalidMissionReason(aiUnit)) != null ? reason : null);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = UnitWanderHostileMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((reason = UnitWanderHostileMission.invalidMissionReason(aiUnit)) != null ? reason : null);
    }

    @Override
    public Location getTarget() {
        return null;
    }

    @Override
    public void setTarget(Location target) {
    }

    @Override
    public Location findTarget() {
        return null;
    }

    @Override
    public boolean isOneTime() {
        return true;
    }

    @Override
    public String invalidReason() {
        return UnitWanderHostileMission.invalidReason(this.getAIUnit(), null);
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        AIUnit aiUnit = this.getAIUnit();
        int check = 0;
        int checkTurns = RandomUtils.randomInt(logger, "Hostile", this.getAIRandom(), 4);
        Direction d = Direction.getRandomDirection(tag, logger, this.getAIRandom());
        while (unit.getMovesLeft() > 0) {
            if (check == 0) {
                Mission m = this.getAIPlayer().getSeekAndDestroyMission(aiUnit, 1);
                if (m != null) {
                    return this.lbDone(lb, true, "found target ", m.getTarget());
                }
                check = checkTurns;
            } else {
                --check;
            }
            if ((d = this.moveRandomly(tag, d)) != null) continue;
            break;
        }
        return this.lbAt(lb);
    }

    @Override
    public String getXMLTagName() {
        return UnitWanderHostileMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unitWanderHostileMission";
    }
}

