/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import gnu.gcj.tools.gc_analyze.BlockMap;
import gnu.gcj.tools.gc_analyze.BytePtr;
import gnu.gcj.tools.gc_analyze.MemoryAnalyze;
import gnu.gcj.tools.gc_analyze.ObjectMap;
import gnu.gcj.tools.gc_analyze.SymbolLookup;
import gnu.gcj.tools.gc_analyze.SymbolTable;
import gnu.gcj.tools.gc_analyze.ToolPrefix;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemoryAnalyze {
    private static NumberFormat numberFormat;
    private static boolean verbose;

    static String format(long number, int digits) {
        String temp;
        int spaces;
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(true);
        }
        if ((spaces = digits - (temp = numberFormat.format(number)).length()) < 0) {
            spaces = 0;
        }
        return String.valueOf("                                ".substring(0, spaces)) + temp;
    }

    static void sorted_report(String description, int total_space, ArrayList<String> list, Comparator<String> comparator) {
        System.out.println("*** " + description + " ***");
        System.out.println();
        System.out.println("  Total Size       Count       Size    Description");
        System.out.println("--------------     -----    --------   -----------------------------------");
        Collections.sort(list, comparator);
        for (String v : list) {
            System.out.println(MemoryAnalyze.stripend(v));
        }
        System.out.println("--------------     -----    --------   -----------------------------------");
        System.out.println(MemoryAnalyze.format(total_space, 14));
        System.out.println();
        System.out.println();
    }

    private static String stripend(String s) {
        int n = s.lastIndexOf(" /");
        if (n > 0) {
            return s.substring(0, n);
        }
        return s;
    }

    public static void main(String[] args) {
        int total_space = 0;
        OptionParser optionParser = new OptionParser();
        String[] rest = ((Parser)optionParser).parse(args);
        String filename = rest[0];
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            SymbolLookup lookup = new SymbolLookup(reader, String.valueOf(filename) + ".bytes");
            ObjectMap objectMap = new ObjectMap(reader);
            BlockMap blockMap = new BlockMap(reader);
            reader.close();
            for (Map.Entry<Long, ObjectMap.ObjectItem> me : objectMap) {
                String class_name;
                BytePtr p;
                ObjectMap.ObjectItem item = me.getValue();
                if (item.klass == 0L && (p = lookup.getBytePtr(item.ptr, item.size)) != null) {
                    long vtable = p.getWord(0);
                    String sym = lookup.getSymbolViaVtable(vtable - (long)(2 * lookup.memoryMap.wordSize));
                    if (sym != null) {
                        item.typeName = SymbolTable.demangleVTName(sym);
                    } else if (vtable != 0L && (p = lookup.getBytePtr(vtable, lookup.memoryMap.wordSize)) != null) {
                        long klass;
                        item.klass = klass = p.getWord(0);
                    }
                }
                if (item.typeName == null) {
                    item.typeName = class_name = MemoryAnalyze.getSymbolPretty(lookup, item, false);
                } else {
                    class_name = item.typeName;
                }
                System.out.print("class_name=[" + class_name + "]");
                if (class_name.compareTo("_ZTVN4java4lang6StringE") == 0 || class_name.compareTo("java.lang.String") == 0) {
                    BytePtr p2 = lookup.getBytePtr(item.ptr, item.size);
                    long data = p2.getWord(1);
                    int boffset = p2.getInt(2 * p2.intsPerWord());
                    int count = p2.getInt(1 + 2 * p2.intsPerWord());
                    int hash = p2.getInt(2 + 2 * p2.intsPerWord());
                    BytePtr chars = lookup.getBytePtr(data + (long)boffset, count * 2);
                    StringBuffer sb = new StringBuffer(count);
                    int qq = 0;
                    while (qq < count) {
                        sb.append((char)chars.getShort(qq));
                        ++qq;
                    }
                    int newhash = sb.toString().hashCode();
                    if (newhash != hash) {
                        p2.setInt(4, newhash);
                    }
                    item.string = sb.toString();
                    System.out.println(" value = \"" + item.string + "\"");
                    if (data == item.ptr) continue;
                    ObjectMap.ObjectItem next = objectMap.get(data);
                    if (next != null) {
                        next.stringData = true;
                        continue;
                    }
                    System.out.println("String [" + item.string + "] at " + Long.toHexString(item.ptr) + " can't find array at " + Long.toHexString(data));
                    continue;
                }
                if (item.string != null) {
                    System.out.println(" value = \"" + item.string + "\"");
                    continue;
                }
                System.out.println();
            }
            class Info {
                int size;
                int count;

                Info() {
                }
            }
            HashMap<String, Info> map = new HashMap<String, Info>();
            for (Map.Entry me : objectMap) {
                ObjectMap.ObjectItem item = (ObjectMap.ObjectItem)me.getValue();
                String name = MemoryAnalyze.getSymbolPretty(lookup, item, true);
                Info info = (Info)map.get(name);
                if (info == null) {
                    info = new Info();
                    info.count = 0;
                    info.size = item.size;
                    map.put(name, info);
                }
                ++info.count;
                total_space += item.size;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry me : map.entrySet()) {
                String name = (String)me.getKey();
                Info info = (Info)me.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append(MemoryAnalyze.format(info.count * info.size * 100 / total_space, 3));
                sb.append("%");
                sb.append(MemoryAnalyze.format(info.count * info.size, 10));
                sb.append(" = ");
                sb.append(MemoryAnalyze.format(info.count, 7));
                sb.append(" * ");
                sb.append(MemoryAnalyze.format(info.size, 9));
                sb.append(" - ");
                sb.append(name);
                list.add(sb.toString());
            }
            MemoryAnalyze.sorted_report("Memory Usage Sorted by Total Size", total_space, list, new SubstringComparator(5, 14, true));
            MemoryAnalyze.sorted_report("Memory Usage Sorted by Description", total_space, list, new SubstringComparator(39, 0, false));
            MemoryAnalyze.sorted_report("Memory Usage Sorted by Count", total_space, list, new SubstringComparator(17, 25, true));
            MemoryAnalyze.sorted_report("Memory Usage Sorted by Size", total_space, list, new SubstringComparator(28, 37, true));
            blockMap.dump();
            if (verbose) {
                ObjectMap.ObjectItem item;
                for (Map.Entry<Long, ObjectMap.ObjectItem> me : objectMap) {
                    long ptr = me.getKey();
                    item = me.getValue();
                    BytePtr p = lookup.getBytePtr(ptr, item.size);
                    if (p == null) {
                        System.out.println("can't find ptr 0x" + Long.toHexString(ptr));
                        continue;
                    }
                    if (item.kind == 0) continue;
                    int i = 1;
                    while (i < item.size / lookup.memoryMap.wordSize) {
                        long maybe_ptr = p.getWord(i);
                        ObjectMap.ObjectItem item2 = objectMap.get(maybe_ptr);
                        if (item2 != null) {
                            item2.pointed_by.add(item);
                            item.points_to.add(item2);
                        }
                        ++i;
                    }
                }
                System.out.println();
                System.out.println("*** All Objects ***");
                System.out.println();
                for (Map.Entry<Long, ObjectMap.ObjectItem> me : objectMap) {
                    long ptr = me.getKey();
                    item = me.getValue();
                    String name = MemoryAnalyze.getSymbolPretty(lookup, item, false);
                    System.out.print("0x" + Long.toHexString(ptr) + " - " + name + " (" + item.size + ")");
                    if (item.string != null) {
                        System.out.println(" \"" + item.string + "\"");
                    } else {
                        System.out.println();
                    }
                    BytePtr p = lookup.getBytePtr(ptr, item.size);
                    if (p == null) {
                        System.out.println("can't find memory; recently allocated from free list?");
                    } else {
                        p.dump();
                    }
                    item.points_to.dump("  points to:", lookup);
                    item.pointed_by.dump("  pointed to by:", lookup);
                    System.out.println();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String kindToName(int kind) {
        String name;
        switch (kind) {
            case 0: {
                name = "GC_PTRFREE";
                break;
            }
            case 1: {
                name = "GC_NORMAL";
                break;
            }
            case 2: {
                name = "GC_UNCOLLECTABLE";
                break;
            }
            case 3: {
                name = "GC_AUUNCOLLCTABLE";
                break;
            }
            case 4: {
                name = "(Java)";
                break;
            }
            case 5: {
                name = "(Java Debug)";
                break;
            }
            case 6: {
                name = "(Java Array)";
                break;
            }
            default: {
                name = "(Kind " + kind + ")";
            }
        }
        return name;
    }

    public static String getSymbolPretty(SymbolLookup lookup, ObjectMap.ObjectItem item, boolean bsize) throws IOException {
        String v;
        String name = item.typeName;
        if (name == null) {
            name = lookup.getSymbol(item.klass);
        }
        if (name == null && (v = lookup.decodeUTF8(item.ptr, item.size)) != null) {
            name = "UTF8Const";
            item.string = v;
        }
        if (name == null) {
            name = MemoryAnalyze.kindToName(item.kind);
        }
        if (item.kind == 6) {
            name = String.valueOf(name) + "[" + MemoryAnalyze.format(item.data, 0) + "]";
        }
        if (bsize) {
            name = String.valueOf(name) + " / " + MemoryAnalyze.format(item.size, 7);
        }
        return name;
    }

    static /* synthetic */ void access$0(boolean bl) {
        verbose = bl;
    }

    static class OptionParser
    extends Parser {
        int filesFound;

        OptionParser() {
            super("gc-analyze", "gc-analyze (" + System.getProperty("java.vm.version") + ")");
            this.add(new Option(this, 'd', "Directory containing runtime objects", "directory"){
                final /* synthetic */ OptionParser this$1;
                {
                    this.this$1 = optionParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolPrefix.pathPrefix = argument;
                }
            });
            this.add(new Option(this, 'p', "Binary tool prefix, prepended to nm and readelf to obtain target specific versions of these commands", "prefix"){
                final /* synthetic */ OptionParser this$1;
                {
                    this.this$1 = optionParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    ToolPrefix.toolPrefix = argument;
                }
            });
            this.add(new Option(this, "verbose", 'v', "Verbose output; requires filename.bytes"){
                final /* synthetic */ OptionParser this$1;
                {
                    this.this$1 = optionParser;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void parsed(String argument) throws OptionException {
                    MemoryAnalyze.access$0(true);
                }
            });
            this.setHeader("usage: gc-analyze [-v] [-p tool-prefix] [-d <directory>] filename");
        }

        protected void validate() throws OptionException {
            if (this.filesFound != 1) {
                throw new OptionException("Must specify exactly one filename");
            }
        }

        public String[] parse(String[] inArgs) {
            ArrayList fileResult = new ArrayList();
            this.parse(inArgs, new FileArgumentCallback(this, fileResult){
                final /* synthetic */ OptionParser this$1;
                private final /* synthetic */ ArrayList val$fileResult;
                {
                    this.this$1 = optionParser;
                    this.val$fileResult = arrayList;
                }

                public void notifyFile(String fileArgument) {
                    ++this.this$1.filesFound;
                    this.val$fileResult.add(fileArgument);
                }
            });
            return fileResult.toArray(new String[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubstringComparator
    implements Comparator<String> {
        private int begin;
        private int end;
        private boolean reverse;

        SubstringComparator(int begin, int end, boolean reverse) {
            this.begin = begin;
            this.end = end;
            this.reverse = reverse;
        }

        @Override
        public int compare(String s1, String s2) {
            s1 = this.end == 0 ? s1.substring(this.begin) : s1.substring(this.begin, this.end);
            s2 = this.end == 0 ? s2.substring(this.begin) : s2.substring(this.begin, this.end);
            int i = s1.compareTo(s2);
            if (this.reverse) {
                return -i;
            }
            return i;
        }
    }
}

