/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.CDR.Vio;
import gnu.CORBA.GIOP.ServiceContext;
import gnu.CORBA.ObjectCreator;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.portable.OutputStream;

public class UnknownExceptionCtxHandler
extends Vio {
    public static ServiceContext[] addExceptionContext(ServiceContext[] current, Throwable exception, Object details) {
        try {
            ServiceContext[] c = new ServiceContext[current.length + 1];
            if (current.length > 0) {
                System.arraycopy(current, 0, c, 0, current.length);
            }
            BufferedCdrOutput output = new BufferedCdrOutput();
            if (details instanceof OutputStream) {
                output.setOrb(((OutputStream)output).orb());
            }
            if (details instanceof AbstractCdrOutput) {
                ((AbstractCdrOutput)details).cloneSettings(output);
            }
            UnknownExceptionCtxHandler.write(output, exception);
            ServiceContext xc = new ServiceContext();
            xc.context_id = 9;
            xc.context_data = output.buffer.toByteArray();
            c[current.length] = xc;
            return c;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return current;
        }
    }

    public static void write(BufferedCdrOutput output, Throwable t) {
        t.fillInStackTrace();
        output.write_Value(t);
    }

    public static Throwable read(BufferredCdrInput input, ServiceContext[] contexts) {
        input.mark(Integer.MAX_VALUE);
        int h = input.read_long();
        if (h == 0) {
            String id;
            String[] ids;
            String codebase;
            int value_tag;
            block9: {
                try {
                    input.mark(512);
                    value_tag = input.read_long();
                    UnknownExceptionCtxHandler.checkTag(value_tag);
                    codebase = null;
                    ids = null;
                    id = null;
                    if (value_tag != 0) break block9;
                    return null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (value_tag == -1) {
                return (Throwable)UnknownExceptionCtxHandler.readIndirection(input);
            }
            if ((value_tag & 1) != 0) {
                codebase = UnknownExceptionCtxHandler.read_string(input);
            }
            if ((value_tag & 4) != 0) {
                ids = UnknownExceptionCtxHandler.read_string_array(input);
            } else if ((value_tag & 2) != 0) {
                id = UnknownExceptionCtxHandler.read_string(input);
            }
            Object ox = UnknownExceptionCtxHandler.createInstance(id, ids, codebase);
            return (Throwable)ox;
        }
        input.reset();
        return (Throwable)input.read_Value();
    }

    static Object createInstance(String id, String[] ids, String codebase) {
        Object o = UnknownExceptionCtxHandler._createInstance(id, codebase);
        if (ids != null) {
            int i = 0;
            while (i < ids.length && o == null) {
                o = UnknownExceptionCtxHandler._createInstance(ids[i], codebase);
                ++i;
            }
        }
        return o;
    }

    static Object _createInstance(String id, String codebase) {
        if (id == null) {
            return null;
        }
        if (id.equals(StringValueHelper.id())) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(id, ":");
        String prefix = st.nextToken();
        if (prefix.equalsIgnoreCase("IDL")) {
            return ObjectCreator.Idl2Object(id);
        }
        if (prefix.equalsIgnoreCase("RMI")) {
            String className = st.nextToken();
            String hashCode = st.nextToken();
            String sid = null;
            if (st.hasMoreElements()) {
                sid = st.nextToken();
            }
            try {
                Class objectClass = Util.loadClass(className, codebase, Vio.class.getClassLoader());
                String rid = ObjectCreator.getRepositoryId(objectClass);
                if (!rid.equals(id)) {
                    StringTokenizer st2 = new StringTokenizer(rid, ":");
                    if (!st2.nextToken().equals("RMI")) {
                        throw new InternalError("RMI format expected: '" + rid + "'");
                    }
                    if (!st2.nextToken().equals(className)) {
                        UnknownExceptionCtxHandler.throwIt("Class name mismatch", id, rid, null);
                    }
                    try {
                        long s2;
                        long s1;
                        long h1 = Long.parseLong(hashCode, 16);
                        long h2 = Long.parseLong(st2.nextToken(), 16);
                        if (h1 != h2) {
                            UnknownExceptionCtxHandler.throwIt("Hashcode mismatch", id, rid, null);
                        }
                        if (sid != null && st2.hasMoreTokens() && (s1 = Long.parseLong(hashCode, 16)) != (s2 = Long.parseLong(st2.nextToken(), 16))) {
                            UnknownExceptionCtxHandler.throwIt("serialVersionUID mismatch", id, rid, null);
                        }
                    }
                    catch (NumberFormatException e) {
                        UnknownExceptionCtxHandler.throwIt("Invalid hashcode or svuid format: ", id, rid, e);
                    }
                }
                try {
                    return objectClass.newInstance();
                }
                catch (Exception exception) {
                    Constructor c = objectClass.getConstructor(String.class);
                    return c.newInstance("<message unavailable>");
                }
            }
            catch (MARSHAL m) {
                m.minor = 1195573264;
                throw m;
            }
            catch (Exception ex) {
                MARSHAL m = new MARSHAL("Unable to instantiate " + id);
                m.minor = 1195573264;
                m.initCause(ex);
                throw m;
            }
        }
        throw new NO_IMPLEMENT("Unsupported prefix " + prefix + ":");
    }
}

