/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NameFinder {
    private String binaryFile;
    private String sourceFile;
    private int lineNum;
    private HashMap procs = new HashMap();
    private static Set blacklist = Collections.synchronizedSet(new HashSet());
    private static boolean use_addr2line = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.use_addr2line", "true"));
    private static boolean show_raw = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.show_raw", "false"));
    private static final boolean remove_unknown = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.remove_unknown", "true"));

    static final boolean showRaw() {
        return show_raw;
    }

    static final boolean removeUnknown() {
        return remove_unknown;
    }

    public String getSourceFile() {
        String file = this.sourceFile != null ? this.sourceFile : this.binaryFile;
        return file.substring(file.lastIndexOf(File.separator) + 1, file.length());
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void lookup(String file, long addr) {
        this.binaryFile = file;
        this.sourceFile = null;
        this.lineNum = -1;
        if (!use_addr2line || blacklist.contains(file)) {
            return;
        }
        Addr2Line addr2line = (Addr2Line)this.procs.get(file);
        if (addr2line == null) {
            addr2line = new Addr2Line(file);
            this.procs.put(file, addr2line);
        }
        if (addr2line.proc == null) {
            use_addr2line = false;
            return;
        }
        String hexAddr = "0x" + Long.toHexString(addr);
        try {
            addr2line.out.write(hexAddr);
            addr2line.out.newLine();
            addr2line.out.flush();
            String result = addr2line.in.readLine();
            if (result.indexOf("??") == -1) {
                int split = result.lastIndexOf(58);
                this.sourceFile = result.substring(0, split);
                String lineNumStr = result.substring(split + 1, result.length());
                this.lineNum = Integer.parseInt(lineNumStr);
            } else {
                blacklist.add(this.binaryFile);
            }
        }
        catch (IOException iOException) {
            addr2line = null;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public static String demangleInterpreterMethod(String m, String cn) {
        int index = 0;
        int length = m.length();
        StringBuffer sb = new StringBuffer(length);
        if (m.startsWith("<init>")) {
            int i = cn.lastIndexOf(46);
            String className = i < 0 ? cn : cn.substring(i + 1);
            sb.append(className);
            index += 7;
        } else {
            int i = m.indexOf(40);
            if (i > 0) {
                sb.append(m.substring(0, i));
                index += i + 1;
            }
        }
        sb.append('(');
        int arrayDepth = 0;
        int c = index < length ? (int)m.charAt(index) : 41;
        while (c != 41) {
            int nc;
            String type;
            switch (c) {
                case 66: {
                    type = "byte";
                    break;
                }
                case 67: {
                    type = "char";
                    break;
                }
                case 68: {
                    type = "double";
                    break;
                }
                case 70: {
                    type = "float";
                    break;
                }
                case 73: {
                    type = "int";
                    break;
                }
                case 74: {
                    type = "long";
                    break;
                }
                case 83: {
                    type = "short";
                    break;
                }
                case 90: {
                    type = "boolean";
                    break;
                }
                case 76: {
                    int i = m.indexOf(59, index);
                    if (i > 0) {
                        type = m.substring(index + 1, i);
                        index = i;
                        break;
                    }
                    type = "<unknown ref>";
                    break;
                }
                case 91: {
                    type = "";
                    ++arrayDepth;
                    break;
                }
                default: {
                    type = "<unknown " + (char)c + '>';
                }
            }
            sb.append(type);
            if (c != 91 && arrayDepth > 0) {
                while (arrayDepth > 0) {
                    sb.append("[]");
                    --arrayDepth;
                }
            }
            int n = nc = ++index < length ? (int)m.charAt(index) : 41;
            if (c != 91 && nc != 41) {
                sb.append(", ");
            }
            c = nc;
        }
        sb.append(')');
        return sb.toString();
    }

    public void close() {
        for (Addr2Line proc : this.procs.values()) {
            proc.close();
        }
    }

    class Addr2Line {
        Process proc;
        BufferedWriter out;
        BufferedReader in;

        Addr2Line(String binaryFile) {
            try {
                String[] exec = new String[]{"addr2line", "-e", binaryFile};
                Runtime runtime = Runtime.getRuntime();
                this.proc = runtime.exec(exec);
            }
            catch (IOException iOException) {}
            if (this.proc != null) {
                this.in = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                this.out = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
            }
        }

        void close() {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            if (this.proc != null) {
                this.proc.destroy();
            }
        }
    }
}

