/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Button;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ButtonPeer;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SwingButtonPeer
extends SwingComponentPeer
implements ButtonPeer {
    public SwingButtonPeer(Button theButton) {
        SwingButton button = new SwingButton(theButton);
        button.setText(theButton.getLabel());
        button.addActionListener(new SwingButtonListener());
        this.init(theButton, button);
    }

    public void setLabel(String label) {
        ((SwingButton)this.swingComponent).setText(label);
    }

    class SwingButton
    extends JButton
    implements SwingComponent {
        Button button;

        SwingButton(Button button) {
            this.button = button;
        }

        public Point getLocationOnScreen() {
            return SwingButtonPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (this.button != null) {
                retVal = this.button.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingButtonPeer.this.createImage(w, h);
        }

        public Graphics getGraphics() {
            return SwingButtonPeer.this.getGraphics();
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseEvent(ev);
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            ev.setSource(this);
            this.processKeyEvent(ev);
        }

        public Container getParent() {
            Container par = null;
            if (this.button != null) {
                par = this.button.getParent();
            }
            return par;
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        public void requestFocus() {
            SwingButtonPeer.this.requestFocus(SwingButtonPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean temporary) {
            return SwingButtonPeer.this.requestFocus(SwingButtonPeer.this.awtComponent, temporary, true, 0L);
        }
    }

    class SwingButtonListener
    implements ActionListener {
        SwingButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Button b = (Button)SwingButtonPeer.this.awtComponent;
            ActionListener[] l = b.getActionListeners();
            if (l.length == 0) {
                return;
            }
            ActionEvent ev = new ActionEvent(b, 1001, b.getActionCommand());
            int i = 0;
            while (i < l.length) {
                l[i].actionPerformed(ev);
                ++i;
            }
        }
    }
}

