/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Writer;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StAXWriter
implements Writer {
    XMLStreamWriter writer;
    int indent = 0;

    public StAXWriter(OutputStream os) {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(os);
        }
        catch (XMLStreamException se) {
            throw (InternalError)new InternalError("Could not instantiate a streaming XML writer.").initCause(se);
        }
    }

    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (XMLStreamException xMLStreamException) {}
            this.writer = null;
        }
    }

    public void writePreamble() {
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
        }
        catch (XMLStreamException xMLStreamException) {}
    }

    public void writeEnd(boolean wasEmpty) {
        try {
            this.indent -= 2;
            if (wasEmpty) {
                return;
            }
            int i = 0;
            while (i < this.indent) {
                this.writer.writeCharacters(" ");
                ++i;
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException xMLStreamException) {}
    }

    public void writeEndNoChildren() {
        try {
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException xMLStreamException) {}
    }

    public void write(String tagName, boolean empty) {
        this.write(tagName, null, null, null, empty);
    }

    public void write(String tagName, String value) {
        this.write(tagName, value, null, null, value == null);
    }

    public void writeNoChildren(String tagName, String value) {
        try {
            int i = 0;
            while (i < this.indent) {
                this.writer.writeCharacters(" ");
                ++i;
            }
            this.writer.writeStartElement(tagName);
            this.writer.writeCharacters(value);
        }
        catch (XMLStreamException xMLStreamException) {}
    }

    public void write(String tagName, String attributeName, String attributeValue, boolean empty) {
        this.write(tagName, null, new String[]{attributeName}, new String[]{attributeValue}, empty);
    }

    public void write(String tagName, String value, String[] attributeNames, String[] attributeValues, boolean empty) {
        try {
            int i = 0;
            while (i < this.indent) {
                this.writer.writeCharacters(" ");
                ++i;
            }
            if (empty) {
                this.writer.writeEmptyElement(tagName);
            } else {
                this.writer.writeStartElement(tagName);
            }
            if (attributeNames != null) {
                i = 0;
                while (i < attributeNames.length) {
                    this.writer.writeAttribute(attributeNames[i], attributeValues[i]);
                    ++i;
                }
            }
            this.writer.writeCharacters("\n");
            this.indent += 2;
            if (value != null) {
                i = 0;
                while (i < this.indent) {
                    this.writer.writeCharacters(" ");
                    ++i;
                }
                this.writer.writeCharacters(value);
                this.writer.writeCharacters("\n");
            }
        }
        catch (XMLStreamException xMLStreamException) {}
    }

    public void write(String tagName, String[] attributeNames, String[] attributeValues, boolean empty) {
        this.write(tagName, null, attributeNames, attributeValues, empty);
    }
}

