/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.GenericSignatureParser;
import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public class MethodSignatureParser
extends GenericSignatureParser {
    private TypeVariable[] typeParameters = this.peekChar() == '<' ? this.readFormalTypeParameters() : new TypeVariable[0];
    private Type[] argTypes;
    private Type retType;
    private Type[] throwsSigs;

    public MethodSignatureParser(Method method, String signature) {
        this(method, method.getDeclaringClass().getClassLoader(), signature);
    }

    public MethodSignatureParser(Constructor method, String signature) {
        this(method, method.getDeclaringClass().getClassLoader(), signature);
    }

    private MethodSignatureParser(GenericDeclaration wrapper, ClassLoader loader, String signature) {
        super(wrapper, loader, signature);
        this.consume('(');
        ArrayList<Type> args = new ArrayList<Type>();
        while (this.peekChar() != ')') {
            args.add(this.readTypeSignature());
        }
        this.argTypes = new Type[args.size()];
        args.toArray(this.argTypes);
        this.consume(')');
        this.retType = this.readTypeSignature();
        ArrayList<Type> throwsSigs = new ArrayList<Type>();
        while (this.peekChar() == '^') {
            this.consume('^');
            if (this.peekChar() == 'T') {
                throwsSigs.add(this.readTypeVariableSignature());
                continue;
            }
            throwsSigs.add(this.readClassTypeSignature());
        }
        this.throwsSigs = new Type[throwsSigs.size()];
        throwsSigs.toArray(this.throwsSigs);
        this.end();
    }

    public TypeVariable[] getTypeParameters() {
        TypeImpl.resolve(this.typeParameters);
        return this.typeParameters;
    }

    public Type[] getGenericParameterTypes() {
        TypeImpl.resolve(this.argTypes);
        return this.argTypes;
    }

    public Type getGenericReturnType() {
        this.retType = TypeImpl.resolve(this.retType);
        return this.retType;
    }

    public Type[] getGenericExceptionTypes() {
        TypeImpl.resolve(this.throwsSigs);
        return this.throwsSigs;
    }

    private Type readTypeSignature() {
        switch (this.peekChar()) {
            case 'T': {
                return this.readTypeVariableSignature();
            }
            case 'L': {
                return this.readClassTypeSignature();
            }
            case '[': {
                return this.readArrayTypeSignature();
            }
            case 'Z': {
                this.consume('Z');
                return Boolean.TYPE;
            }
            case 'B': {
                this.consume('B');
                return Byte.TYPE;
            }
            case 'S': {
                this.consume('S');
                return Short.TYPE;
            }
            case 'C': {
                this.consume('C');
                return Character.TYPE;
            }
            case 'I': {
                this.consume('I');
                return Integer.TYPE;
            }
            case 'F': {
                this.consume('F');
                return Float.TYPE;
            }
            case 'J': {
                this.consume('J');
                return Long.TYPE;
            }
            case 'D': {
                this.consume('D');
                return Double.TYPE;
            }
            case 'V': {
                this.consume('V');
                return Void.TYPE;
            }
        }
        throw new GenericSignatureFormatError();
    }
}

