/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedKeyUsage
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.37");
    private final List<OID> purposeIds;

    public ExtendedKeyUsage(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue usageList = der.read();
        if (!usageList.isConstructed()) {
            throw new IOException("malformed ExtKeyUsageSyntax");
        }
        int len = 0;
        this.purposeIds = new LinkedList<OID>();
        while (len < usageList.getLength()) {
            DERValue val = der.read();
            if (val.getTag() != 6) {
                throw new IOException("malformed KeyPurposeId");
            }
            this.purposeIds.add((OID)val.getValue());
            len += val.getEncodedLength();
        }
    }

    public List<OID> getPurposeIds() {
        return Collections.unmodifiableList(this.purposeIds);
    }

    @Override
    public String toString() {
        return String.valueOf(ExtendedKeyUsage.class.getName()) + " [ " + this.purposeIds + " ]";
    }
}

