/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.CSPRNG;
import java.net.MalformedURLException;
import java.security.SecureRandomSpi;

public class CSPRNGSpi
extends SecureRandomSpi {
    private final IRandom adaptee = CSPRNG.getSystemInstance();
    private boolean virgin = true;

    protected byte[] engineGenerateSeed(int numBytes) {
        return SecureRandomAdapter.getSeed(numBytes);
    }

    protected void engineNextBytes(byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.virgin) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(buffer, 0, buffer.length);
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("random-number generator has been exhausted");
        }
    }

    protected void engineSetSeed(byte[] seed) {
        if (seed == null) {
            throw new NullPointerException();
        }
        this.adaptee.addRandomBytes(seed, 0, seed.length);
        this.virgin = false;
    }
}

