/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.ClientCertificateTypeList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.X500PrincipalList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CertificateRequest
implements Handshake.Body {
    protected ByteBuffer buffer;

    public CertificateRequest(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public int length() {
        int o1 = (this.buffer.get(0) & 0xFF) + 1;
        return o1 + (this.buffer.getShort(o1) & 0xFFFF) + 2;
    }

    public ClientCertificateTypeList types() {
        return new ClientCertificateTypeList(this.buffer.duplicate());
    }

    public X500PrincipalList authorities() {
        int offset = (this.buffer.get(0) & 0xFF) + 1;
        return new X500PrincipalList(((ByteBuffer)this.buffer.position(offset)).slice());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + "  ";
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  types =");
        out.println(this.types().toString(subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  authorities =");
        out.println(this.authorities().toString(subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} CertificateRequest;");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientCertificateType {
        RSA_SIGN(1),
        DSS_SIGN(2),
        RSA_FIXED_DH(3),
        DSS_FIXED_DH(4);

        private final int value;

        private ClientCertificateType(int value) {
            this.value = value;
        }

        static ClientCertificateType forValue(int value) {
            switch (value) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
            }
            throw new IllegalArgumentException("unknown client certificate type: " + value);
        }

        public int getValue() {
            return this.value;
        }
    }
}

