/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends Component
implements ItemSelectable,
Accessible {
    private static transient long next_list_number;
    private static final long serialVersionUID = -3304312411574666869L;
    private Vector items = new Vector();
    private boolean multipleMode;
    private int rows;
    private int[] selected;
    private int visibleIndex = -1;
    private ItemListener item_listeners;
    private ActionListener action_listeners;

    public List() {
        this(4, false);
    }

    public List(int rows) {
        this(rows, false);
    }

    public List(int rows, boolean multipleMode) {
        this.rows = rows == 0 ? 4 : rows;
        this.multipleMode = multipleMode;
        this.selected = new int[0];
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized String[] getItems() {
        Object[] l_items = new String[this.getItemCount()];
        this.items.copyInto(l_items);
        return l_items;
    }

    public String getItem(int index) {
        return (String)this.items.elementAt(index);
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean multipleMode) {
        this.setMultipleSelections(multipleMode);
    }

    public void setMultipleSelections(boolean multipleMode) {
        this.multipleMode = multipleMode;
        ListPeer peer = (ListPeer)this.getPeer();
        if (peer != null) {
            peer.setMultipleMode(multipleMode);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows());
    }

    @Override
    public Dimension minimumSize() {
        return this.minimumSize(this.getRows());
    }

    public Dimension getMinimumSize(int rows) {
        return this.minimumSize(rows);
    }

    public Dimension minimumSize(int rows) {
        ListPeer peer = (ListPeer)this.getPeer();
        if (peer != null) {
            return peer.minimumSize(rows);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows());
    }

    @Override
    public Dimension preferredSize() {
        return this.preferredSize(this.getRows());
    }

    public Dimension getPreferredSize(int rows) {
        return this.preferredSize(rows);
    }

    public Dimension preferredSize(int rows) {
        ListPeer peer = (ListPeer)this.getPeer();
        if (peer != null) {
            return peer.preferredSize(rows);
        }
        return this.getSize();
    }

    public void add(String item) {
        this.add(item, -1);
    }

    public void addItem(String item) {
        this.addItem(item, -1);
    }

    public void add(String item, int index) {
        this.addItem(item, index);
    }

    public void addItem(String item, int index) {
        if (item == null) {
            item = "";
        }
        if (index < -1) {
            index = -1;
        }
        if (index == -1 || index >= this.items.size()) {
            this.items.addElement(item);
        } else {
            this.items.insertElementAt(item, index);
        }
        ListPeer peer = (ListPeer)this.getPeer();
        if (peer != null) {
            peer.add(item, index);
        }
    }

    public void delItem(int index) throws IllegalArgumentException {
        ListPeer peer;
        boolean selected = false;
        if (this.isSelected(index)) {
            selected = true;
            this.deselect(index);
        }
        this.items.removeElementAt(index);
        if (selected) {
            this.select(index);
        }
        if ((peer = (ListPeer)this.getPeer()) != null) {
            peer.delItems(index, index);
        }
    }

    public void remove(int index) throws IllegalArgumentException {
        this.delItem(index);
    }

    public synchronized void delItems(int start, int end) throws IllegalArgumentException {
        int i = end;
        while (i >= start) {
            this.items.removeElementAt(i);
            --i;
        }
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.delItems(start, end);
        }
    }

    public synchronized void remove(String item) throws IllegalArgumentException {
        int index = this.items.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("List element to delete not found");
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public void clear() {
        this.items.clear();
        ListPeer peer = (ListPeer)this.getPeer();
        if (peer != null) {
            peer.removeAll();
        }
        this.selected = new int[0];
    }

    public synchronized void replaceItem(String item, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.items.size()) {
            throw new ArrayIndexOutOfBoundsException("Bad list index: " + index);
        }
        this.items.insertElementAt(item, index + 1);
        this.items.removeElementAt(index);
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.add(item, index + 1);
            l.delItems(index, index);
        }
    }

    public synchronized int getSelectedIndex() {
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            this.selected = l.getSelectedIndexes();
        }
        if (this.selected == null || this.selected.length != 1) {
            return -1;
        }
        return this.selected[0];
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            this.selected = l.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (String)this.items.elementAt(index);
    }

    public synchronized String[] getSelectedItems() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes == null) {
            return new String[0];
        }
        String[] retvals = new String[indexes.length];
        if (retvals.length > 0) {
            int i = 0;
            while (i < retvals.length) {
                retvals[i] = (String)this.items.elementAt(indexes[i]);
                ++i;
            }
        }
        return retvals;
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes == null) {
            return new Object[0];
        }
        Object[] retvals = new Object[indexes.length];
        if (retvals.length > 0) {
            int i = 0;
            while (i < retvals.length) {
                retvals[i] = this.items.elementAt(indexes[i]);
                ++i;
            }
        }
        return retvals;
    }

    public boolean isIndexSelected(int index) {
        return this.isSelected(index);
    }

    public boolean isSelected(int index) {
        int[] indexes = this.getSelectedIndexes();
        int i = 0;
        while (i < indexes.length) {
            if (indexes[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void makeVisible(int index) throws IllegalArgumentException {
        this.visibleIndex = index;
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.makeVisible(index);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void select(int index) {
        ListPeer lp = (ListPeer)this.getPeer();
        if (lp != null) {
            lp.select(index);
        }
        if (this.selected != null) {
            boolean found = false;
            int i = 0;
            while (i < this.selected.length) {
                if (this.selected[i] == index) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                if (!this.isMultipleMode()) {
                    this.selected = new int[]{index};
                    return;
                }
                int[] temp = new int[this.selected.length + 1];
                System.arraycopy(this.selected, 0, temp, 0, this.selected.length);
                temp[this.selected.length] = index;
                this.selected = temp;
            }
        } else {
            this.selected = new int[1];
            this.selected[0] = index;
        }
    }

    public synchronized void deselect(int index) {
        if (this.isSelected(index)) {
            ListPeer lp = (ListPeer)this.getPeer();
            if (lp != null) {
                lp.deselect(index);
            }
            int[] temp = new int[this.selected.length - 1];
            int i = 0;
            while (i < temp.length) {
                if (this.selected[i] == index) {
                    System.arraycopy(this.selected, i + 1, temp, i, this.selected.length - i - 1);
                    break;
                }
                temp[i] = this.selected[i];
                ++i;
            }
            this.selected = temp;
        }
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    @Override
    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    protected String paramString() {
        return "multiple=" + this.multipleMode + ",rows=" + this.rows + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ActionListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.action_listeners, listenerType);
        }
        if (listenerType == ItemListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "list" + List.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_list_number++;
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private static final long serialVersionUID = 7924617370136012829L;

        public AccessibleAWTList() {
            super(List.this);
            List.this.addItemListener(this);
            List.this.addActionListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.SELECTABLE);
            if (List.this.isMultipleMode()) {
                states.add(AccessibleState.MULTISELECTABLE);
            }
            return states;
        }

        public int getAccessibleChildrenCount() {
            return List.this.getItemCount();
        }

        public Accessible getAccessibleChild(int i) {
            if (i >= List.this.getItemCount()) {
                return null;
            }
            return new AccessibleAWTListChild(List.this, i);
        }

        public int getAccessibleSelectionCount() {
            return List.this.getSelectedIndexes().length;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int i) {
            int[] items = List.this.getSelectedIndexes();
            if (i >= items.length) {
                return null;
            }
            return new AccessibleAWTListChild(List.this, items[i]);
        }

        public boolean isAccessibleChildSelected(int i) {
            return List.this.isIndexSelected(i);
        }

        public void addAccessibleSelection(int i) {
            List.this.select(i);
        }

        public void removeAccessibleSelection(int i) {
            List.this.deselect(i);
        }

        public void clearAccessibleSelection() {
            int i = 0;
            while (i < List.this.getItemCount()) {
                List.this.deselect(i);
                ++i;
            }
        }

        public void selectAllAccessibleSelection() {
            if (List.this.isMultipleMode()) {
                int i = 0;
                while (i < List.this.getItemCount()) {
                    List.this.select(i);
                    ++i;
                }
            }
        }

        public void itemStateChanged(ItemEvent event) {
        }

        public void actionPerformed(ActionEvent event) {
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private static final long serialVersionUID = 4412022926028300317L;
            private List parent;
            private int indexInParent;

            public AccessibleAWTListChild(List parent, int indexInParent) {
                super(List.this);
                this.parent = parent;
                this.indexInParent = indexInParent;
                if (parent == null) {
                    this.indexInParent = -1;
                }
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet states = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    states.add(AccessibleState.SELECTED);
                }
                return states;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }
        }
    }
}

