/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThreadLocalMap {
    private static final int LOG_INITIAL_SIZE = 3;
    private static final float MAX_OCCUPANCY = 0.7f;
    private static final float TARGET_OCCUPANCY = 0.5f;
    private static final Entry deletedEntry = new Entry(null);
    private Entry[] entries = new Entry[1];
    private int hashMask = 0;
    private int count = 0;

    ThreadLocalMap() {
    }

    private void newEntryArray(int newSize) {
        int mask = newSize - 1;
        Entry[] oldEntries = this.entries;
        this.entries = new Entry[newSize];
        this.hashMask = mask;
        this.count = 0;
        if (oldEntries != null) {
            Entry[] entryArray = oldEntries;
            int n = oldEntries.length;
            int n2 = 0;
            while (n2 < n) {
                Entry e = entryArray[n2];
                if (e != null) {
                    ThreadLocal key = (ThreadLocal)e.get();
                    if (e != deletedEntry && key != null) {
                        int i = key.fastHash & mask;
                        while (true) {
                            if (this.entries[i] == null) {
                                this.entries[i] = e;
                                ++this.count;
                                break;
                            }
                            i = i + 1 & mask;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void overflow() {
        if (this.entries.length == 1) {
            this.newEntryArray(8);
            return;
        }
        int deleted = 0;
        int i = 0;
        while (i < this.entries.length) {
            Entry e = this.entries[i];
            if (e != null) {
                if (e == deletedEntry) {
                    ++deleted;
                } else if (e.get() == null) {
                    this.entries[i] = deletedEntry;
                    ++deleted;
                }
            }
            ++i;
        }
        if ((float)(this.count - deleted) <= 0.5f * (float)this.entries.length) {
            this.newEntryArray(this.entries.length);
            return;
        }
        this.newEntryArray(this.entries.length << 1);
    }

    public Object get(ThreadLocal<?> key) {
        int mask = this.hashMask;
        int i = key.fastHash & mask;
        while (true) {
            Entry e;
            if ((e = this.entries[i]) != null) {
                if (e.get() == key) {
                    return e.value;
                }
            } else {
                return ThreadLocal.sentinel;
            }
            i = i + 1 & mask;
        }
    }

    public void set(ThreadLocal<?> key, Object value) {
        if ((float)(this.count + 1) >= 0.7f * (float)this.entries.length) {
            this.overflow();
        }
        int mask = this.hashMask;
        int i = key.fastHash & mask;
        while (true) {
            Entry e;
            if ((e = this.entries[i]) == null || e == deletedEntry) {
                if (e == null) {
                    ++this.count;
                }
                this.entries[i] = e = new Entry(key);
                e.value = value;
                return;
            }
            ThreadLocal entryKey = (ThreadLocal)e.get();
            if (entryKey == null) {
                this.entries[i] = deletedEntry;
            } else if (entryKey == key) {
                e.value = value;
                return;
            }
            i = i + 1 & mask;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(ThreadLocal<?> key) {
        Entry e;
        int mask = this.hashMask;
        int i = key.fastHash & mask;
        while ((e = this.entries[i]) != null) {
            ThreadLocal entryKey = (ThreadLocal)e.get();
            if (entryKey != key) {
                if (entryKey == null) {
                    this.entries[i] = deletedEntry;
                }
            } else {
                this.entries[i] = deletedEntry;
                return;
            }
            i = i + 1 & mask;
        }
    }

    void clear() {
        this.entries = null;
    }

    public void inherit(ThreadLocalMap parentMap) {
        Entry[] entryArray = parentMap.entries;
        int n = parentMap.entries.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadLocal key;
            Entry e = entryArray[n2];
            if (e != null && e != deletedEntry && (key = (ThreadLocal)e.get()) instanceof InheritableThreadLocal) {
                this.set(key, ((InheritableThreadLocal)key).childValue(e.value));
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry
    extends WeakReference<ThreadLocal<?>> {
        Object value;

        Entry(ThreadLocal<?> threadLocal) {
            super(threadLocal);
        }
    }
}

