/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.util.Properties;

public abstract class Provider
extends Properties
implements Serializable {
    private static final long serialVersionUID = -4298000515446427739L;
    private String info;
    private String name;
    private double version;

    protected Provider(String name, double version, String info) {
        this.name = name;
        this.version = version;
        this.info = info;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    public Object put(Object key, Object value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("putProviderProperty." + this.name);
        }
        return super.put(this.toCanonicalKey(key), value);
    }

    public Object get(Object key) {
        return super.get(this.toCanonicalKey(key));
    }

    public Object remove(Object key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeProviderProperty." + this.name);
        }
        return super.remove(this.toCanonicalKey(key));
    }

    public void clear() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("clearProviderProperties." + this.name);
        }
        super.clear();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": name=" + this.getName() + " version=" + this.version;
    }

    private Object toCanonicalKey(Object key) {
        if (key.getClass().isAssignableFrom(String.class)) {
            return ((String)key).toUpperCase();
        }
        return key;
    }
}

