#!/bin/sh
export PATH='/usr/obj/ports/hs-dbus-0.10.12/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.12
id: dbus-0.10.12-cb658ab7a2e88d7e8ff2aa44699ec6ea
key: dbus_DBnqWRFYSDCGATcO6p8Nya
license: GPL-3
maintainer: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Introspection DBus.Socket DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.12
library-dirs: /usr/local/lib/ghc/dbus-0.10.12
data-dir: /usr/local/share/hs-dbus-0.10.12
hs-libraries: HSdbus-0.10.12-DBnqWRFYSDCGATcO6p8Nya
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    cereal-0.4.1.0-232b9a6d4ff24340007b7dfc3284533f
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    libxml-sax-0.7.5-5c696e4db047780818b759f3aafb9793
    network-2.6.2.1-7074df06df1d0866c49f7a1ab750c7fa
    parsec-3.1.9-d2c139e64f1c778850f609850ceafa14
    random-1.1-c46cc413d88c0a330b5495d03f0ed464
    text-1.2.1.3-d050b6e0fc32994b2ea423ca0ac22057
    transformers-0.4.2.0-81450cd8f86b36eaa8fa0cbaf6efc3a3
    unix-2.7.1.0-5a50660ad24f11b222d9ab03451b0d1d
    vector-0.11.0.0-299aefb173ce5a731565d31f609a0cfd
    xml-types-0.3.6-f0364a160657addbe50f925505f0184b
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.12/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.12/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
