#!/bin/sh
export PATH='/usr/obj/ports/hs-enumerator-0.4.20/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: enumerator
version: 0.4.20
id: enumerator-0.4.20-cffea6c0d78175f3c2b0abf830d00547
key: enume_H7gU0nKN2x4EiMqcJDRfeO
license: MIT
copyright: 2010-2011 John Millikin, 2011 Mikhail Vorozhtsov
maintainer: jmillikin@gmail.com
stability: experimental
homepage: https://john-millikin.com/software/enumerator/
synopsis: Reliable, high-performance processing with left-fold enumerators
description:
    Typical buffer&#x2013;based incremental I/O is based around a single loop,
    which reads data from some source (such as a socket or file), transforms
    it, and generates one or more outputs (such as a line count, HTTP
    responses, or modified file). Although efficient and safe, these loops are
    all single&#x2013;purpose; it is difficult or impossible to compose
    buffer&#x2013;based processing loops.
    .
    Haskell&#x2019;s concept of &#x201C;lazy I/O&#x201D; allows pure code to
    operate on data from an external source. However, lazy I/O has several
    shortcomings. Most notably, resources such as memory and file handles can
    be retained for arbitrarily long periods of time, causing unpredictable
    performance and error conditions.
    .
    Enumerators are an efficient, predictable, and safe alternative to lazy
    I/O. Discovered by Oleg Kiselyov, they allow large datasets to be processed
    in near&#x2013;constant space by pure code. Although somewhat more complex
    to write, using enumerators instead of lazy I/O produces more correct
    programs.
    .
    This library contains an enumerator implementation for Haskell, designed to
    be both simple and efficient. Three core types are defined, along with
    numerous helper functions:
    .
    * /Iteratee/: Data sinks, analogous to left folds. Iteratees consume
    a sequence of /input/ values, and generate a single /output/ value.
    Many iteratees are designed to perform side effects (such as printing to
    @stdout@), so they can also be used as monad transformers.
    .
    * /Enumerator/: Data sources, which generate input sequences. Typical
    enumerators read from a file handle, socket, random number generator, or
    other external stream. To operate, enumerators are passed an iteratee, and
    provide that iteratee with input until either the iteratee has completed its
    computation, or EOF.
    .
    * /Enumeratee/: Data transformers, which operate as both enumerators and
    iteratees. Enumeratees read from an /outer/ enumerator, and provide the
    transformed data to an /inner/ iteratee.
category: Data, Enumerator
author: John Millikin <jmillikin@gmail.com>
exposed: True
exposed-modules:
    Data.Enumerator Data.Enumerator.Binary Data.Enumerator.Internal
    Data.Enumerator.IO Data.Enumerator.List Data.Enumerator.Text
    Data.Enumerator.Trans
hidden-modules: Data.Enumerator.Compatibility Data.Enumerator.Util
trusted: False
import-dirs: /usr/local/lib/ghc/enumerator-0.4.20
library-dirs: /usr/local/lib/ghc/enumerator-0.4.20
data-dir: /usr/local/share/hs-enumerator-0.4.20
hs-libraries: HSenumerator-0.4.20-H7gU0nKN2x4EiMqcJDRfeO
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    text-1.2.1.3-d050b6e0fc32994b2ea423ca0ac22057
    transformers-0.4.2.0-81450cd8f86b36eaa8fa0cbaf6efc3a3
haddock-interfaces: /usr/local/share/doc/hs-enumerator-0.4.20/html/enumerator.haddock
haddock-html: /usr/local/share/doc/hs-enumerator-0.4.20/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
