#!/bin/sh
export PATH='/usr/obj/ports/hs-tf-random-0.5/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: tf-random
version: 0.5
id: tf-random-0.5-6d2db23529e8f051b44d250b07f9d283
key: tfran_1eLmkn3WUnC8NZpPuDLGKF
license: BSD3
maintainer: Michał Pałka <michal.palka@chalmers.se>
synopsis: High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.
    .
    The package provides the following:
    .
    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.
    .
    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.
    .
    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.
    .
    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.
    .
    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.
    .
    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.
category: Random
author: Michał Pałka <michal.palka@chalmers.se>
exposed: True
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances
trusted: False
import-dirs: /usr/local/lib/ghc/tf-random-0.5
library-dirs: /usr/local/lib/ghc/tf-random-0.5
data-dir: /usr/local/share/hs-tf-random-0.5
hs-libraries: HStf-random-0.5-1eLmkn3WUnC8NZpPuDLGKF
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    primitive-0.6.1.0-b2a7b9f8d5591c0d4ce7ef238a3217d2
    random-1.1-c46cc413d88c0a330b5495d03f0ed464
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
haddock-interfaces: /usr/local/share/doc/hs-tf-random-0.5/html/tf-random.haddock
haddock-html: /usr/local/share/doc/hs-tf-random-0.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
