/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.AppletStub;
import java.awt.Container;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletViewerPanelAccess;
import sun.awt.SunToolkit;

public class NetxPanel
extends AppletViewerPanelAccess
implements SplashController {
    private final PluginParameters parameters;
    private PluginBridge bridge = null;
    private AppletInstance appInst = null;
    private SplashController splashController;
    private volatile boolean initialized;
    private static final Map<String, ThreadGroup> uKeyToTG = new HashMap<String, ThreadGroup>();
    private static final Object TGMapMutex = new Object();
    private static final ConcurrentMap<String, Boolean> appContextCreated = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetxPanel(URL documentURL, PluginParameters params) {
        super(documentURL, params.getUnderlyingHashtable());
        this.parameters = params;
        this.initialized = false;
        String uniqueKey = params.getUniqueKey(this.getCodeBase());
        Object object = TGMapMutex;
        synchronized (object) {
            if (!uKeyToTG.containsKey(uniqueKey)) {
                ThreadGroup tg = new ThreadGroup(Launcher.mainGroup, this.getDocumentURL().toString());
                uKeyToTG.put(uniqueKey, tg);
            }
        }
    }

    protected void showAppletException(Throwable t) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, t);
        super.showAppletException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ourRunLoader() {
        try {
            this.bridge = new PluginBridge(this.getBaseURL(), this.getDocumentBase(), this.getJarFiles(), this.getCode(), this.getWidth(), this.getHeight(), this.parameters);
            this.doInit = true;
            this.dispatchAppletEvent(51235, null);
            this.status = 1;
            Launcher l = new Launcher(false);
            this.appInst = (AppletInstance)l.launch(this.bridge, (Container)((Object)this));
            this.setApplet(this.appInst.getApplet());
            if (this.getApplet() != null) {
                this.getApplet().setStub((AppletStub)((Object)this));
                this.getApplet().setVisible(false);
                this.add("Center", this.getApplet());
                this.showAppletStatus("loaded");
                this.validate();
            }
        }
        catch (Exception e) {
            this.status = 7;
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            this.replaceSplash(SplashUtils.getErrorSplashScreen(this.getWidth(), this.getHeight(), e));
        }
        finally {
            this.initialized = true;
            this.dispatchAppletEvent(51236, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void createAppletThread() {
        Object object = JNLPRuntime.initMutex;
        synchronized (object) {
            if (!JNLPRuntime.isInitialized()) {
                OutputController.getLogger().log("initializing JNLPRuntime...");
                JNLPRuntime.initialize(false);
            } else {
                OutputController.getLogger().log("JNLPRuntime already initialized");
            }
        }
        this.handler = new Thread(this.getThreadGroup(), (Runnable)((Object)this), "NetxPanelThread@" + this.getDocumentURL());
        this.handler.start();
    }

    public void updateSizeInAtts(int height, int width) {
        this.parameters.updateSize(width, height);
    }

    public ClassLoader getAppletClassLoader() {
        return this.appInst.getClassLoader();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup() {
        Object object = TGMapMutex;
        synchronized (object) {
            return uKeyToTG.get(this.parameters.getUniqueKey(this.getCodeBase()));
        }
    }

    public void createNewAppContext() {
        if (Thread.currentThread().getThreadGroup() != this.getThreadGroup()) {
            throw new RuntimeException("createNewAppContext called from the wrong thread.");
        }
        if (null == appContextCreated.putIfAbsent(this.parameters.getUniqueKey(this.getCodeBase()), Boolean.TRUE)) {
            SunToolkit.createNewAppContext();
        }
    }

    public void setAppletViewerFrame(SplashController framePanel) {
        this.splashController = framePanel;
    }

    @Override
    public void removeSplash() {
        this.splashController.removeSplash();
    }

    @Override
    public void replaceSplash(SplashPanel r) {
        this.splashController.replaceSplash(r);
    }

    @Override
    public int getSplashWidth() {
        return this.splashController.getSplashWidth();
    }

    @Override
    public int getSplashHeigth() {
        return this.splashController.getSplashHeigth();
    }
}

