/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class NativeLibraryStorage {
    private ResourceTracker tracker;
    private List<File> nativeSearchDirectories = new ArrayList<File>();
    private File jarEntryDirectory = null;
    public static final String[] NATIVE_LIBRARY_EXTENSIONS = new String[]{".so", ".dylib", ".jnilib", ".framework", ".dll"};

    public NativeLibraryStorage(ResourceTracker tracker) {
        this.tracker = tracker;
    }

    public void cleanupTemporaryFolder() {
        if (this.jarEntryDirectory != null) {
            OutputController.getLogger().log("Cleaning up native directory" + this.jarEntryDirectory.getAbsolutePath());
            try {
                FileUtils.recursiveDelete(this.jarEntryDirectory, new File(System.getProperty("java.io.tmpdir")));
                this.jarEntryDirectory = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addSearchDirectory(File directory) {
        this.nativeSearchDirectories.add(directory);
    }

    public List<File> getSearchDirectories() {
        return this.nativeSearchDirectories;
    }

    public File findLibrary(String fileName) {
        for (File dir : this.getSearchDirectories()) {
            File target = new File(dir, fileName);
            if (!target.exists()) continue;
            return target;
        }
        return null;
    }

    public void addSearchJar(URL jarLocation) {
        OutputController.getLogger().log("Activate native: " + jarLocation);
        File localFile = this.tracker.getCacheFile(jarLocation);
        if (localFile == null) {
            return;
        }
        try {
            JarFile jarFile = new JarFile(localFile, false);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.isDirectory()) continue;
                String name = new File(e.getName()).getName();
                boolean isLibrary = false;
                for (String suffix : NATIVE_LIBRARY_EXTENSIONS) {
                    if (!name.endsWith(suffix)) continue;
                    isLibrary = true;
                    break;
                }
                if (!isLibrary) continue;
                this.ensureNativeStoreDirectory();
                File outFile = new File(this.jarEntryDirectory, name);
                if (!outFile.isFile()) {
                    FileUtils.createRestrictedFile(outFile, true);
                }
                CacheUtil.streamCopy(jarFile.getInputStream(e), new FileOutputStream(outFile));
            }
            jarFile.close();
        }
        catch (IOException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    void ensureNativeStoreDirectory() {
        if (this.jarEntryDirectory == null) {
            this.jarEntryDirectory = NativeLibraryStorage.createNativeStoreDirectory();
            this.addSearchDirectory(this.jarEntryDirectory);
        }
    }

    private static File createNativeStoreDirectory() {
        int rand = (int)((Math.random() * 2.0 - 1.0) * 2.147483647E9);
        File nativeDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "netx-native-" + (rand & 0xFFFF));
        File parent = nativeDir.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            return null;
        }
        try {
            FileUtils.createRestrictedDirectory(nativeDir);
            return nativeDir;
        }
        catch (IOException e) {
            return null;
        }
    }
}

