/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.sourceforge.jnlp.cache.CacheDirectory;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.DirectoryNode;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.ui.NonEditableTableModel;

public class CachePane
extends JPanel {
    JDialog parent;
    DeploymentConfiguration config;
    private String location;
    private JComponent defaultFocusComponent;
    DirectoryNode root;
    String[] columns = new String[]{Translator.R("CVCPColName"), Translator.R("CVCPColPath"), Translator.R("CVCPColType"), Translator.R("CVCPColDomain"), Translator.R("CVCPColSize"), Translator.R("CVCPColLastModified")};
    JTable cacheTable;
    private JButton deleteButton;
    private JButton refreshButton;
    private JButton doneButton;
    private JButton cleanAll;

    public CachePane(JDialog parent, DeploymentConfiguration config) {
        super(new BorderLayout());
        this.parent = parent;
        this.config = config;
        this.location = config.getProperty("deployment.user.cachedir");
        this.addComponents();
    }

    private void addComponents() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        NonEditableTableModel model = new NonEditableTableModel(this.columns, 0);
        this.cacheTable = new JTable(model);
        this.cacheTable.getSelectionModel().setSelectionMode(0);
        this.cacheTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CachePane.this.cacheTable.getSelectionModel().isSelectionEmpty()) {
                    CachePane.this.deleteButton.setEnabled(false);
                } else {
                    CachePane.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.cacheTable.setAutoResizeMode(1);
        this.cacheTable.setPreferredScrollableViewportSize(new Dimension(600, 200));
        this.cacheTable.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.cacheTable);
        TableRowSorter<NonEditableTableModel> tableSorter = new TableRowSorter<NonEditableTableModel>(model);
        Comparator comparator = new Comparator<Comparable<?>>(){

            @Override
            public final int compare(Comparable a, Comparable b) {
                return a.compareTo(b);
            }
        };
        tableSorter.setComparator(1, comparator);
        tableSorter.setComparator(4, comparator);
        tableSorter.setComparator(5, comparator);
        this.cacheTable.setRowSorter(tableSorter);
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                switch (column) {
                    case 1: {
                        super.setText(((File)value).getAbsolutePath());
                        break;
                    }
                    case 4: {
                        super.setText(NumberFormat.getInstance().format(value));
                        break;
                    }
                    case 5: {
                        super.setText(DateFormat.getDateInstance().format(value));
                    }
                }
                return this;
            }
        };
        this.cacheTable.getColumn(this.columns[1]).setCellRenderer(tableCellRenderer);
        this.cacheTable.getColumn(this.columns[4]).setCellRenderer(tableCellRenderer);
        this.cacheTable.getColumn(this.columns[5]).setCellRenderer(tableCellRenderer);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        topPanel.add((Component)scrollPane, c);
        this.add((Component)topPanel, "Center");
        this.add(this.createButtonPanel(), "South");
    }

    private Component createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        JPanel leftPanel = new JPanel(new FlowLayout(3));
        JPanel rightPanel = new JPanel(new FlowLayout(4));
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        this.deleteButton = new JButton(Translator.R("CVCPButDelete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachePane.this.disableButtons();
                CachePane.this.invokeLaterDelete();
            }
        });
        this.deleteButton.setEnabled(false);
        buttons.add(this.deleteButton);
        this.cleanAll = new JButton(Translator.R("CVCPCleanCache"));
        this.cleanAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachePane.this.disableButtons();
                CachePane.this.invokeLaterDeleteAll();
            }
        });
        buttons.add(this.cleanAll);
        this.refreshButton = new JButton(Translator.R("CVCPButRefresh"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachePane.this.disableButtons();
                CachePane.this.invokeLaterPopulateTable();
            }
        });
        this.refreshButton.setEnabled(false);
        buttons.add(this.refreshButton);
        this.doneButton = new JButton(Translator.R("ButDone"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(CachePane.this.parent, 201));
            }
        });
        int maxWidth = 0;
        int maxHeight = 0;
        for (JButton button : buttons) {
            maxWidth = Math.max(button.getMinimumSize().width, maxWidth);
            maxHeight = Math.max(button.getMinimumSize().height, maxHeight);
        }
        int wantedWidth = maxWidth + 10;
        int wantedHeight = maxHeight;
        for (JButton button : buttons) {
            button.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
            leftPanel.add(button);
        }
        this.doneButton.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
        this.doneButton.setEnabled(false);
        rightPanel.add(this.doneButton);
        buttonPanel.add(leftPanel);
        buttonPanel.add(rightPanel);
        return buttonPanel;
    }

    private void invokeLaterDelete() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int row;
                    FileLock fl;
                    block18: {
                        fl = null;
                        File netxRunningFile = new File(CachePane.this.config.getProperty("deployment.user.runningfile"));
                        if (!netxRunningFile.exists()) {
                            try {
                                FileUtils.createParentDir(netxRunningFile);
                                FileUtils.createRestrictedFile(netxRunningFile, true);
                            }
                            catch (IOException e1) {
                                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e1);
                            }
                        }
                        try {
                            fl = FileUtils.getFileLock(netxRunningFile.getPath(), false, false);
                        }
                        catch (FileNotFoundException e1) {
                            // empty catch block
                        }
                        row = CachePane.this.cacheTable.getSelectedRow();
                        if (fl != null) break block18;
                        JOptionPane.showMessageDialog(CachePane.this.parent, Translator.R("CCannotClearCache"));
                        return;
                    }
                    try {
                        int modelRow = CachePane.this.cacheTable.convertRowIndexToModel(row);
                        DirectoryNode fileNode = (DirectoryNode)CachePane.this.cacheTable.getModel().getValueAt(modelRow, 0);
                        if (fileNode.getFile().delete()) {
                            this.updateRecentlyUsed(fileNode.getFile());
                            fileNode.getParent().removeChild(fileNode);
                            FileUtils.deleteWithErrMesg(fileNode.getInfoFile());
                            ((NonEditableTableModel)CachePane.this.cacheTable.getModel()).removeRow(modelRow);
                            CachePane.this.cacheTable.getSelectionModel().clearSelection();
                            CacheDirectory.cleanParent(fileNode);
                        }
                    }
                    catch (Exception modelRow) {
                        // empty catch block
                    }
                    if (fl != null) {
                        try {
                            fl.release();
                            fl.channel().close();
                        }
                        catch (IOException e1) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e1);
                        }
                    }
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, exception);
                }
                finally {
                    CachePane.this.restoreDisabled();
                }
            }

            private void updateRecentlyUsed(File f) {
                File recentlyUsedFile = new File(CachePane.this.location + File.separator + "recently_used");
                PropertiesFile pf = new PropertiesFile(recentlyUsedFile);
                pf.load();
                Enumeration<Object> en = pf.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!pf.get(key).equals(f.getAbsolutePath())) continue;
                    pf.remove(key);
                }
                pf.store();
            }
        });
    }

    private void invokeLaterDeleteAll() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CachePane.visualCleanCache(CachePane.this.parent);
                    CachePane.this.populateTable();
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, exception);
                }
                finally {
                    CachePane.this.restoreDisabled();
                }
            }
        });
    }

    final void invokeLaterPopulateTable() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CachePane.this.populateTable();
                    if (CachePane.this.cacheTable.getModel().getRowCount() == 0) {
                        CachePane.this.cacheTable.setEnabled(false);
                        CachePane.this.cacheTable.setBackground(SystemColor.control);
                        CachePane.this.deleteButton.setEnabled(false);
                    } else {
                        CachePane.this.cacheTable.setEnabled(true);
                        CachePane.this.cacheTable.setBackground(SystemColor.text);
                    }
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, exception);
                }
                finally {
                    CachePane.this.refreshButton.setEnabled(true);
                    CachePane.this.doneButton.setEnabled(true);
                    CachePane.this.cleanAll.setEnabled(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTable() {
        try {
            this.parent.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            NonEditableTableModel tableModel = (NonEditableTableModel)this.cacheTable.getModel();
            tableModel.setRowCount(0);
            for (Object[] v : this.generateData(this.root)) {
                tableModel.addRow(v);
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, exception);
        }
        finally {
            this.parent.getContentPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private ArrayList<Object[]> generateData(DirectoryNode root) {
        root = new DirectoryNode("Root", this.location, null);
        CacheDirectory.getDirStructure(root);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (DirectoryNode identifier : root.getChildren()) {
            for (DirectoryNode type : identifier.getChildren()) {
                for (DirectoryNode domain : type.getChildren()) {
                    for (DirectoryNode leaf : CacheDirectory.getLeafData(domain)) {
                        File f = leaf.getFile();
                        Object[] o = new Object[]{leaf, f.getParentFile(), type, domain, f.length(), new Date(f.lastModified())};
                        data.add(o);
                    }
                }
            }
        }
        return data;
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }

    public void disableButtons() {
        this.parent.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
        this.deleteButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.doneButton.setEnabled(false);
        this.cleanAll.setEnabled(false);
    }

    public void restoreDisabled() {
        this.cleanAll.setEnabled(true);
        if (!this.cacheTable.getSelectionModel().isSelectionEmpty()) {
            this.deleteButton.setEnabled(true);
        }
        this.refreshButton.setEnabled(true);
        this.doneButton.setEnabled(true);
        if (this.cacheTable.getModel().getRowCount() == 0) {
            this.cacheTable.setEnabled(false);
            this.cacheTable.setBackground(SystemColor.control);
        }
        this.parent.getContentPane().setCursor(Cursor.getDefaultCursor());
    }

    public static void visualCleanCache(Component parent) {
        try {
            boolean success = CacheUtil.clearCache();
            if (!success) {
                JOptionPane.showMessageDialog(parent, Translator.R("CCannotClearCache"));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(parent, Translator.R("CCannotClearCache"));
        }
    }
}

