/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.net.www.protocol.jar.URLJarFile;
import sun.net.www.protocol.jar.URLJarFileCallBack;

final class CachedJarFileCallback
implements URLJarFileCallBack {
    private static final CachedJarFileCallback INSTANCE = new CachedJarFileCallback();
    private final Map<URL, URL> mapping = new ConcurrentHashMap<URL, URL>();

    public static synchronized CachedJarFileCallback getInstance() {
        return INSTANCE;
    }

    private CachedJarFileCallback() {
    }

    protected void addMapping(URL remoteUrl, URL localUrl) {
        this.mapping.put(remoteUrl, localUrl);
    }

    @Override
    public JarFile retrieve(URL url) throws IOException {
        URL localUrl = this.mapping.get(url);
        if (localUrl == null) {
            return this.cacheJarFile(url);
        }
        if (UrlUtils.isLocalFile(localUrl)) {
            net.sourceforge.jnlp.util.JarFile returnFile = new net.sourceforge.jnlp.util.JarFile(localUrl.getPath());
            try {
                returnFile.getManifest().getMainAttributes().putValue("Class-Path", "");
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Class-Path attribute cleared for " + returnFile.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return returnFile;
        }
        return null;
    }

    private JarFile cacheJarFile(URL url) throws IOException {
        JarFile result = null;
        int BUF_SIZE = 2048;
        final InputStream in = url.openConnection().getInputStream();
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws IOException {
                    OutputStream out = null;
                    File tmpFile = null;
                    try {
                        tmpFile = File.createTempFile("jar_cache", null);
                        tmpFile.deleteOnExit();
                        out = new FileOutputStream(tmpFile);
                        int read = 0;
                        byte[] buf = new byte[2048];
                        while ((read = in.read(buf)) != -1) {
                            out.write(buf, 0, read);
                        }
                        out.close();
                        out = null;
                        URLJarFile uRLJarFile = new URLJarFile(tmpFile, null);
                        return uRLJarFile;
                    }
                    catch (IOException e) {
                        if (tmpFile != null) {
                            tmpFile.delete();
                        }
                        throw e;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return result;
    }
}

