/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.PacEvaluator;
import net.sourceforge.jnlp.runtime.PacEvaluatorFactory;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class JNLPProxySelector
extends ProxySelector {
    public static final int PROXY_TYPE_UNKNOWN = -1;
    public static final int PROXY_TYPE_NONE = 0;
    public static final int PROXY_TYPE_MANUAL = 1;
    public static final int PROXY_TYPE_AUTO = 2;
    public static final int PROXY_TYPE_BROWSER = 3;
    public static final int FALLBACK_PROXY_PORT = 3128;
    private PacEvaluator pacEvaluator = null;
    private int proxyType = -1;
    private URL autoConfigUrl = null;
    private List<String> bypassList = null;
    private boolean bypassLocal = false;
    private boolean sameProxy = false;
    private String proxyHttpHost;
    private int proxyHttpPort;
    private String proxyHttpsHost;
    private int proxyHttpsPort;
    private String proxyFtpHost;
    private int proxyFtpPort;
    private String proxySocks4Host;
    private int proxySocks4Port;
    private String overrideHosts = null;

    public JNLPProxySelector(DeploymentConfiguration config) {
        this.parseConfiguration(config);
    }

    private void parseConfiguration(DeploymentConfiguration config) {
        this.proxyType = Integer.valueOf(config.getProperty("deployment.proxy.type"));
        String autoConfigString = config.getProperty("deployment.proxy.auto.config.url");
        if (autoConfigString != null) {
            try {
                this.autoConfigUrl = new URL(autoConfigString);
            }
            catch (MalformedURLException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        if (this.autoConfigUrl != null) {
            this.pacEvaluator = PacEvaluatorFactory.getPacEvaluator(this.autoConfigUrl);
        }
        this.bypassList = new ArrayList<String>();
        String proxyBypass = config.getProperty("deployment.proxy.bypass.list");
        if (proxyBypass != null) {
            StringTokenizer tokenizer = new StringTokenizer(proxyBypass, ",");
            while (tokenizer.hasMoreTokens()) {
                String host = tokenizer.nextToken();
                if (host == null || host.trim().length() == 0) continue;
                this.bypassList.add(host);
            }
        }
        this.bypassLocal = Boolean.valueOf(config.getProperty("deployment.proxy.bypass.local"));
        this.sameProxy = Boolean.valueOf(config.getProperty("deployment.proxy.same"));
        this.proxyHttpHost = this.getHost(config, "deployment.proxy.http.host");
        this.proxyHttpPort = this.getPort(config, "deployment.proxy.http.port");
        this.proxyHttpsHost = this.getHost(config, "deployment.proxy.https.host");
        this.proxyHttpsPort = this.getPort(config, "deployment.proxy.https.port");
        this.proxyFtpHost = this.getHost(config, "deployment.proxy.ftp.host");
        this.proxyFtpPort = this.getPort(config, "deployment.proxy.ftp.port");
        this.proxySocks4Host = this.getHost(config, "deployment.proxy.socks.host");
        this.proxySocks4Port = this.getPort(config, "deployment.proxy.socks.port");
        this.overrideHosts = config.getProperty("deployment.proxy.override.hosts");
    }

    private String getHost(DeploymentConfiguration config, String key) {
        String proxyHost = config.getProperty(key);
        if (proxyHost != null) {
            proxyHost = proxyHost.trim();
        }
        return proxyHost;
    }

    private int getPort(DeploymentConfiguration config, String key) {
        int proxyPort = 3128;
        String port = config.getProperty(key);
        if (port != null && port.trim().length() != 0) {
            try {
                proxyPort = Integer.valueOf(port);
            }
            catch (NumberFormatException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        return proxyPort;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        OutputController.getLogger().log("Selecting proxy for: " + uri);
        if (this.inBypassList(uri)) {
            List<Proxy> proxies = Arrays.asList(Proxy.NO_PROXY);
            OutputController.getLogger().log("Selected proxies: " + Arrays.toString(proxies.toArray()));
            return proxies;
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        switch (this.proxyType) {
            case 1: {
                proxies.addAll(this.getFromConfiguration(uri));
                break;
            }
            case 2: {
                proxies.addAll(this.getFromPAC(uri));
                break;
            }
            case 3: {
                proxies.addAll(this.getFromBrowser(uri));
                break;
            }
            default: {
                proxies.add(Proxy.NO_PROXY);
            }
        }
        OutputController.getLogger().log("Selected proxies: " + Arrays.toString(proxies.toArray()));
        return proxies;
    }

    private boolean inBypassList(URI uri) {
        try {
            String scheme = uri.getScheme();
            if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ftp")) {
                URL url = uri.toURL();
                if (this.bypassLocal && this.isLocalHost(url.getHost())) {
                    return true;
                }
                if (this.bypassList.contains(url.getHost())) {
                    return true;
                }
            } else if (scheme.equals("socket")) {
                String host = uri.getHost();
                if (this.bypassLocal && this.isLocalHost(host)) {
                    return true;
                }
                if (this.bypassList.contains(host)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return false;
    }

    private boolean isLocalHost(String host) {
        try {
            if (InetAddress.getByName(host).isLoopbackAddress()) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            if (host.equals(InetAddress.getLocalHost().getHostName())) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            if (host.equals(InetAddress.getLocalHost().getHostAddress())) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    private List<Proxy> getFromConfiguration(URI uri) {
        return JNLPProxySelector.getFromArguments(uri, this.sameProxy, false, this.proxyHttpsHost, this.proxyHttpsPort, this.proxyHttpHost, this.proxyHttpPort, this.proxyFtpHost, this.proxyFtpPort, this.proxySocks4Host, this.proxySocks4Port);
    }

    protected static List<Proxy> getFromArguments(URI uri, boolean sameProxy, boolean sameProxyIncludesSocket, String proxyHttpsHost, int proxyHttpsPort, String proxyHttpHost, int proxyHttpPort, String proxyFtpHost, int proxyFtpPort, String proxySocks4Host, int proxySocks4Port) {
        InetSocketAddress sa;
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        String scheme = uri.getScheme();
        boolean socksProxyAdded = false;
        if (sameProxy) {
            if (proxyHttpHost != null) {
                sa = new InetSocketAddress(proxyHttpHost, proxyHttpPort);
                if (scheme.equals("https") || scheme.equals("http") || scheme.equals("ftp")) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, sa);
                    proxies.add(proxy);
                } else if (scheme.equals("socket") && sameProxyIncludesSocket) {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, sa);
                    proxies.add(proxy);
                    socksProxyAdded = true;
                }
            }
        } else if (scheme.equals("http") && proxyHttpHost != null) {
            sa = new InetSocketAddress(proxyHttpHost, proxyHttpPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        } else if (scheme.equals("https") && proxyHttpsHost != null) {
            sa = new InetSocketAddress(proxyHttpsHost, proxyHttpsPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        } else if (scheme.equals("ftp") && proxyFtpHost != null) {
            sa = new InetSocketAddress(proxyFtpHost, proxyFtpPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        }
        if (!socksProxyAdded && proxySocks4Host != null) {
            sa = new InetSocketAddress(proxySocks4Host, proxySocks4Port);
            proxies.add(new Proxy(Proxy.Type.SOCKS, sa));
            socksProxyAdded = true;
        }
        if (proxies.size() == 0) {
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    protected List<Proxy> getFromPAC(URI uri) {
        if (this.autoConfigUrl == null || uri.getScheme().equals("socket")) {
            return Arrays.asList(Proxy.NO_PROXY);
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        try {
            String proxiesString = this.pacEvaluator.getProxies(uri.toURL());
            proxies.addAll(JNLPProxySelector.getProxiesFromPacResult(proxiesString));
        }
        catch (MalformedURLException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    protected abstract List<Proxy> getFromBrowser(URI var1);

    public static List<Proxy> getProxiesFromPacResult(String pacString) {
        String[] tokens;
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (String token : tokens = pacString.split(";")) {
            InetSocketAddress sa;
            int port;
            String host;
            String hostPortPair;
            if (token.startsWith("PROXY")) {
                hostPortPair = token.substring("PROXY".length()).trim();
                if (!hostPortPair.contains(":")) continue;
                host = hostPortPair.split(":")[0];
                try {
                    port = Integer.valueOf(hostPortPair.split(":")[1]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                sa = new InetSocketAddress(host, port);
                proxies.add(new Proxy(Proxy.Type.HTTP, sa));
                continue;
            }
            if (token.startsWith("SOCKS")) {
                hostPortPair = token.substring("SOCKS".length()).trim();
                if (!hostPortPair.contains(":")) continue;
                host = hostPortPair.split(":")[0];
                try {
                    port = Integer.valueOf(hostPortPair.split(":")[1]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                sa = new InetSocketAddress(host, port);
                proxies.add(new Proxy(Proxy.Type.SOCKS, sa));
                continue;
            }
            if (token.startsWith("DIRECT")) {
                proxies.add(Proxy.NO_PROXY);
                continue;
            }
            OutputController.getLogger().log("Unrecognized proxy token: " + token);
        }
        return proxies;
    }
}

