/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.TemporaryPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TemporaryPermissionsButton
extends JButton {
    private final JPopupMenu menu;
    private final JButton linkedButton;
    private PolicyEditor.PolicyEditorWindow policyEditorWindow = null;
    private final JNLPFile file;
    private final JNLPClassLoader.SecurityDelegate securityDelegate;
    private final Collection<Permission> temporaryPermissions = new HashSet<Permission>();

    public TemporaryPermissionsButton(JNLPFile file, final JNLPClassLoader.SecurityDelegate securityDelegate, JButton linkedButton) {
        super("\u2630");
        this.menu = this.createPolicyPermissionsMenu();
        this.linkedButton = linkedButton;
        this.file = file;
        this.securityDelegate = securityDelegate;
        if (file == null || securityDelegate == null || linkedButton == null) {
            this.setEnabled(false);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Temporary Permissions Button disabled due to null fields. file: " + file + ", securityDelegate: " + securityDelegate + ", linkedButton: " + linkedButton);
        } else {
            linkedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    securityDelegate.addPermissions(TemporaryPermissionsButton.this.temporaryPermissions);
                }
            });
            this.addMouseListener(new PolicyEditorPopupListener(this));
        }
    }

    private JPopupMenu createPolicyPermissionsMenu() {
        JPopupMenu policyMenu = new JPopupMenu();
        JMenuItem launchPolicyEditor = new JMenuItem(Translator.R("CertWarnPolicyEditorItem"));
        launchPolicyEditor.addActionListener(new PolicyEditorLaunchListener());
        policyMenu.add(launchPolicyEditor);
        policyMenu.addSeparator();
        JMenuItem noFileAccess = new JMenuItem(Translator.R("STempPermNoFile"));
        noFileAccess.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.noFileAccess()));
        policyMenu.add(noFileAccess);
        JMenuItem noNetworkAccess = new JMenuItem(Translator.R("STempPermNoNetwork"));
        noNetworkAccess.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.noNetworkAccess()));
        policyMenu.add(noNetworkAccess);
        JMenuItem noFileOrNetwork = new JMenuItem(Translator.R("STempNoFileOrNetwork"));
        noFileOrNetwork.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.noFileOrNetworkAccess()));
        policyMenu.add(noFileOrNetwork);
        policyMenu.addSeparator();
        JMenuItem allFileAccessOnly = new JMenuItem(Translator.R("STempAllFileAndPropertyAccess"));
        allFileAccessOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.allFileAccessAndProperties()));
        policyMenu.add(allFileAccessOnly);
        JMenuItem readLocalFilesAndProperties = new JMenuItem(Translator.R("STempReadLocalFilesAndProperties"));
        readLocalFilesAndProperties.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.readLocalFilesAndProperties()));
        policyMenu.add(readLocalFilesAndProperties);
        JMenuItem reflectionOnly = new JMenuItem(Translator.R("STempReflectionOnly"));
        reflectionOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.reflectionOnly()));
        policyMenu.add(reflectionOnly);
        policyMenu.addSeparator();
        JMenuItem allMedia = new JMenuItem(Translator.R("STempAllMedia"));
        allMedia.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.allMedia()));
        policyMenu.add(allMedia);
        JMenuItem soundOnly = new JMenuItem(Translator.R("STempSoundOnly"));
        soundOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.audioOnly()));
        policyMenu.add(soundOnly);
        JMenuItem clipboardOnly = new JMenuItem(Translator.R("STempClipboardOnly"));
        clipboardOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.clipboardOnly()));
        policyMenu.add(clipboardOnly);
        JMenuItem printOnly = new JMenuItem(Translator.R("STempPrintOnly"));
        printOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.printOnly()));
        policyMenu.add(printOnly);
        return policyMenu;
    }

    private class PolicyEditorPopupListener
    extends MouseAdapter {
        private final Component parent;

        public PolicyEditorPopupListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TemporaryPermissionsButton.this.menu.show(this.parent, e.getX(), e.getY());
        }
    }

    private class PolicyEditorLaunchListener
    implements ActionListener {
        private PolicyEditorLaunchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String filepath;
            String rawFilepath = JNLPRuntime.getConfiguration().getProperty("deployment.user.security.policy");
            try {
                filepath = new URL(rawFilepath).getPath();
            }
            catch (MalformedURLException mfue) {
                filepath = null;
            }
            if (TemporaryPermissionsButton.this.policyEditorWindow == null || TemporaryPermissionsButton.this.policyEditorWindow.getPolicyEditor().isClosed()) {
                TemporaryPermissionsButton.this.policyEditorWindow = PolicyEditor.getPolicyEditorDialog(filepath);
            } else {
                TemporaryPermissionsButton.this.policyEditorWindow.asWindow().toFront();
                TemporaryPermissionsButton.this.policyEditorWindow.asWindow().repaint();
            }
            TemporaryPermissionsButton.this.policyEditorWindow.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            TemporaryPermissionsButton.this.policyEditorWindow.getPolicyEditor().addNewCodebase(TemporaryPermissionsButton.this.file.getCodeBase().toString());
            TemporaryPermissionsButton.this.policyEditorWindow.asWindow().setVisible(true);
            TemporaryPermissionsButton.this.menu.setVisible(false);
        }
    }

    private class TemporaryPermissionsListener
    implements ActionListener {
        private Collection<Permission> permissions;

        public TemporaryPermissionsListener(Collection<Permission> permissions) {
            this.permissions = permissions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TemporaryPermissionsButton.this.temporaryPermissions.clear();
            TemporaryPermissionsButton.this.temporaryPermissions.addAll(this.permissions);
            TemporaryPermissionsButton.this.menu.setVisible(false);
            if (TemporaryPermissionsButton.this.linkedButton != null) {
                TemporaryPermissionsButton.this.linkedButton.doClick();
            }
        }
    }
}

