/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs.auxiliary.remote.behavior.ICommonRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;

public class CommonRemoteCacheAttributes
extends AbstractAuxiliaryCacheAttributes
implements ICommonRemoteCacheAttributes {
    private static final long serialVersionUID = -1555143736942374000L;
    private String remoteServiceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
    private RemoteLocation location;
    private String clusterServers = "";
    private RemoteType remoteType = RemoteType.LOCAL;
    private boolean removeUponRemotePut = true;
    private boolean getOnly = false;
    private boolean localClusterConsistency = false;
    private int rmiSocketFactoryTimeoutMillis = 10000;

    @Override
    public String getRemoteTypeName() {
        return this.remoteType != null ? this.remoteType.toString() : RemoteType.LOCAL.toString();
    }

    @Override
    public void setRemoteTypeName(String string) {
        RemoteType remoteType = RemoteType.valueOf(string);
        if (remoteType != null) {
            this.remoteType = remoteType;
        }
    }

    @Override
    public RemoteType getRemoteType() {
        return this.remoteType;
    }

    @Override
    public void setRemoteType(RemoteType remoteType) {
        this.remoteType = remoteType;
    }

    @Override
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setRemoteServiceName(String string) {
        this.remoteServiceName = string;
    }

    @Override
    public void setRemoteLocation(RemoteLocation remoteLocation) {
        this.location = remoteLocation;
    }

    @Override
    public void setRemoteLocation(String string, int n) {
        this.location = new RemoteLocation(string, n);
    }

    @Override
    public RemoteLocation getRemoteLocation() {
        return this.location;
    }

    @Override
    public String getClusterServers() {
        return this.clusterServers;
    }

    @Override
    public void setClusterServers(String string) {
        this.clusterServers = string;
    }

    @Override
    public boolean getRemoveUponRemotePut() {
        return this.removeUponRemotePut;
    }

    @Override
    public void setRemoveUponRemotePut(boolean bl) {
        this.removeUponRemotePut = bl;
    }

    @Override
    public boolean getGetOnly() {
        return this.getOnly;
    }

    @Override
    public void setGetOnly(boolean bl) {
        this.getOnly = bl;
    }

    @Override
    public boolean isLocalClusterConsistency() {
        return this.localClusterConsistency;
    }

    @Override
    public void setLocalClusterConsistency(boolean bl) {
        this.localClusterConsistency = bl;
    }

    @Override
    public void setRmiSocketFactoryTimeoutMillis(int n) {
        this.rmiSocketFactoryTimeoutMillis = n;
    }

    @Override
    public int getRmiSocketFactoryTimeoutMillis() {
        return this.rmiSocketFactoryTimeoutMillis;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n RemoteCacheAttributes ");
        if (this.location != null) {
            stringBuilder.append("\n remoteHost = [" + this.location.getHost() + "]");
            stringBuilder.append("\n remotePort = [" + this.location.getPort() + "]");
        }
        stringBuilder.append("\n cacheName = [" + this.getCacheName() + "]");
        stringBuilder.append("\n remoteType = [" + (Object)((Object)this.remoteType) + "]");
        stringBuilder.append("\n removeUponRemotePut = [" + this.removeUponRemotePut + "]");
        stringBuilder.append("\n getOnly = [" + this.getOnly + "]");
        return stringBuilder.toString();
    }
}

