/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.shrinking;

import java.util.Set;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShrinkerThread<K, V>
implements Runnable {
    private static final Log log = LogFactory.getLog(ShrinkerThread.class);
    private final CompositeCache<K, V> cache;
    private final long maxMemoryIdleTime;
    private final int maxSpoolPerRun;
    private boolean spoolLimit = false;

    public ShrinkerThread(CompositeCache<K, V> compositeCache) {
        this.cache = compositeCache;
        long l = compositeCache.getCacheAttributes().getMaxMemoryIdleTimeSeconds();
        this.maxMemoryIdleTime = l < 0L ? -1L : l * 1000L;
        this.maxSpoolPerRun = compositeCache.getCacheAttributes().getMaxSpoolPerRun();
        if (this.maxSpoolPerRun != -1) {
            this.spoolLimit = true;
        }
    }

    @Override
    public void run() {
        this.shrink();
    }

    protected void shrink() {
        if (log.isDebugEnabled()) {
            log.debug("Shrinking memory cache for: " + this.cache.getCacheName());
        }
        IMemoryCache<K, V> iMemoryCache = this.cache.getMemoryCache();
        try {
            Set<K> set = iMemoryCache.getKeySet();
            int n = set.size();
            if (log.isDebugEnabled()) {
                log.debug("Keys size: " + n);
            }
            int n2 = 0;
            for (K k : set) {
                ICacheElement<K, V> iCacheElement = iMemoryCache.getQuiet(k);
                if (iCacheElement == null) continue;
                IElementAttributes iElementAttributes = iCacheElement.getElementAttributes();
                boolean bl = false;
                long l = System.currentTimeMillis();
                if (!iCacheElement.getElementAttributes().getIsEternal() && (bl = this.cache.isExpired(iCacheElement, l, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND))) {
                    iMemoryCache.remove(iCacheElement.getKey());
                }
                if (bl || this.maxMemoryIdleTime == -1L) continue;
                if (!this.spoolLimit || n2 < this.maxSpoolPerRun) {
                    long l2 = iElementAttributes.getLastAccessTime();
                    if (l2 + this.maxMemoryIdleTime >= l) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Exceeded memory idle time: " + iCacheElement.getKey());
                    }
                    ++n2;
                    iMemoryCache.remove(iCacheElement.getKey());
                    iMemoryCache.waterfal(iCacheElement);
                    k = null;
                    iCacheElement = null;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("spoolCount = '" + n2 + "'; " + "maxSpoolPerRun = '" + this.maxSpoolPerRun + "'");
                }
                if (!this.spoolLimit || n2 < this.maxSpoolPerRun) continue;
                return;
            }
        }
        catch (Throwable throwable) {
            log.info("Unexpected trouble in shrink cycle", throwable);
            return;
        }
    }
}

