/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RestartAction
extends JosmAction {
    private static final String RESTART_APPLE_SCRIPT = "tell application \"System Events\"\nrepeat until not (exists process \"JOSM\")\ndelay 0.2\nend repeat\nend tell\ntell application \"JOSM\" to activate";

    public RestartAction() {
        super(I18n.tr("Restart", new Object[0]), "restart", I18n.tr("Restart the application.", new Object[0]), Shortcut.registerShortcut("file:restart", I18n.tr("File: {0}", I18n.tr("Restart", new Object[0])), 74, 5010), false);
        this.putValue("help", HelpUtil.ht("/Action/Restart"));
        this.putValue("toolbar", "action/restart");
        if (Main.toolbar != null) {
            Main.toolbar.register(this);
        }
        this.setEnabled(RestartAction.isRestartSupported());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = System.getProperty("josm.restart");
        if ("true".equals(string)) {
            Main.exitJosm(true, 9);
        }
        try {
            RestartAction.restartJOSM();
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public static boolean isRestartSupported() {
        return System.getProperty("sun.java.command") != null;
    }

    public static void restartJOSM() throws IOException {
        if (RestartAction.isRestartSupported() && !Main.exitJosm(false, 0)) {
            return;
        }
        try {
            final List<String> list = Main.isPlatformOsx() && System.getProperty("java.library.path").contains("/JOSM.app/Contents/MacOS") ? RestartAction.getAppleCommands() : RestartAction.getCommands();
            Main.info("Restart " + list);
            if (Main.isDebugEnabled() && Main.pref.getBoolean("restart.debug.simulation")) {
                Main.debug("Restart cancelled to get debug info");
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread("josm-restarter"){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(list.toArray(new String[list.size()]));
                    }
                    catch (IOException iOException) {
                        Main.error(iOException);
                    }
                }
            });
            System.exit(0);
        }
        catch (Exception exception) {
            throw new IOException("Error while trying to restart the application", exception);
        }
    }

    private static List<String> getAppleCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/bin/osascript");
        for (String string : RESTART_APPLE_SCRIPT.split("\n")) {
            arrayList.add("-e");
            arrayList.add(string);
        }
        return arrayList;
    }

    private static List<String> getCommands() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(RestartAction.getJavaRuntime());
        RestartAction.addVMArguments(arrayList);
        String string = System.getProperty("jnlpx.origFilenameArg");
        String string2 = System.getProperty("sun.java.command");
        String[] stringArray = string2.split(" ");
        if (string2.endsWith(".jnlp") && string == null) {
            if (Main.isDebugEnabled()) {
                Main.debug("Detected jnlp without jnlpx.origFilenameArg property set");
            }
            arrayList.addAll(Arrays.asList(stringArray));
        } else {
            StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
            for (int i = 1; i < stringArray.length && !stringArray[i - 1].endsWith(".jar"); ++i) {
                stringBuilder.append(' ').append(stringArray[i]);
            }
            String string3 = stringBuilder.toString();
            if (string3.endsWith(".jar")) {
                arrayList.add("-jar");
                arrayList.add(new File(string3).getPath());
            } else {
                arrayList.add("-cp");
                arrayList.add('\"' + System.getProperty("java.class.path") + '\"');
                arrayList.add(stringArray[0]);
            }
            if (string != null) {
                arrayList.add(string);
            }
        }
        arrayList.addAll(Main.getCommandLineArgs());
        return arrayList;
    }

    private static String getJavaRuntime() throws IOException {
        String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + (Main.isPlatformWindows() ? "java.exe" : "java");
        if (!new File(string).isFile()) {
            throw new IOException("Unable to find suitable java runtime at " + string);
        }
        return string;
    }

    private static void addVMArguments(Collection<String> collection) {
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (Main.isDebugEnabled()) {
            Main.debug("VM arguments: " + list);
        }
        for (String string : list) {
            if ((string = string.replace("-Djnlpx.remove=true", "-Djnlpx.remove=false")).contains("-agentlib")) continue;
            collection.add(string);
        }
    }

    public static HelpAwareOptionPane.ButtonSpec getRestartButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Restart", new Object[0]), ImageProvider.get("restart"), I18n.tr("Restart the application.", new Object[0]), HelpUtil.ht("/Action/Restart"), RestartAction.isRestartSupported());
    }

    public static HelpAwareOptionPane.ButtonSpec getCancelButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to restart later.", new Object[0]), null);
    }

    public static HelpAwareOptionPane.ButtonSpec[] getButtonSpecs() {
        return new HelpAwareOptionPane.ButtonSpec[]{RestartAction.getRestartButtonSpec(), RestartAction.getCancelButtonSpec()};
    }
}

