/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberConflictResolverCommand
extends ConflictResolveCommand {
    private final Relation my;
    private final Relation their;
    private final List<RelationMember> mergedMembers;

    public RelationMemberConflictResolverCommand(Relation relation, Relation relation2, List<RelationMember> list) {
        this.my = relation;
        this.their = relation2;
        this.mergedMembers = list;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.my.getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.setMembers(this.mergedMembers);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        OsmDataLayer osmDataLayer = this.getLayer();
        if (!Main.map.mapView.hasLayer(osmDataLayer)) {
            Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), osmDataLayer.toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(osmDataLayer);
        OsmDataLayer osmDataLayer2 = Main.main.getEditLayer();
        super.undoCommand();
        if (!osmDataLayer2.getConflicts().hasConflictForMy(this.my)) {
            osmDataLayer2.getConflicts().add(this.my, this.their);
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mergedMembers == null ? 0 : this.mergedMembers.hashCode());
        n = 31 * n + (this.my == null ? 0 : this.my.hashCode());
        n = 31 * n + (this.their == null ? 0 : this.their.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationMemberConflictResolverCommand relationMemberConflictResolverCommand = (RelationMemberConflictResolverCommand)object;
        if (this.mergedMembers == null ? relationMemberConflictResolverCommand.mergedMembers != null : !this.mergedMembers.equals(relationMemberConflictResolverCommand.mergedMembers)) {
            return false;
        }
        if (this.my == null ? relationMemberConflictResolverCommand.my != null : !this.my.equals(relationMemberConflictResolverCommand.my)) {
            return false;
        }
        return !(this.their == null ? relationMemberConflictResolverCommand.their != null : !this.their.equals(relationMemberConflictResolverCommand.their));
    }
}

