/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.datum.CentricDatum;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.NullDatum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CustomProjection
extends AbstractProjection {
    private static final double METER_PER_UNIT_DEGREE = 111194.87428468118;
    private static final Map<String, Double> UNITS_TO_METERS = CustomProjection.getUnitsToMeters();
    private static final Map<String, Double> PRIME_MERIDANS = CustomProjection.getPrimeMeridians();
    protected String pref;
    protected String name;
    protected String code;
    protected String cacheDir;
    protected Bounds bounds;
    private double metersPerUnit = 111194.87428468118;
    private String axis = "enu";

    public CustomProjection() {
    }

    public CustomProjection(String string) {
        this(null, null, string, null);
    }

    public CustomProjection(String string, String string2, String string3, String string4) {
        this.name = string;
        this.code = string2;
        this.pref = string3;
        this.cacheDir = string4;
        try {
            this.update(string3);
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            try {
                this.update(null);
            }
            catch (ProjectionConfigurationException projectionConfigurationException2) {
                throw new RuntimeException(projectionConfigurationException2);
            }
        }
    }

    public final void update(String string) throws ProjectionConfigurationException {
        this.pref = string;
        if (string == null) {
            this.ellps = Ellipsoid.WGS84;
            this.datum = WGS84Datum.INSTANCE;
            this.proj = new Mercator();
            this.bounds = new Bounds(-85.05112877980659, -180.0, 85.05112877980659, 180.0, true);
        } else {
            String string2;
            Map<String, String> map = CustomProjection.parseParameterList(string, false);
            map = CustomProjection.resolveInits(map, false);
            this.ellps = this.parseEllipsoid(map);
            this.datum = this.parseDatum(map, this.ellps);
            if (this.ellps == null) {
                this.ellps = this.datum.getEllipsoid();
            }
            this.proj = this.parseProjection(map, this.ellps);
            if ("utm".equals(map.get(Param.proj.key))) {
                Integer n;
                string2 = map.get(Param.zone.key);
                if (string2 == null) {
                    throw new ProjectionConfigurationException(I18n.tr("UTM projection (''+proj=utm'') requires ''+zone=...'' parameter.", new Object[0]));
                }
                try {
                    n = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = null;
                }
                if (n == null || n < 1 || n > 60) {
                    throw new ProjectionConfigurationException(I18n.tr("Expected integer value in range 1-60 for ''+zone=...'' parameter.", new Object[0]));
                }
                this.lon0 = 6 * n - 183;
                this.k0 = 0.9996;
                this.x0 = 500000.0;
                double d = this.y0 = map.containsKey(Param.south.key) ? 1.0E7 : 0.0;
            }
            if ((string2 = map.get(Param.x_0.key)) != null) {
                this.x0 = CustomProjection.parseDouble(string2, Param.x_0.key);
            }
            if ((string2 = map.get(Param.y_0.key)) != null) {
                this.y0 = CustomProjection.parseDouble(string2, Param.y_0.key);
            }
            if ((string2 = map.get(Param.lon_0.key)) != null) {
                this.lon0 = CustomProjection.parseAngle(string2, Param.lon_0.key);
            }
            if ((string2 = map.get(Param.pm.key)) != null) {
                this.pm = PRIME_MERIDANS.containsKey(string2) ? PRIME_MERIDANS.get(string2) : CustomProjection.parseAngle(string2, Param.pm.key);
            }
            if ((string2 = map.get(Param.k_0.key)) != null) {
                this.k0 = CustomProjection.parseDouble(string2, Param.k_0.key);
            }
            if ((string2 = map.get(Param.bounds.key)) != null) {
                this.bounds = CustomProjection.parseBounds(string2);
            }
            if ((string2 = map.get(Param.wmssrs.key)) != null) {
                this.code = string2;
            }
            if ((string2 = map.get(Param.units.key)) != null) {
                if (UNITS_TO_METERS.containsKey(string2 = Utils.strip(string2, "\""))) {
                    this.metersPerUnit = UNITS_TO_METERS.get(string2);
                } else {
                    Main.warn("No metersPerUnit found for: " + string2);
                }
            }
            if ((string2 = map.get(Param.to_meter.key)) != null) {
                this.metersPerUnit = CustomProjection.parseDouble(string2, Param.to_meter.key);
            }
            if ((string2 = map.get(Param.axis.key)) != null) {
                this.axis = string2;
            }
        }
    }

    public static Map<String, String> parseParameterList(String string, boolean bl) throws ProjectionConfigurationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = Utils.WHITE_SPACES_PATTERN.split(string.trim());
        if (string.trim().isEmpty()) {
            stringArray = new String[]{};
        }
        for (String string2 : stringArray) {
            String string3;
            String string4;
            if (string2.isEmpty() || string2.charAt(0) != '+') {
                throw new ProjectionConfigurationException(I18n.tr("Parameter must begin with a ''+'' character (found ''{0}'')", string2));
            }
            Matcher matcher = Pattern.compile("\\+([a-zA-Z0-9_]+)(=(.*))?").matcher(string2);
            if (matcher.matches()) {
                string4 = matcher.group(1);
                if ("k".equals(string4)) {
                    string4 = Param.k_0.key;
                }
                string3 = null;
                if (matcher.groupCount() >= 3) {
                    string3 = matcher.group(3);
                    if (string4.equals(Param.proj.key) && ("longlat".equals(string3) || "latlon".equals(string3) || "latlong".equals(string3))) {
                        string3 = "lonlat";
                    }
                }
                if (!Param.paramsByKey.containsKey(string4)) {
                    if (!bl) {
                        throw new ProjectionConfigurationException(I18n.tr("Unknown parameter: ''{0}''.", string4));
                    }
                } else {
                    if (Param.paramsByKey.get((Object)string4).hasValue && string3 == null) {
                        throw new ProjectionConfigurationException(I18n.tr("Value expected for parameter ''{0}''.", string4));
                    }
                    if (!Param.paramsByKey.get((Object)string4).hasValue && string3 != null) {
                        throw new ProjectionConfigurationException(I18n.tr("No value expected for parameter ''{0}''.", string4));
                    }
                }
            } else {
                throw new ProjectionConfigurationException(I18n.tr("Unexpected parameter format (''{0}'')", string2));
            }
            hashMap.put(string4, string3);
        }
        return hashMap;
    }

    public static Map<String, String> resolveInits(Map<String, String> map, boolean bl) throws ProjectionConfigurationException {
        String string = map.get(Param.init.key);
        if (string != null) {
            Map<String, String> map2;
            String string2 = Projections.getInit(string);
            if (string2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Value ''{0}'' for option +init not supported.", string));
            }
            try {
                map2 = CustomProjection.parseParameterList(string2, bl);
                map2 = CustomProjection.resolveInits(map2, bl);
            }
            catch (ProjectionConfigurationException projectionConfigurationException) {
                throw new ProjectionConfigurationException(string + ": " + projectionConfigurationException.getMessage(), projectionConfigurationException);
            }
            map2.putAll(map);
            return map2;
        }
        return map;
    }

    public Ellipsoid parseEllipsoid(Map<String, String> map) throws ProjectionConfigurationException {
        String string = map.get(Param.ellps.key);
        if (string != null) {
            Ellipsoid ellipsoid = Projections.getEllipsoid(string);
            if (ellipsoid == null) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid ''{0}'' not supported.", string));
            }
            return ellipsoid;
        }
        String string2 = map.get(Param.a.key);
        if (string2 != null) {
            double d = CustomProjection.parseDouble(string2, Param.a.key);
            if (map.get(Param.es.key) != null) {
                double d2 = CustomProjection.parseDouble(map, Param.es.key);
                return Ellipsoid.create_a_es(d, d2);
            }
            if (map.get(Param.rf.key) != null) {
                double d3 = CustomProjection.parseDouble(map, Param.rf.key);
                return Ellipsoid.create_a_rf(d, d3);
            }
            if (map.get(Param.f.key) != null) {
                double d4 = CustomProjection.parseDouble(map, Param.f.key);
                return Ellipsoid.create_a_f(d, d4);
            }
            if (map.get(Param.b.key) != null) {
                double d5 = CustomProjection.parseDouble(map, Param.b.key);
                return Ellipsoid.create_a_b(d, d5);
            }
        }
        if (map.containsKey(Param.a.key) || map.containsKey(Param.es.key) || map.containsKey(Param.rf.key) || map.containsKey(Param.f.key) || map.containsKey(Param.b.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Combination of ellipsoid parameters is not supported.", new Object[0]));
        }
        return null;
    }

    public Datum parseDatum(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        String string;
        String string2 = map.get(Param.datum.key);
        if (string2 != null) {
            Datum datum = Projections.getDatum(string2);
            if (datum == null) {
                throw new ProjectionConfigurationException(I18n.tr("Unknown datum identifier: ''{0}''", string2));
            }
            return datum;
        }
        if (ellipsoid == null) {
            if (map.containsKey(Param.no_defs.key)) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid required (+ellps=* or +a=*, +b=*)", new Object[0]));
            }
            ellipsoid = Ellipsoid.WGS84;
        }
        if ((string = map.get(Param.nadgrids.key)) != null) {
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            if ("null".equals(string)) {
                return new NullDatum(null, ellipsoid);
            }
            NTV2GridShiftFileWrapper nTV2GridShiftFileWrapper = Projections.getNTV2Grid(string);
            if (nTV2GridShiftFileWrapper == null) {
                throw new ProjectionConfigurationException(I18n.tr("Grid shift file ''{0}'' for option +nadgrids not supported.", string));
            }
            return new NTV2Datum(string, null, ellipsoid, nTV2GridShiftFileWrapper);
        }
        String string3 = map.get(Param.towgs84.key);
        if (string3 != null) {
            return this.parseToWGS84(string3, ellipsoid);
        }
        return new NullDatum(null, ellipsoid);
    }

    public Datum parseToWGS84(String string, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        int n;
        String[] stringArray = string.split(",");
        if (stringArray.length != 3 && stringArray.length != 7) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''towgs84'' (must be 3 or 7)", new Object[0]));
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            String string2 = stringArray2[n];
            try {
                arrayList.add(Double.valueOf(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of parameter ''towgs84'' (''{0}'')", string2), numberFormatException);
            }
        }
        boolean bl = true;
        for (Double d : arrayList) {
            if (d == 0.0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return new CentricDatum(null, null, ellipsoid);
        }
        boolean bl2 = true;
        for (n = 3; n < arrayList.size(); ++n) {
            if ((Double)arrayList.get(n) == 0.0) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return new ThreeParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2));
        }
        return new SevenParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3), (Double)arrayList.get(4), (Double)arrayList.get(5), (Double)arrayList.get(6));
    }

    public Proj parseProjection(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        Proj proj;
        String string = map.get(Param.proj.key);
        if (string == null) {
            throw new ProjectionConfigurationException(I18n.tr("Projection required (+proj=*)", new Object[0]));
        }
        if ("utm".equals(string)) {
            string = "tmerc";
        }
        if ((proj = Projections.getBaseProjection(string)) == null) {
            throw new ProjectionConfigurationException(I18n.tr("Unknown projection identifier: ''{0}''", string));
        }
        ProjParameters projParameters = new ProjParameters();
        projParameters.ellps = ellipsoid;
        String string2 = map.get(Param.lat_0.key);
        if (string2 != null) {
            projParameters.lat0 = CustomProjection.parseAngle(string2, Param.lat_0.key);
        }
        if ((string2 = map.get(Param.lat_1.key)) != null) {
            projParameters.lat1 = CustomProjection.parseAngle(string2, Param.lat_1.key);
        }
        if ((string2 = map.get(Param.lat_2.key)) != null) {
            projParameters.lat2 = CustomProjection.parseAngle(string2, Param.lat_2.key);
        }
        proj.initialize(projParameters);
        return proj;
    }

    public static Bounds parseBounds(String string) throws ProjectionConfigurationException {
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''+bounds'' (must be 4)", new Object[0]));
        }
        return new Bounds(CustomProjection.parseAngle(stringArray[1], "minlat (+bounds)"), CustomProjection.parseAngle(stringArray[0], "minlon (+bounds)"), CustomProjection.parseAngle(stringArray[3], "maxlat (+bounds)"), CustomProjection.parseAngle(stringArray[2], "maxlon (+bounds)"), false);
    }

    public static double parseDouble(Map<String, String> map, String string) throws ProjectionConfigurationException {
        if (!map.containsKey(string)) {
            throw new ProjectionConfigurationException(I18n.tr("Unknown parameter ''{0}''", string));
        }
        String string2 = map.get(string);
        if (string2 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Expected number argument for parameter ''{0}''", string));
        }
        return CustomProjection.parseDouble(string2, string);
    }

    public static double parseDouble(String string, String string2) throws ProjectionConfigurationException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as number.", string2, string), numberFormatException);
        }
    }

    public static double parseAngle(String string, String string2) throws ProjectionConfigurationException {
        String string3 = string;
        double d = 0.0;
        boolean bl = false;
        Matcher matcher = Pattern.compile("^-").matcher(string3);
        if (matcher.find()) {
            bl = true;
            string3 = string3.substring(matcher.end());
        }
        boolean bl2 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        matcher = Pattern.compile("^(\\d+(\\.\\d*)?)d").matcher(string3);
        if (matcher.find()) {
            string3 = string3.substring(matcher.end());
            d2 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)'").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d3 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)\"").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d4 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if (bl2) {
            d = d2 + d3 / 60.0 + d4 / 3600.0;
        } else {
            matcher = Pattern.compile("^(\\d+(\\.\\d*)?)").matcher(string3);
            if (matcher.find()) {
                string3 = string3.substring(matcher.end());
                d += Double.parseDouble(matcher.group(1));
            }
        }
        matcher = Pattern.compile("^(N|E)", 2).matcher(string3);
        if (matcher.find()) {
            string3 = string3.substring(matcher.end());
        } else {
            matcher = Pattern.compile("^(S|W)", 2).matcher(string3);
            if (matcher.find()) {
                string3 = string3.substring(matcher.end());
                boolean bl3 = bl = !bl;
            }
        }
        if (bl) {
            d = -d;
        }
        if (!string3.isEmpty()) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as coordinate value.", string2, string));
        }
        return d;
    }

    @Override
    public Integer getEpsgCode() {
        if (this.code != null && this.code.startsWith("EPSG:")) {
            try {
                return Integer.valueOf(this.code.substring(5));
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
        }
        return null;
    }

    @Override
    public String toCode() {
        return this.code != null ? this.code : "proj:" + (this.pref == null ? "ERROR" : this.pref);
    }

    @Override
    public String getCacheDirectoryName() {
        return this.cacheDir != null ? this.cacheDir : "proj-" + Utils.md5Hex(this.pref == null ? "" : this.pref).substring(0, 4);
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        if (this.bounds != null) {
            return this.bounds;
        }
        Bounds bounds = this.proj.getAlgorithmBounds();
        if (bounds != null) {
            double d = Math.max(bounds.getMinLon() + this.lon0 + this.pm, -180.0);
            double d2 = Math.min(bounds.getMaxLon() + this.lon0 + this.pm, 180.0);
            return new Bounds(bounds.getMinLat(), d, bounds.getMaxLat(), d2, false);
        }
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : I18n.tr("Custom Projection", new Object[0]);
    }

    @Override
    public double getMetersPerUnit() {
        return this.metersPerUnit;
    }

    @Override
    public boolean switchXY() {
        return this.axis.startsWith("ne");
    }

    private static Map<String, Double> getUnitsToMeters() {
        ConcurrentHashMap<String, Double> concurrentHashMap = new ConcurrentHashMap<String, Double>();
        concurrentHashMap.put("km", 1000.0);
        concurrentHashMap.put("m", 1.0);
        concurrentHashMap.put("dm", 0.1);
        concurrentHashMap.put("cm", 0.01);
        concurrentHashMap.put("mm", 0.001);
        concurrentHashMap.put("kmi", 1852.0);
        concurrentHashMap.put("in", 0.0254);
        concurrentHashMap.put("ft", 0.3048);
        concurrentHashMap.put("yd", 0.9144);
        concurrentHashMap.put("mi", 1609.344);
        concurrentHashMap.put("fathom", 1.8288);
        concurrentHashMap.put("chain", 20.1168);
        concurrentHashMap.put("link", 0.201168);
        concurrentHashMap.put("us-in", 0.025400050800101603);
        concurrentHashMap.put("us-ft", 0.304800609601219);
        concurrentHashMap.put("us-yd", 0.914401828803658);
        concurrentHashMap.put("us-ch", 20.11684023368047);
        concurrentHashMap.put("us-mi", 1609.347218694437);
        concurrentHashMap.put("ind-yd", 0.91439523);
        concurrentHashMap.put("ind-ft", 0.30479841);
        concurrentHashMap.put("ind-ch", 20.11669506);
        concurrentHashMap.put("degree", 111194.87428468118);
        return concurrentHashMap;
    }

    private static Map<String, Double> getPrimeMeridians() {
        ConcurrentHashMap<String, Double> concurrentHashMap = new ConcurrentHashMap<String, Double>();
        try {
            concurrentHashMap.put("greenwich", 0.0);
            concurrentHashMap.put("lisbon", CustomProjection.parseAngle("9d07'54.862\"W", null));
            concurrentHashMap.put("paris", CustomProjection.parseAngle("2d20'14.025\"E", null));
            concurrentHashMap.put("bogota", CustomProjection.parseAngle("74d04'51.3\"W", null));
            concurrentHashMap.put("madrid", CustomProjection.parseAngle("3d41'16.58\"W", null));
            concurrentHashMap.put("rome", CustomProjection.parseAngle("12d27'8.4\"E", null));
            concurrentHashMap.put("bern", CustomProjection.parseAngle("7d26'22.5\"E", null));
            concurrentHashMap.put("jakarta", CustomProjection.parseAngle("106d48'27.79\"E", null));
            concurrentHashMap.put("ferro", CustomProjection.parseAngle("17d40'W", null));
            concurrentHashMap.put("brussels", CustomProjection.parseAngle("4d22'4.71\"E", null));
            concurrentHashMap.put("stockholm", CustomProjection.parseAngle("18d3'29.8\"E", null));
            concurrentHashMap.put("athens", CustomProjection.parseAngle("23d42'58.815\"E", null));
            concurrentHashMap.put("oslo", CustomProjection.parseAngle("10d43'22.5\"E", null));
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException();
        }
        return concurrentHashMap;
    }

    public static enum Param {
        x_0("x_0", true),
        y_0("y_0", true),
        lon_0("lon_0", true),
        pm("pm", true),
        k_0("k_0", true),
        ellps("ellps", true),
        a("a", true),
        es("es", true),
        rf("rf", true),
        f("f", true),
        b("b", true),
        datum("datum", true),
        towgs84("towgs84", true),
        nadgrids("nadgrids", true),
        proj("proj", true),
        lat_0("lat_0", true),
        lat_1("lat_1", true),
        lat_2("lat_2", true),
        wktext("wktext", false),
        units("units", true),
        no_defs("no_defs", false),
        init("init", true),
        to_meter("to_meter", true),
        axis("axis", true),
        zone("zone", true),
        south("south", false),
        vunits("vunits", true),
        wmssrs("wmssrs", true),
        bounds("bounds", true);

        public final String key;
        public final boolean hasValue;
        static final Map<String, Param> paramsByKey;

        private Param(String string2, boolean bl) {
            this.key = string2;
            this.hasValue = bl;
        }

        static {
            paramsByKey = new ConcurrentHashMap<String, Param>();
            for (Param param : Param.values()) {
                paramsByKey.put(param.key, param);
            }
        }
    }
}

