/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.RegexValidator;

public class InetAddressValidator
extends AbstractValidator {
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final InetAddressValidator VALIDATOR = new InetAddressValidator();
    private final RegexValidator ipv4Validator = new RegexValidator("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static InetAddressValidator getInstance() {
        return VALIDATOR;
    }

    @Override
    public boolean isValid(String string) {
        return this.isValidInet4Address(string);
    }

    public boolean isValidInet4Address(String string) {
        String[] stringArray = this.ipv4Validator.match(string);
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i <= 3; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.isEmpty()) {
                return false;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n <= 255) continue;
            return false;
        }
        return true;
    }
}

