/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;

public class FileDrop {
    private Border normalBorder;
    private DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;
    private static final String ZERO_CHAR_STRING;

    public FileDrop(Component component) {
        this(component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, new Listener(){

            @Override
            public void filesDropped(File[] fileArray) {
                OpenFileAction.OpenFileTask openFileTask = new OpenFileAction.OpenFileTask(Arrays.asList(fileArray), null);
                openFileTask.setRecordHistory(true);
                Main.worker.submit(openFileTask);
            }
        });
    }

    public FileDrop(Component component, Border border, boolean bl, Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropListener(listener, border, component);
            this.makeDropTarget(component, bl);
        } else {
            Main.info("FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static synchronized boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean bl = false;
            try {
                Class.forName("java.awt.dnd.DnDConstants");
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            supportsDnD = bl;
        }
        return supportsDnD;
    }

    private static File[] createFileArray(BufferedReader bufferedReader) {
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(string)) continue;
                    File file = new File(new URI(string));
                    arrayList.add(file);
                }
                catch (Exception exception) {
                    Main.warn("Error with " + string + ": " + exception.getMessage());
                }
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        catch (IOException iOException) {
            Main.warn("FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final Component component, boolean bl) {
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            Main.error(tooManyListenersException);
            Main.warn("FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Main.trace("FileDrop: Hierarchy changed.");
                Container container = component.getParent();
                if (container == null) {
                    component.setDropTarget(null);
                    Main.trace("FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(component, FileDrop.this.dropListener);
                    Main.trace("FileDrop: Drop target added to component.");
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this.dropListener);
        }
        if (bl && component instanceof Container) {
            Component[] componentArray;
            Container container = (Container)component;
            for (Component component2 : componentArray = container.getComponents()) {
                this.makeDropTarget(component2, bl);
            }
        }
    }

    private static boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        boolean bl = false;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        for (n = 0; !bl && n < dataFlavorArray.length; ++n) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor) && !dataFlavor.isRepresentationClassReader()) continue;
            bl = true;
        }
        if (dataFlavorArray.length == 0) {
            Main.trace("FileDrop: no data flavors.");
        }
        for (n = 0; n < dataFlavorArray.length; ++n) {
            Main.trace(dataFlavorArray[n].toString());
        }
        return bl;
    }

    public static boolean remove(Component component) {
        return FileDrop.remove(component, true);
    }

    public static boolean remove(Component component, boolean bl) {
        if (FileDrop.supportsDnD()) {
            Main.trace("FileDrop: Removing drag-and-drop hooks.");
            component.setDropTarget(null);
            if (bl && component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    FileDrop.remove(component2, bl);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        ZERO_CHAR_STRING = Character.toString('\u0000');
    }

    public static class TransferableObject
    implements Transferable {
        public static final String MIME_TYPE = "application/x-net.iharder.dnd.TransferableObject";
        public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.dnd.TransferableObject");
        private Fetcher fetcher;
        private Object data;
        private DataFlavor customFlavor;

        public TransferableObject(Object object) {
            this.data = object;
            this.customFlavor = new DataFlavor(object.getClass(), MIME_TYPE);
        }

        public TransferableObject(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        public TransferableObject(Class<?> clazz, Fetcher fetcher) {
            this.fetcher = fetcher;
            this.customFlavor = new DataFlavor(clazz, MIME_TYPE);
        }

        public DataFlavor getCustomDataFlavor() {
            return this.customFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.customFlavor != null) {
                return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DATA_FLAVOR)) {
                return this.fetcher == null ? this.data : this.fetcher.getObject();
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DATA_FLAVOR)) {
                return true;
            }
            return dataFlavor.equals(DataFlavor.stringFlavor);
        }

        public static interface Fetcher {
            public Object getObject();
        }
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }

    private final class DropListener
    implements DropTargetListener {
        private final Listener listener;
        private final Border dragBorder;
        private final Component c;

        private DropListener(Listener listener, Border border, Component component) {
            this.listener = listener;
            this.dragBorder = border;
            this.c = component;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Main.trace("FileDrop: dragEnter event.");
            if (FileDrop.isDragOk(dropTargetDragEvent)) {
                if (this.c instanceof JComponent) {
                    JComponent jComponent = (JComponent)this.c;
                    FileDrop.this.normalBorder = jComponent.getBorder();
                    Main.trace("FileDrop: normal border saved.");
                    jComponent.setBorder(this.dragBorder);
                    Main.trace("FileDrop: drag border set.");
                }
                dropTargetDragEvent.acceptDrag(1);
                Main.trace("FileDrop: event accepted.");
            } else {
                dropTargetDragEvent.rejectDrag();
                Main.trace("FileDrop: event rejected.");
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Main.trace("FileDrop: drop event.");
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    Main.trace("FileDrop: file list accepted.");
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File[] fileArray = list.toArray(new File[list.size()]);
                    if (this.listener != null) {
                        this.listener.filesDropped(fileArray);
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    Main.trace("FileDrop: drop complete.");
                } else {
                    DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                    boolean bl = false;
                    for (DataFlavor dataFlavor : dataFlavorArray) {
                        if (!dataFlavor.isRepresentationClassReader()) continue;
                        dropTargetDropEvent.acceptDrop(1);
                        Main.trace("FileDrop: reader accepted.");
                        Reader reader = dataFlavor.getReaderForText(transferable);
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        if (this.listener != null) {
                            this.listener.filesDropped(FileDrop.createFileArray(bufferedReader));
                        }
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        Main.trace("FileDrop: drop complete.");
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        Main.trace("FileDrop: not a file list or reader - abort.");
                        dropTargetDropEvent.rejectDrop();
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Main.warn("FileDrop: " + exception.getClass().getSimpleName() + " - abort:");
                Main.error(exception);
                try {
                    dropTargetDropEvent.rejectDrop();
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    Main.error(invalidDnDOperationException);
                }
            }
            finally {
                if (this.c instanceof JComponent) {
                    JComponent jComponent = (JComponent)this.c;
                    jComponent.setBorder(FileDrop.this.normalBorder);
                    Main.debug("FileDrop: normal border restored.");
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            Main.debug("FileDrop: dragExit event.");
            if (this.c instanceof JComponent) {
                JComponent jComponent = (JComponent)this.c;
                jComponent.setBorder(FileDrop.this.normalBorder);
                Main.debug("FileDrop: normal border restored.");
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            Main.debug("FileDrop: dropActionChanged event.");
            if (FileDrop.isDragOk(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(1);
                Main.debug("FileDrop: event accepted.");
            } else {
                dropTargetDragEvent.rejectDrag();
                Main.debug("FileDrop: event rejected.");
            }
        }
    }
}

