/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class TheirTableCellRenderer
extends TagMergeTableCellRenderer {
    protected void setBackgroundColor(TagMergeItem tagMergeItem, boolean bl) {
        if (bl) {
            this.setBackground(ConflictColors.BGCOLOR_SELECTED.get());
            return;
        }
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_DROP.get());
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_KEEP.get());
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        }
    }

    protected void setTextColor(TagMergeItem tagMergeItem) {
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setForeground(ConflictColors.FGCOLOR_DROP.get());
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setForeground(ConflictColors.FGCOLOR_KEEP.get());
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setForeground(ConflictColors.FGCOLOR_UNDECIDED.get());
        }
    }

    @Override
    protected void renderKey(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        this.setTextColor(tagMergeItem);
        if (tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("Their dataset does not include a tag with key {0}", tagMergeItem.getKey()));
        } else {
            this.setText(tagMergeItem.getKey());
            this.setToolTipText(tagMergeItem.getKey());
        }
    }

    @Override
    protected void renderValue(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        this.setTextColor(tagMergeItem);
        if (tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("Their dataset does not include a tag with key {0}", tagMergeItem.getKey()));
        } else {
            this.setText(tagMergeItem.getTheirTagValue());
            this.setToolTipText(tagMergeItem.getTheirTagValue());
        }
    }
}

