/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetHeaderDownloadTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private Set<Integer> idsToDownload;
    private OsmServerChangesetReader reader;
    private boolean canceled;
    private Exception lastException;
    private Set<Changeset> downloadedChangesets;
    private final boolean includeDiscussion;

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Collection<Changeset> collection) {
        return ChangesetHeaderDownloadTask.buildTaskForChangesets(Main.parent, collection);
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Component component, Collection<Changeset> collection) {
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
        if (collection == null) {
            collection = Collections.emptyList();
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Changeset changeset : collection) {
            if (changeset == null || changeset.isNew()) continue;
            hashSet.add(changeset.getId());
        }
        if (component == null) {
            return new ChangesetHeaderDownloadTask(hashSet);
        }
        return new ChangesetHeaderDownloadTask(component, hashSet);
    }

    protected void init(Collection<Integer> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.idsToDownload = new HashSet<Integer>();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (int n : collection) {
            if (n <= 0) continue;
            this.idsToDownload.add(n);
        }
    }

    public ChangesetHeaderDownloadTask(Collection<Integer> collection) {
        super(I18n.tr("Download changesets", new Object[0]), false);
        this.init(collection);
        this.includeDiscussion = false;
    }

    public ChangesetHeaderDownloadTask(Component component, Collection<Integer> collection) {
        this(component, collection, false);
    }

    public ChangesetHeaderDownloadTask(Component component, Collection<Integer> collection, boolean bl) {
        super(component, I18n.tr("Download changesets", new Object[0]), false);
        this.init(collection);
        this.includeDiscussion = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetHeaderDownloadTask changesetHeaderDownloadTask = this;
        synchronized (changesetHeaderDownloadTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(ChangesetHeaderDownloadTask.this.downloadedChangesets);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while updating changeset cache");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    BugReportExceptionHandler.handleException(throwable);
                }
                if (throwable instanceof Exception) {
                    ExceptionUtil.explainException(invocationTargetException);
                }
                BugReportExceptionHandler.handleException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = this;
            synchronized (changesetHeaderDownloadTask) {
                this.reader = new OsmServerChangesetReader();
            }
            this.downloadedChangesets = new HashSet<Changeset>();
            this.downloadedChangesets.addAll(this.reader.readChangesets(this.idsToDownload, this.includeDiscussion, this.getProgressMonitor().createSubTaskMonitor(0, false)));
        }
        catch (OsmTransferException osmTransferException) {
            if (this.canceled) {
                return;
            }
            this.lastException = osmTransferException;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

