/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.tools.I18n;

public abstract class KeyedItem
extends TaggingPresetItem {
    protected static final String DIFFERENT = I18n.tr("<different>", new Object[0]);
    protected static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    protected static final Map<String, String> LAST_VALUES = new HashMap<String, String>();
    public String key;
    public String text;
    public String text_context;
    public String match = this.getDefaultMatch().getValue();

    protected static Usage determineTextUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet<String>();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                usage.values.add(string2);
            } else {
                usage.hadEmpty = true;
            }
            if (!osmPrimitive.hasKeys()) continue;
            usage.hadKeys = true;
        }
        return usage;
    }

    protected static Usage determineBooleanUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet<String>();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = OsmUtils.getNamedOsmBoolean(osmPrimitive.get(string));
            if (string2 == null) continue;
            usage.values.add(string2);
        }
        return usage;
    }

    public abstract MatchType getDefaultMatch();

    public abstract Collection<String> getValues();

    @Override
    protected Boolean matches(Map<String, String> map) {
        switch (MatchType.ofString(this.match)) {
            case NONE: {
                return null;
            }
            case KEY: {
                return map.containsKey(this.key) ? Boolean.TRUE : null;
            }
            case KEY_REQUIRED: {
                return map.containsKey(this.key);
            }
            case KEY_VALUE: {
                return map.containsKey(this.key) && this.getValues().contains(map.get(this.key)) ? Boolean.TRUE : null;
            }
            case KEY_VALUE_REQUIRED: {
                return map.containsKey(this.key) && this.getValues().contains(map.get(this.key));
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + ']';
    }

    protected static class Usage {
        public SortedSet<String> values;
        private boolean hadKeys;
        private boolean hadEmpty;

        protected Usage() {
        }

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.isEmpty();
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    protected static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue"),
        KEY_VALUE_REQUIRED("keyvalue!");

        private final String value;

        private MatchType(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String string) {
            for (MatchType matchType : EnumSet.allOf(MatchType.class)) {
                if (!matchType.getValue().equals(string)) continue;
                return matchType;
            }
            throw new IllegalArgumentException(string + " is not allowed");
        }
    }
}

