/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractParser;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OsmHistoryReader {
    private final InputStream in;
    private final HistoryDataSet data;

    public OsmHistoryReader(InputStream inputStream) {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        this.in = inputStream;
        this.data = new HistoryDataSet();
    }

    public HistoryDataSet parse(ProgressMonitor progressMonitor) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new InputStreamReader(this.in, StandardCharsets.UTF_8));
        progressMonitor.beginTask(I18n.tr("Parsing OSM history data ...", new Object[0]));
        try {
            Utils.parseSafeSAX(inputSource, new Parser());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Main.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    private class Parser
    extends AbstractParser {
        private Parser() {
        }

        protected String getCurrentPosition() {
            if (this.locator == null) {
                return "";
            }
            return "(" + this.locator.getLineNumber() + ',' + this.locator.getColumnNumber() + ')';
        }

        @Override
        protected void throwException(String string) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + string);
        }

        @Override
        protected void throwException(String string, Exception exception) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + string, exception);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.doStartElement(string3, attributes);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("node".equals(string3) || "way".equals(string3) || "relation".equals(string3)) {
                OsmHistoryReader.this.data.put(this.currentPrimitive);
            }
        }
    }
}

