/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public abstract class GraphicsDevice {
    private Window fullScreenWindow;
    private AppContext fullScreenAppContext;
    private final Object fsAppContextLock = new Object();
    private Rectangle windowedModeBounds;
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;

    protected GraphicsDevice() {
    }

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
        GraphicsConfiguration[] graphicsConfigurationArray = this.getConfigurations();
        return graphicsConfigTemplate.getBestConfiguration(graphicsConfigurationArray);
    }

    public boolean isFullScreenSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullScreenWindow(Window window) {
        Object object;
        if (window != null) {
            if (window.getShape() != null) {
                window.setShape(null);
            }
            if (window.getOpacity() < 1.0f) {
                window.setOpacity(1.0f);
            }
            if (!window.isOpaque()) {
                object = window.getBackground();
                object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), 255);
                window.setBackground((Color)object);
            }
            if ((object = window.getGraphicsConfiguration()) != null && ((GraphicsConfiguration)object).getDevice() != this && ((GraphicsConfiguration)object).getDevice().getFullScreenWindow() == window) {
                ((GraphicsConfiguration)object).getDevice().setFullScreenWindow(null);
            }
        }
        if (this.fullScreenWindow != null && this.windowedModeBounds != null) {
            if (this.windowedModeBounds.width == 0) {
                this.windowedModeBounds.width = 1;
            }
            if (this.windowedModeBounds.height == 0) {
                this.windowedModeBounds.height = 1;
            }
            this.fullScreenWindow.setBounds(this.windowedModeBounds);
        }
        object = this.fsAppContextLock;
        synchronized (object) {
            this.fullScreenAppContext = window == null ? null : AppContext.getAppContext();
            this.fullScreenWindow = window;
        }
        if (this.fullScreenWindow != null) {
            this.windowedModeBounds = this.fullScreenWindow.getBounds();
            object = this.getDefaultConfiguration().getBounds();
            this.fullScreenWindow.setBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            this.fullScreenWindow.setVisible(true);
            this.fullScreenWindow.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getFullScreenWindow() {
        Window window = null;
        Object object = this.fsAppContextLock;
        synchronized (object) {
            if (this.fullScreenAppContext == AppContext.getAppContext()) {
                window = this.fullScreenWindow;
            }
        }
        return window;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        throw new UnsupportedOperationException("Cannot change display mode");
    }

    public DisplayMode getDisplayMode() {
        GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        return new DisplayMode(rectangle.width, rectangle.height, colorModel.getPixelSize(), 0);
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[]{this.getDisplayMode()};
    }

    public int getAvailableAcceleratedMemory() {
        return -1;
    }

    public boolean isWindowTranslucencySupported(WindowTranslucency windowTranslucency) {
        switch (windowTranslucency) {
            case PERPIXEL_TRANSPARENT: {
                return GraphicsDevice.isWindowShapingSupported();
            }
            case TRANSLUCENT: {
                return GraphicsDevice.isWindowOpacitySupported();
            }
            case PERPIXEL_TRANSLUCENT: {
                return this.isWindowPerpixelTranslucencySupported();
            }
        }
        return false;
    }

    static boolean isWindowShapingSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowShapingSupported();
    }

    static boolean isWindowOpacitySupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowOpacitySupported();
    }

    boolean isWindowPerpixelTranslucencySupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        if (!((SunToolkit)toolkit).isWindowTranslucencySupported()) {
            return false;
        }
        return this.getTranslucencyCapableGC() != null;
    }

    GraphicsConfiguration getTranslucencyCapableGC() {
        GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
        if (graphicsConfiguration.isTranslucencyCapable()) {
            return graphicsConfiguration;
        }
        GraphicsConfiguration[] graphicsConfigurationArray = this.getConfigurations();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            if (!graphicsConfigurationArray[i].isTranslucencyCapable()) continue;
            return graphicsConfigurationArray[i];
        }
        return null;
    }

    public static enum WindowTranslucency {
        PERPIXEL_TRANSPARENT,
        TRANSLUCENT,
        PERPIXEL_TRANSLUCENT;

    }
}

