/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.plaf.FontUIResource;
import sun.applet.AppletSecurity;
import sun.awt.AppContext;
import sun.awt.FontConfiguration;
import sun.awt.SunToolkit;
import sun.font.CompositeFont;
import sun.font.CompositeFontDescriptor;
import sun.font.CreatedFontTracker;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontAccess;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontManagerForSGE;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeCache;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.java2d.FontSupport;
import sun.misc.ThreadGroupUtils;
import sun.util.logging.PlatformLogger;

public abstract class SunFontManager
implements FontSupport,
FontManagerForSGE {
    public static final int FONTFORMAT_NONE = -1;
    public static final int FONTFORMAT_TRUETYPE = 0;
    public static final int FONTFORMAT_TYPE1 = 1;
    public static final int FONTFORMAT_T2K = 2;
    public static final int FONTFORMAT_TTC = 3;
    public static final int FONTFORMAT_COMPOSITE = 4;
    public static final int FONTFORMAT_NATIVE = 5;
    protected static final int CHANNELPOOLSIZE = 20;
    protected FileFont[] fontFileCache = new FileFont[20];
    private int lastPoolIndex = 0;
    private int maxCompFont = 0;
    private CompositeFont[] compFonts = new CompositeFont[20];
    private ConcurrentHashMap<String, CompositeFont> compositeFonts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, PhysicalFont> physicalFonts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, PhysicalFont> registeredFonts = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Font2D> fullNameToFont = new ConcurrentHashMap();
    private HashMap<String, TrueTypeFont> localeFullNamesToFont;
    private PhysicalFont defaultPhysicalFont;
    static boolean longAddresses;
    private boolean loaded1dot0Fonts = false;
    boolean loadedAllFonts = false;
    boolean loadedAllFontFiles = false;
    HashMap<String, String> jreFontMap;
    HashSet<String> jreLucidaFontFiles;
    String[] jreOtherFontFiles;
    boolean noOtherJREFontFiles = false;
    public static final String lucidaFontName = "Lucida Sans Regular";
    public static String jreLibDirName;
    public static String jreFontDirName;
    private static HashSet<String> missingFontFiles;
    private String defaultFontName;
    private String defaultFontFileName;
    protected HashSet registeredFontFiles = new HashSet();
    private ArrayList badFonts;
    protected String fontPath;
    private FontConfiguration fontConfig;
    private boolean discoveredAllFonts = false;
    private static final FilenameFilter ttFilter;
    private static final FilenameFilter t1Filter;
    private Font[] allFonts;
    private String[] allFamilies;
    private Locale lastDefaultLocale;
    public static boolean noType1Font;
    private static String[] STR_ARRAY;
    private boolean usePlatformFontMetrics = false;
    private final ConcurrentHashMap<String, FontRegistrationInfo> deferredFontFiles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Font2DHandle> initialisedFonts = new ConcurrentHashMap();
    private HashMap<String, String> fontToFileMap = null;
    private HashMap<String, String> fontToFamilyNameMap = null;
    private HashMap<String, ArrayList<String>> familyToFontListMap = null;
    private String[] pathDirs = null;
    private boolean haveCheckedUnreferencedFontFiles;
    static HashMap<String, FamilyDescription> platformFontMap;
    private ConcurrentHashMap<String, Font2D> fontNameCache = new ConcurrentHashMap();
    protected Thread fileCloser = null;
    Vector<File> tmpFontFiles = null;
    private static final Object altJAFontKey;
    private static final Object localeFontKey;
    private static final Object proportionalFontKey;
    private boolean _usingPerAppContextComposites = false;
    private boolean _usingAlternateComposites = false;
    private static boolean gAltJAFont;
    private boolean gLocalePref = false;
    private boolean gPropPref = false;
    private static HashSet<String> installedNames;
    private static final Object regFamilyKey;
    private static final Object regFullNameKey;
    private Hashtable<String, FontFamily> createdByFamilyName;
    private Hashtable<String, Font2D> createdByFullName;
    private boolean fontsAreRegistered = false;
    private boolean fontsAreRegisteredPerAppContext = false;
    private static Locale systemLocale;

    public static SunFontManager getInstance() {
        FontManager fontManager = FontManagerFactory.getInstance();
        return (SunFontManager)fontManager;
    }

    public FilenameFilter getTrueTypeFilter() {
        return ttFilter;
    }

    public FilenameFilter getType1Filter() {
        return t1Filter;
    }

    @Override
    public boolean usingPerAppContextComposites() {
        return this._usingPerAppContextComposites;
    }

    private void initJREFontMap() {
        this.jreFontMap = new HashMap();
        this.jreLucidaFontFiles = new HashSet();
        if (SunFontManager.isOpenJDK()) {
            return;
        }
        this.jreFontMap.put("lucida sans0", "LucidaSansRegular.ttf");
        this.jreFontMap.put("lucida sans1", "LucidaSansDemiBold.ttf");
        this.jreFontMap.put("lucida sans regular0", "LucidaSansRegular.ttf");
        this.jreFontMap.put("lucida sans regular1", "LucidaSansDemiBold.ttf");
        this.jreFontMap.put("lucida sans bold1", "LucidaSansDemiBold.ttf");
        this.jreFontMap.put("lucida sans demibold1", "LucidaSansDemiBold.ttf");
        this.jreFontMap.put("lucida sans typewriter0", "LucidaTypewriterRegular.ttf");
        this.jreFontMap.put("lucida sans typewriter1", "LucidaTypewriterBold.ttf");
        this.jreFontMap.put("lucida sans typewriter regular0", "LucidaTypewriter.ttf");
        this.jreFontMap.put("lucida sans typewriter regular1", "LucidaTypewriterBold.ttf");
        this.jreFontMap.put("lucida sans typewriter bold1", "LucidaTypewriterBold.ttf");
        this.jreFontMap.put("lucida sans typewriter demibold1", "LucidaTypewriterBold.ttf");
        this.jreFontMap.put("lucida bright0", "LucidaBrightRegular.ttf");
        this.jreFontMap.put("lucida bright1", "LucidaBrightDemiBold.ttf");
        this.jreFontMap.put("lucida bright2", "LucidaBrightItalic.ttf");
        this.jreFontMap.put("lucida bright3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright regular0", "LucidaBrightRegular.ttf");
        this.jreFontMap.put("lucida bright regular1", "LucidaBrightDemiBold.ttf");
        this.jreFontMap.put("lucida bright regular2", "LucidaBrightItalic.ttf");
        this.jreFontMap.put("lucida bright regular3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright bold1", "LucidaBrightDemiBold.ttf");
        this.jreFontMap.put("lucida bright bold3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright demibold1", "LucidaBrightDemiBold.ttf");
        this.jreFontMap.put("lucida bright demibold3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright italic2", "LucidaBrightItalic.ttf");
        this.jreFontMap.put("lucida bright italic3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright bold italic3", "LucidaBrightDemiItalic.ttf");
        this.jreFontMap.put("lucida bright demibold italic3", "LucidaBrightDemiItalic.ttf");
        for (String string : this.jreFontMap.values()) {
            this.jreLucidaFontFiles.add(string);
        }
    }

    public TrueTypeFont getEUDCFont() {
        return null;
    }

    private static native void initIDs();

    protected SunFontManager() {
        this.initJREFontMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                Object object;
                File file = new File(jreFontDirName + File.separator + "badfonts.txt");
                if (file.exists()) {
                    object = null;
                    try {
                        SunFontManager.this.badFonts = new ArrayList();
                        object = new FileInputStream(file);
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (FontUtilities.debugFonts()) {
                                FontUtilities.getLogger().warning("read bad font: " + string);
                            }
                            SunFontManager.this.badFonts.add(string);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (object != null) {
                                object.close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
                if (FontUtilities.isLinux || FontUtilities.isBSD) {
                    SunFontManager.this.registerFontDir(jreFontDirName);
                }
                SunFontManager.this.registerFontsInDir(jreFontDirName, true, 2, true, false);
                SunFontManager.this.fontConfig = SunFontManager.this.createFontConfiguration();
                if (SunFontManager.isOpenJDK()) {
                    object = SunFontManager.this.getDefaultPlatformFont();
                    SunFontManager.this.defaultFontName = object[0];
                    SunFontManager.this.defaultFontFileName = object[1];
                }
                object = SunFontManager.this.fontConfig.getExtraFontPath();
                boolean bl = false;
                boolean bl2 = false;
                string = System.getProperty("sun.java2d.fontpath");
                if (string != null) {
                    if (string.startsWith("prepend:")) {
                        bl = true;
                        string = string.substring("prepend:".length());
                    } else if (string.startsWith("append:")) {
                        bl2 = true;
                        string = string.substring("append:".length());
                    }
                }
                if (FontUtilities.debugFonts()) {
                    PlatformLogger platformLogger = FontUtilities.getLogger();
                    platformLogger.info("JRE font directory: " + jreFontDirName);
                    platformLogger.info("Extra font path: " + (String)object);
                    platformLogger.info("Debug font path: " + string);
                }
                if (string != null) {
                    SunFontManager.this.fontPath = SunFontManager.this.getPlatformFontPath(noType1Font);
                    if (object != null) {
                        SunFontManager.this.fontPath = (String)object + File.pathSeparator + SunFontManager.this.fontPath;
                    }
                    SunFontManager.this.fontPath = bl2 ? SunFontManager.this.fontPath + File.pathSeparator + string : (bl ? string + File.pathSeparator + SunFontManager.this.fontPath : string);
                    SunFontManager.this.registerFontDirs(SunFontManager.this.fontPath);
                } else if (object != null) {
                    SunFontManager.this.registerFontDirs((String)object);
                }
                if (FontUtilities.isSolaris && Locale.JAPAN.equals(Locale.getDefault())) {
                    SunFontManager.this.registerFontDir("/usr/openwin/lib/locale/ja/X11/fonts/TT");
                }
                SunFontManager.this.initCompositeFonts(SunFontManager.this.fontConfig, null);
                return null;
            }
        });
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string = System.getProperty("java2d.font.usePlatformFont");
                String string2 = System.getenv("JAVA2D_USEPLATFORMFONT");
                return "true".equals(string) || string2 != null;
            }
        });
        if (bl) {
            this.usePlatformFontMetrics = true;
            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
            System.out.println("functionality. This property will be removed in a later release.");
        }
    }

    @Override
    public Font2DHandle getNewComposite(String string, int n, Font2DHandle font2DHandle) {
        Font2D font2D;
        if (!(font2DHandle.font2D instanceof CompositeFont)) {
            return font2DHandle;
        }
        CompositeFont compositeFont = (CompositeFont)font2DHandle.font2D;
        PhysicalFont physicalFont = compositeFont.getSlotFont(0);
        if (string == null) {
            string = physicalFont.getFamilyName(null);
        }
        if (n == -1) {
            n = compositeFont.getStyle();
        }
        if (!((font2D = this.findFont2D(string, n, 0)) instanceof PhysicalFont)) {
            font2D = physicalFont;
        }
        PhysicalFont physicalFont2 = (PhysicalFont)font2D;
        CompositeFont compositeFont2 = (CompositeFont)this.findFont2D("dialog", n, 0);
        if (compositeFont2 == null) {
            return font2DHandle;
        }
        CompositeFont compositeFont3 = new CompositeFont(physicalFont2, compositeFont2);
        Font2DHandle font2DHandle2 = new Font2DHandle(compositeFont3);
        return font2DHandle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n, int[] nArray, int[] nArray2, boolean bl) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n, nArray, nArray2, bl, this);
        this.addCompositeToFontList(compositeFont, 2);
        CompositeFont[] compositeFontArray = this.compFonts;
        synchronized (this.compFonts) {
            this.compFonts[this.maxCompFont++] = compositeFont;
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    protected static void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n, int[] nArray, int[] nArray2, boolean bl, ConcurrentHashMap<String, Font2D> concurrentHashMap) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n, nArray, nArray2, bl, SunFontManager.getInstance());
        Font2D font2D = concurrentHashMap.get(string.toLowerCase(Locale.ENGLISH));
        if (font2D instanceof CompositeFont) {
            font2D.handle.font2D = compositeFont;
        }
        concurrentHashMap.put(string.toLowerCase(Locale.ENGLISH), compositeFont);
    }

    private void addCompositeToFontList(CompositeFont compositeFont, int n) {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Add to Family " + compositeFont.familyName + ", Font " + compositeFont.fullName + " rank=" + n);
        }
        compositeFont.setRank(n);
        this.compositeFonts.put(compositeFont.fullName, compositeFont);
        this.fullNameToFont.put(compositeFont.fullName.toLowerCase(Locale.ENGLISH), compositeFont);
        FontFamily fontFamily = FontFamily.getFamily(compositeFont.familyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(compositeFont.familyName, true, n);
        }
        fontFamily.setFont(compositeFont, compositeFont.style);
    }

    protected PhysicalFont addToFontList(PhysicalFont physicalFont, int n) {
        String string = physicalFont.fullName;
        String string2 = physicalFont.familyName;
        if (string == null || "".equals(string)) {
            return null;
        }
        if (this.compositeFonts.containsKey(string)) {
            return null;
        }
        physicalFont.setRank(n);
        if (!this.physicalFonts.containsKey(string)) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Add to Family " + string2 + ", Font " + string + " rank=" + n);
            }
            this.physicalFonts.put(string, physicalFont);
            FontFamily fontFamily = FontFamily.getFamily(string2);
            if (fontFamily == null) {
                fontFamily = new FontFamily(string2, false, n);
                fontFamily.setFont(physicalFont, physicalFont.style);
            } else {
                fontFamily.setFont(physicalFont, physicalFont.style);
            }
            this.fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont);
            return physicalFont;
        }
        PhysicalFont physicalFont2 = physicalFont;
        PhysicalFont physicalFont3 = this.physicalFonts.get(string);
        if (physicalFont3 == null) {
            return null;
        }
        if (physicalFont3.getRank() >= n) {
            Object object;
            if (physicalFont3.mapper != null && n > 2) {
                return physicalFont3;
            }
            if (physicalFont3.getRank() == n) {
                if (physicalFont3 instanceof TrueTypeFont && physicalFont2 instanceof TrueTypeFont) {
                    object = (TrueTypeFont)physicalFont3;
                    TrueTypeFont trueTypeFont = (TrueTypeFont)physicalFont2;
                    if (((TrueTypeFont)object).fileSize >= trueTypeFont.fileSize) {
                        return physicalFont3;
                    }
                } else {
                    return physicalFont3;
                }
            }
            if (physicalFont3.platName.startsWith(jreFontDirName)) {
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().warning("Unexpected attempt to replace a JRE  font " + string + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
                }
                return physicalFont3;
            }
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Replace in Family " + string2 + ",Font " + string + " new rank=" + n + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
            }
            this.replaceFont(physicalFont3, physicalFont2);
            this.physicalFonts.put(string, physicalFont2);
            this.fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont2);
            object = FontFamily.getFamily(string2);
            if (object == null) {
                object = new FontFamily(string2, false, n);
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            } else {
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            }
            return physicalFont2;
        }
        return physicalFont3;
    }

    public Font2D[] getRegisteredFonts() {
        PhysicalFont[] physicalFontArray = this.getPhysicalFonts();
        int n = this.maxCompFont;
        Font2D[] font2DArray = new Font2D[physicalFontArray.length + n];
        System.arraycopy(this.compFonts, 0, font2DArray, 0, n);
        System.arraycopy(physicalFontArray, 0, font2DArray, n, physicalFontArray.length);
        return font2DArray;
    }

    protected PhysicalFont[] getPhysicalFonts() {
        return this.physicalFonts.values().toArray(new PhysicalFont[0]);
    }

    protected synchronized void initialiseDeferredFonts() {
        for (String string : this.deferredFontFiles.keySet()) {
            this.initialiseDeferredFont(string);
        }
    }

    protected synchronized void registerDeferredJREFonts(String string) {
        for (FontRegistrationInfo fontRegistrationInfo : this.deferredFontFiles.values()) {
            if (fontRegistrationInfo.fontFilePath == null || !fontRegistrationInfo.fontFilePath.startsWith(string)) continue;
            this.initialiseDeferredFont(fontRegistrationInfo.fontFilePath);
        }
    }

    public boolean isDeferredFont(String string) {
        return this.deferredFontFiles.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicalFont findJREDeferredFont(String string, int n) {
        PhysicalFont physicalFont;
        String string2 = string.toLowerCase(Locale.ENGLISH) + n;
        String string3 = this.jreFontMap.get(string2);
        if (string3 != null && this.deferredFontFiles.get(string3 = jreFontDirName + File.separator + string3) != null && (physicalFont = this.initialiseDeferredFont(string3)) != null && (physicalFont.getFontName(null).equalsIgnoreCase(string) || physicalFont.getFamilyName(null).equalsIgnoreCase(string)) && physicalFont.style == n) {
            return physicalFont;
        }
        if (this.noOtherJREFontFiles) {
            return null;
        }
        HashSet<String> hashSet = this.jreLucidaFontFiles;
        synchronized (hashSet) {
            if (this.jreOtherFontFiles == null) {
                HashSet<String> hashSet2 = new HashSet<String>();
                for (String string4 : this.deferredFontFiles.keySet()) {
                    File file = new File(string4);
                    String string5 = file.getParent();
                    String string6 = file.getName();
                    if (string5 == null || !string5.equals(jreFontDirName) || this.jreLucidaFontFiles.contains(string6)) continue;
                    hashSet2.add(string4);
                }
                this.jreOtherFontFiles = hashSet2.toArray(STR_ARRAY);
                if (this.jreOtherFontFiles.length == 0) {
                    this.noOtherJREFontFiles = true;
                }
            }
            for (int i = 0; i < this.jreOtherFontFiles.length; ++i) {
                string3 = this.jreOtherFontFiles[i];
                if (string3 == null) continue;
                this.jreOtherFontFiles[i] = null;
                physicalFont = this.initialiseDeferredFont(string3);
                if (physicalFont == null || !physicalFont.getFontName(null).equalsIgnoreCase(string) && !physicalFont.getFamilyName(null).equalsIgnoreCase(string) || physicalFont.style != n) continue;
                return physicalFont;
            }
        }
        return null;
    }

    private PhysicalFont findOtherDeferredFont(String string, int n) {
        for (String string2 : this.deferredFontFiles.keySet()) {
            PhysicalFont physicalFont;
            File file = new File(string2);
            String string3 = file.getParent();
            String string4 = file.getName();
            if (string3 != null && string3.equals(jreFontDirName) && this.jreLucidaFontFiles.contains(string4) || (physicalFont = this.initialiseDeferredFont(string2)) == null || !physicalFont.getFontName(null).equalsIgnoreCase(string) && !physicalFont.getFamilyName(null).equalsIgnoreCase(string) || physicalFont.style != n) continue;
            return physicalFont;
        }
        return null;
    }

    private PhysicalFont findDeferredFont(String string, int n) {
        PhysicalFont physicalFont = this.findJREDeferredFont(string, n);
        if (physicalFont != null) {
            return physicalFont;
        }
        return this.findOtherDeferredFont(string, n);
    }

    public void registerDeferredFont(String string, String string2, String[] stringArray, int n, boolean bl, int n2) {
        FontRegistrationInfo fontRegistrationInfo = new FontRegistrationInfo(string2, stringArray, n, bl, n2);
        this.deferredFontFiles.put(string, fontRegistrationInfo);
    }

    public synchronized PhysicalFont initialiseDeferredFont(String string) {
        PhysicalFont physicalFont;
        FontRegistrationInfo fontRegistrationInfo;
        if (string == null) {
            return null;
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Opening deferred font file " + string);
        }
        if ((fontRegistrationInfo = this.deferredFontFiles.get(string)) != null) {
            this.deferredFontFiles.remove(string);
            physicalFont = this.registerFontFile(fontRegistrationInfo.fontFilePath, fontRegistrationInfo.nativeNames, fontRegistrationInfo.fontFormat, fontRegistrationInfo.javaRasterizer, fontRegistrationInfo.fontRank);
            if (physicalFont != null) {
                this.initialisedFonts.put(string, physicalFont.handle);
            } else {
                this.initialisedFonts.put(string, this.getDefaultPhysicalFont().handle);
            }
        } else {
            Font2DHandle font2DHandle = this.initialisedFonts.get(string);
            physicalFont = font2DHandle == null ? this.getDefaultPhysicalFont() : (PhysicalFont)font2DHandle.font2D;
        }
        return physicalFont;
    }

    public boolean isRegisteredFontFile(String string) {
        return this.registeredFonts.containsKey(string);
    }

    public PhysicalFont getRegisteredFontFile(String string) {
        return this.registeredFonts.get(string);
    }

    public PhysicalFont registerFontFile(String string, String[] stringArray, int n, boolean bl, int n2) {
        PhysicalFont physicalFont;
        block11: {
            PhysicalFont physicalFont2 = this.registeredFonts.get(string);
            if (physicalFont2 != null) {
                return physicalFont2;
            }
            physicalFont = null;
            try {
                switch (n) {
                    case 0: {
                        TrueTypeFont trueTypeFont;
                        int n3 = 0;
                        do {
                            trueTypeFont = new TrueTypeFont(string, stringArray, n3++, bl);
                            PhysicalFont physicalFont3 = this.addToFontList(trueTypeFont, n2);
                            if (physicalFont != null) continue;
                            physicalFont = physicalFont3;
                        } while (n3 < trueTypeFont.getFontCount());
                        break;
                    }
                    case 1: {
                        Type1Font type1Font = new Type1Font(string, stringArray);
                        physicalFont = this.addToFontList(type1Font, n2);
                        break;
                    }
                    case 5: {
                        NativeFont nativeFont = new NativeFont(string, false);
                        physicalFont = this.addToFontList(nativeFont, n2);
                    }
                }
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().info("Registered file " + string + " as font " + physicalFont + " rank=" + n2);
                }
            }
            catch (FontFormatException fontFormatException) {
                if (!FontUtilities.isLogging()) break block11;
                FontUtilities.getLogger().warning("Unusable font: " + string + " " + fontFormatException.toString());
            }
        }
        if (physicalFont != null && n != 5) {
            this.registeredFonts.put(string, physicalFont);
        }
        return physicalFont;
    }

    public void registerFonts(String[] stringArray, String[][] stringArray2, int n, int n2, boolean bl, int n3, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            if (bl2) {
                this.registerDeferredFont(stringArray[i], stringArray[i], stringArray2[i], n2, bl, n3);
                continue;
            }
            this.registerFontFile(stringArray[i], stringArray2[i], n2, bl, n3);
        }
    }

    public PhysicalFont getDefaultPhysicalFont() {
        if (this.defaultPhysicalFont == null) {
            this.defaultPhysicalFont = (PhysicalFont)this.findFont2D(lucidaFontName, 0, 0);
            if (this.defaultPhysicalFont == null) {
                this.defaultPhysicalFont = (PhysicalFont)this.findFont2D("Arial", 0, 0);
            }
            if (this.defaultPhysicalFont == null) {
                Iterator<PhysicalFont> iterator = this.physicalFonts.values().iterator();
                if (iterator.hasNext()) {
                    this.defaultPhysicalFont = iterator.next();
                } else {
                    throw new Error("Probable fatal error:No fonts found.");
                }
            }
        }
        return this.defaultPhysicalFont;
    }

    public Font2D getDefaultLogicalFont(int n) {
        return this.findFont2D("dialog", n, 0);
    }

    private static String dotStyleStr(int n) {
        switch (n) {
            case 1: {
                return ".bold";
            }
            case 2: {
                return ".italic";
            }
            case 3: {
                return ".bolditalic";
            }
        }
        return ".plain";
    }

    protected void populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
    }

    private String[] getFontFilesFromPath(boolean bl) {
        final FilenameFilter filenameFilter = bl ? ttFilter : new TTorT1Filter();
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (SunFontManager.this.pathDirs.length == 1) {
                    File file = new File(SunFontManager.this.pathDirs[0]);
                    String[] stringArray = file.list(filenameFilter);
                    if (stringArray == null) {
                        return new String[0];
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].toLowerCase();
                    }
                    return stringArray;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < SunFontManager.this.pathDirs.length; ++i) {
                    File file = new File(SunFontManager.this.pathDirs[i]);
                    String[] stringArray = file.list(filenameFilter);
                    if (stringArray == null) continue;
                    for (int j = 0; j < stringArray.length; ++j) {
                        arrayList.add(stringArray[j].toLowerCase());
                    }
                }
                return arrayList.toArray(STR_ARRAY);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void resolveWindowsFonts() {
        Object n;
        ArrayList<String> arrayList = null;
        for (String object2 : this.fontToFamilyNameMap.keySet()) {
            n = this.fontToFileMap.get(object2);
            if (n != null) continue;
            if (object2.indexOf("  ") > 0) {
                String i = object2.replaceFirst("  ", " ");
                n = this.fontToFileMap.get(i);
                if (n == null || this.fontToFamilyNameMap.containsKey(i)) continue;
                this.fontToFileMap.remove(i);
                this.fontToFileMap.put(object2, (String)n);
                continue;
            }
            if (object2.equals("marlett")) {
                this.fontToFileMap.put(object2, "marlett.ttf");
                continue;
            }
            if (object2.equals("david")) {
                n = this.fontToFileMap.get("david regular");
                if (n == null) continue;
                this.fontToFileMap.remove("david regular");
                this.fontToFileMap.put("david", (String)n);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object2);
        }
        if (arrayList != null) {
            HashSet hashSet = new HashSet();
            HashMap hashMap = (HashMap)this.fontToFileMap.clone();
            for (String string : this.fontToFamilyNameMap.keySet()) {
                hashMap.remove(string);
            }
            for (String string : hashMap.keySet()) {
                hashSet.add(hashMap.get(string));
                this.fontToFileMap.remove(string);
            }
            this.resolveFontFiles(hashSet, arrayList);
            if (arrayList.size() > 0) {
                n = new ArrayList<String>();
                for (String string : this.fontToFileMap.values()) {
                    ((ArrayList)n).add(string.toLowerCase());
                }
                for (String string : this.getFontFilesFromPath(true)) {
                    if (((ArrayList)n).contains(string)) continue;
                    hashSet.add(string);
                }
                this.resolveFontFiles(hashSet, arrayList);
            }
            if (arrayList.size() > 0) {
                void var5_16;
                int n2 = arrayList.size();
                boolean bl = false;
                while (var5_16 < n2) {
                    ArrayList<String> arrayList2;
                    String string = arrayList.get((int)var5_16);
                    String string2 = this.fontToFamilyNameMap.get(string);
                    if (string2 != null && (arrayList2 = this.familyToFontListMap.get(string2)) != null && arrayList2.size() <= 1) {
                        this.familyToFontListMap.remove(string2);
                    }
                    this.fontToFamilyNameMap.remove(string);
                    if (FontUtilities.isLogging()) {
                        FontUtilities.getLogger().info("No file for font:" + string);
                    }
                    ++var5_16;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void checkForUnreferencedFontFiles() {
        void var3_5;
        if (this.haveCheckedUnreferencedFontFiles) {
            return;
        }
        this.haveCheckedUnreferencedFontFiles = true;
        if (!FontUtilities.isWindows) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.fontToFileMap.values()) {
            arrayList.add(object2.toLowerCase());
        }
        Object object3 = null;
        Object var3_4 = null;
        HashMap<String, ArrayList<String>> hashMap = null;
        for (String string : this.getFontFilesFromPath(false)) {
            PhysicalFont physicalFont;
            if (arrayList.contains(string)) continue;
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Found non-registry file : " + string);
            }
            if ((physicalFont = this.registerFontFile(this.getPathName(string))) == null) continue;
            if (object3 == null) {
                object3 = new HashMap<String, String>(this.fontToFileMap);
                HashMap<String, String> hashMap2 = new HashMap<String, String>(this.fontToFamilyNameMap);
                hashMap = new HashMap<String, ArrayList<String>>(this.familyToFontListMap);
            }
            String string2 = physicalFont.getFontName(null);
            String string3 = physicalFont.getFamilyName(null);
            String string4 = string3.toLowerCase();
            var3_5.put(string2, string3);
            ((HashMap)object3).put(string2, string);
            ArrayList<String> arrayList2 = hashMap.get(string4);
            arrayList2 = arrayList2 == null ? new ArrayList() : new ArrayList<String>(arrayList2);
            arrayList2.add(string2);
            hashMap.put(string4, arrayList2);
        }
        if (object3 != null) {
            this.fontToFileMap = object3;
            this.familyToFontListMap = hashMap;
            this.fontToFamilyNameMap = var3_5;
        }
    }

    private void resolveFontFiles(HashSet<String> hashSet, ArrayList<String> arrayList) {
        Locale locale = SunToolkit.getStartupLocale();
        for (String string : hashSet) {
            try {
                TrueTypeFont trueTypeFont;
                int n = 0;
                String string2 = this.getPathName(string);
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().info("Trying to resolve file " + string2);
                }
                do {
                    String string3;
                    if (!arrayList.contains(string3 = (trueTypeFont = new TrueTypeFont(string2, null, n++, false)).getFontName(locale).toLowerCase())) continue;
                    this.fontToFileMap.put(string3, string);
                    arrayList.remove(string3);
                    if (!FontUtilities.isLogging()) continue;
                    FontUtilities.getLogger().info("Resolved absent registry entry for " + string3 + " located in " + string2);
                } while (n < trueTypeFont.getFontCount());
            }
            catch (Exception exception) {}
        }
    }

    public HashMap<String, FamilyDescription> populateHardcodedFileNameMap() {
        return new HashMap<String, FamilyDescription>(0);
    }

    Font2D findFontFromPlatformMap(String string, int n) {
        FamilyDescription familyDescription;
        if (platformFontMap == null) {
            platformFontMap = this.populateHardcodedFileNameMap();
        }
        if (platformFontMap == null || platformFontMap.size() == 0) {
            return null;
        }
        int n2 = string.indexOf(32);
        String string2 = string;
        if (n2 > 0) {
            string2 = string.substring(0, n2);
        }
        if ((familyDescription = platformFontMap.get(string2)) == null) {
            return null;
        }
        int n3 = -1;
        if (string.equalsIgnoreCase(familyDescription.plainFullName)) {
            n3 = 0;
        } else if (string.equalsIgnoreCase(familyDescription.boldFullName)) {
            n3 = 1;
        } else if (string.equalsIgnoreCase(familyDescription.italicFullName)) {
            n3 = 2;
        } else if (string.equalsIgnoreCase(familyDescription.boldItalicFullName)) {
            n3 = 3;
        }
        if (n3 == -1 && !string.equalsIgnoreCase(familyDescription.familyName)) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        this.getPlatformFontDirs(noType1Font);
        if (familyDescription.plainFileName != null && (string3 = this.getPathName(familyDescription.plainFileName)) == null) {
            bl = true;
        }
        if (familyDescription.boldFileName != null && (string4 = this.getPathName(familyDescription.boldFileName)) == null) {
            bl = true;
        }
        if (familyDescription.italicFileName != null && (string5 = this.getPathName(familyDescription.italicFileName)) == null) {
            bl = true;
        }
        if (familyDescription.boldItalicFileName != null && (string6 = this.getPathName(familyDescription.boldItalicFileName)) == null) {
            bl = true;
        }
        if (bl) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Hardcoded file missing looking for " + string);
            }
            platformFontMap.remove(string2);
            return null;
        }
        final String[] stringArray = new String[]{string3, string4, string5, string6};
        bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file;
                    if (stringArray[i] == null || (file = new File(stringArray[i])).exists()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (bl) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Hardcoded file missing looking for " + string);
            }
            platformFontMap.remove(string2);
            return null;
        }
        Font2D font2D = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            PhysicalFont physicalFont = this.registerFontFile(stringArray[i], null, 0, false, 3);
            if (i != n3) continue;
            font2D = physicalFont;
        }
        FontFamily fontFamily = FontFamily.getFamily(familyDescription.familyName);
        if (fontFamily != null) {
            if (font2D == null) {
                font2D = fontFamily.getFont(n);
                if (font2D == null) {
                    font2D = fontFamily.getClosestStyle(n);
                }
            } else if (n > 0 && n != font2D.style && (font2D = fontFamily.getFont(n |= font2D.style)) == null) {
                font2D = fontFamily.getClosestStyle(n);
            }
        }
        return font2D;
    }

    private synchronized HashMap<String, String> getFullNameToFileMap() {
        if (this.fontToFileMap == null) {
            this.pathDirs = this.getPlatformFontDirs(noType1Font);
            this.fontToFileMap = new HashMap(100);
            this.fontToFamilyNameMap = new HashMap(100);
            this.familyToFontListMap = new HashMap(50);
            this.populateFontFileNameMap(this.fontToFileMap, this.fontToFamilyNameMap, this.familyToFontListMap, Locale.ENGLISH);
            if (FontUtilities.isWindows) {
                this.resolveWindowsFonts();
            }
            if (FontUtilities.isLogging()) {
                this.logPlatformFontInfo();
            }
        }
        return this.fontToFileMap;
    }

    private void logPlatformFontInfo() {
        PlatformLogger platformLogger = FontUtilities.getLogger();
        for (int i = 0; i < this.pathDirs.length; ++i) {
            platformLogger.info("fontdir=" + this.pathDirs[i]);
        }
        for (String string : this.fontToFileMap.keySet()) {
            platformLogger.info("font=" + string + " file=" + this.fontToFileMap.get(string));
        }
        for (String string : this.fontToFamilyNameMap.keySet()) {
            platformLogger.info("font=" + string + " family=" + this.fontToFamilyNameMap.get(string));
        }
        for (String string : this.familyToFontListMap.keySet()) {
            platformLogger.info("family=" + string + " fonts=" + this.familyToFontListMap.get(string));
        }
    }

    protected String[] getFontNamesFromPlatform() {
        if (this.getFullNameToFileMap().size() == 0) {
            return null;
        }
        this.checkForUnreferencedFontFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ArrayList<String> arrayList2 : this.familyToFontListMap.values()) {
            for (String string : arrayList2) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(STR_ARRAY);
    }

    public boolean gotFontsFromPlatform() {
        return this.getFullNameToFileMap().size() != 0;
    }

    public String getFileNameForFontName(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return this.fontToFileMap.get(string2);
    }

    private PhysicalFont registerFontFile(String string) {
        if (new File(string).isAbsolute() && !this.registeredFonts.contains(string)) {
            int n = -1;
            int n2 = 6;
            if (ttFilter.accept(null, string)) {
                n = 0;
                n2 = 3;
            } else if (t1Filter.accept(null, string)) {
                n = 1;
                n2 = 4;
            }
            if (n == -1) {
                return null;
            }
            return this.registerFontFile(string, null, n, false, n2);
        }
        return null;
    }

    protected void registerOtherFontFiles(HashSet hashSet) {
        if (this.getFullNameToFileMap().size() == 0) {
            return;
        }
        for (String string : this.fontToFileMap.values()) {
            this.registerFontFile(string);
        }
    }

    public boolean getFamilyNamesFromPlatform(TreeMap<String, String> treeMap, Locale locale) {
        if (this.getFullNameToFileMap().size() == 0) {
            return false;
        }
        this.checkForUnreferencedFontFiles();
        for (String string : this.fontToFamilyNameMap.values()) {
            treeMap.put(string.toLowerCase(locale), string);
        }
        return true;
    }

    private String getPathName(final String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (this.pathDirs.length == 1) {
            return this.pathDirs[0] + File.separator + string;
        }
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                for (int i = 0; i < SunFontManager.this.pathDirs.length; ++i) {
                    File file = new File(SunFontManager.this.pathDirs[i] + File.separator + string);
                    if (!file.exists()) continue;
                    return file.getAbsolutePath();
                }
                return null;
            }
        });
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private Font2D findFontFromPlatform(String string, int n) {
        Object object;
        String[] stringArray;
        if (this.getFullNameToFileMap().size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = null;
        String string2 = null;
        String string3 = this.fontToFamilyNameMap.get(string);
        if (string3 != null) {
            string2 = this.fontToFileMap.get(string);
            arrayList = this.familyToFontListMap.get(string3.toLowerCase(Locale.ENGLISH));
        } else {
            arrayList = this.familyToFontListMap.get(string);
            if (arrayList != null && arrayList.size() > 0 && (stringArray = arrayList.get(0).toLowerCase(Locale.ENGLISH)) != null) {
                string3 = this.fontToFamilyNameMap.get(stringArray);
            }
        }
        if (arrayList == null || string3 == null) {
            return null;
        }
        stringArray = arrayList.toArray(STR_ARRAY);
        if (stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i].toLowerCase(Locale.ENGLISH);
            object = this.fontToFileMap.get(string4);
            if (object != null) continue;
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Platform lookup : No file for font " + stringArray[i] + " in family " + string3);
            }
            return null;
        }
        PhysicalFont physicalFont = null;
        if (string2 != null) {
            physicalFont = this.registerFontFile(this.getPathName(string2), null, 0, false, 3);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].toLowerCase(Locale.ENGLISH);
            String string5 = this.fontToFileMap.get(object);
            if (string2 != null && string2.equals(string5)) continue;
            this.registerFontFile(this.getPathName(string5), null, 0, false, 3);
        }
        Font2D font2D = null;
        object = FontFamily.getFamily(string3);
        if (physicalFont != null) {
            n |= physicalFont.style;
        }
        if (object != null && (font2D = ((FontFamily)object).getFont(n)) == null) {
            font2D = ((FontFamily)object).getClosestStyle(n);
        }
        return font2D;
    }

    @Override
    public Font2D findFont2D(String string, int n, int n2) {
        Object object;
        Object object2;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2 + SunFontManager.dotStyleStr(n);
        Font2D font2D = this._usingPerAppContextComposites ? ((object2 = (ConcurrentHashMap)AppContext.getAppContext().get(CompositeFont.class)) != null ? (Font2D)((ConcurrentHashMap)object2).get(string3) : null) : this.fontNameCache.get(string3);
        if (font2D != null) {
            return font2D;
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Search for font: " + string);
        }
        if (FontUtilities.isWindows) {
            if (string2.equals("ms sans serif")) {
                string = "sansserif";
            } else if (string2.equals("ms serif")) {
                string = "serif";
            }
        }
        if (string2.equals("default")) {
            string = "dialog";
        }
        if ((object2 = FontFamily.getFamily(string)) != null) {
            font2D = ((FontFamily)object2).getFontWithExactStyleMatch(n);
            if (font2D == null) {
                font2D = this.findDeferredFont(string, n);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getFont(n);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getClosestStyle(n);
            }
            if (font2D != null) {
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if ((font2D = this.fullNameToFont.get(string2)) != null) {
            if (font2D.style == n || n == 0) {
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
            object2 = FontFamily.getFamily(font2D.getFamilyName(null));
            if (object2 != null) {
                object = ((FontFamily)object2).getFont(n | font2D.style);
                if (object != null) {
                    this.fontNameCache.put(string3, (Font2D)object);
                    return object;
                }
                object = ((FontFamily)object2).getClosestStyle(n | font2D.style);
                if (object != null && ((Font2D)object).canDoStyle(n | font2D.style)) {
                    this.fontNameCache.put(string3, (Font2D)object);
                    return object;
                }
            }
        }
        if (FontUtilities.isWindows) {
            font2D = this.findFontFromPlatformMap(string2, n);
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("findFontFromPlatformMap returned " + font2D);
            }
            if (font2D != null) {
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (this.deferredFontFiles.size() > 0 && (font2D = this.findJREDeferredFont(string2, n)) != null) {
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
            font2D = this.findFontFromPlatform(string2, n);
            if (font2D != null) {
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().info("Found font via platform API for request:\"" + string + "\":, style=" + n + " found font: " + font2D);
                }
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if (this.deferredFontFiles.size() > 0 && (font2D = this.findDeferredFont(string, n)) != null) {
            this.fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (FontUtilities.isSolaris && !this.loaded1dot0Fonts) {
            if (string2.equals("timesroman")) {
                font2D = this.findFont2D("serif", n, n2);
                this.fontNameCache.put(string3, font2D);
            }
            this.register1dot0Fonts();
            this.loaded1dot0Fonts = true;
            object = this.findFont2D(string, n, n2);
            return object;
        }
        if (this.fontsAreRegistered || this.fontsAreRegisteredPerAppContext) {
            Hashtable hashtable;
            object = null;
            if (this.fontsAreRegistered) {
                object = this.createdByFamilyName;
                hashtable = this.createdByFullName;
            } else {
                AppContext appContext = AppContext.getAppContext();
                object = (Hashtable)appContext.get(regFamilyKey);
                hashtable = (Hashtable)appContext.get(regFullNameKey);
            }
            object2 = (FontFamily)((Hashtable)object).get(string2);
            if (object2 != null) {
                font2D = ((FontFamily)object2).getFontWithExactStyleMatch(n);
                if (font2D == null) {
                    font2D = ((FontFamily)object2).getFont(n);
                }
                if (font2D == null) {
                    font2D = ((FontFamily)object2).getClosestStyle(n);
                }
                if (font2D != null) {
                    if (this.fontsAreRegistered) {
                        this.fontNameCache.put(string3, font2D);
                    }
                    return font2D;
                }
            }
            if ((font2D = (Font2D)hashtable.get(string2)) != null) {
                if (this.fontsAreRegistered) {
                    this.fontNameCache.put(string3, font2D);
                }
                return font2D;
            }
        }
        if (!this.loadedAllFonts) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Load fonts looking for:" + string);
            }
            this.loadFonts();
            this.loadedAllFonts = true;
            return this.findFont2D(string, n, n2);
        }
        if (!this.loadedAllFontFiles) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("Load font files looking for:" + string);
            }
            this.loadFontFiles();
            this.loadedAllFontFiles = true;
            return this.findFont2D(string, n, n2);
        }
        font2D = this.findFont2DAllLocales(string, n);
        if (font2D != null) {
            this.fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (FontUtilities.isWindows) {
            object = this.getFontConfiguration().getFallbackFamilyName(string, null);
            if (object != null) {
                font2D = this.findFont2D((String)object, n, n2);
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
        } else {
            if (string2.equals("timesroman")) {
                font2D = this.findFont2D("serif", n, n2);
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("helvetica")) {
                font2D = this.findFont2D("sansserif", n, n2);
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("courier")) {
                font2D = this.findFont2D("monospaced", n, n2);
                this.fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("No font found for:" + string);
        }
        switch (n2) {
            case 1: {
                return this.getDefaultPhysicalFont();
            }
            case 2: {
                return this.getDefaultLogicalFont(n);
            }
        }
        return null;
    }

    public boolean usePlatformFontMetrics() {
        return this.usePlatformFontMetrics;
    }

    public int getNumFonts() {
        return this.physicalFonts.size() + this.maxCompFont;
    }

    private static boolean fontSupportsEncoding(Font font, String string) {
        return FontUtilities.getFont2D(font).supportsEncoding(string);
    }

    protected abstract String getFontPath(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Font2D createFont2D(File file, int n, boolean bl, CreatedFontTracker createdFontTracker) throws FontFormatException {
        String string = file.getPath();
        FileFont fileFont = null;
        final File file2 = file;
        final CreatedFontTracker createdFontTracker2 = createdFontTracker;
        try {
            switch (n) {
                case 0: {
                    fileFont = new TrueTypeFont(string, null, 0, true);
                    break;
                }
                case 1: {
                    fileFont = new Type1Font(string, null, bl);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException fontFormatException) {
            if (!bl) throw fontFormatException;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (createdFontTracker2 != null) {
                        createdFontTracker2.subBytes((int)file2.length());
                    }
                    file2.delete();
                    return null;
                }
            });
            throw fontFormatException;
        }
        if (!bl) return fileFont;
        fileFont.setFileToRemove(file, createdFontTracker);
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (this.tmpFontFiles == null) {
                this.tmpFontFiles = new Vector();
            }
            this.tmpFontFiles.add(file);
            if (this.fileCloser != null) return fileFont;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            for (int i = 0; i < 20; ++i) {
                                if (SunFontManager.this.fontFileCache[i] == null) continue;
                                try {
                                    SunFontManager.this.fontFileCache[i].close();
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (SunFontManager.this.tmpFontFiles != null) {
                                File[] fileArray = new File[SunFontManager.this.tmpFontFiles.size()];
                                fileArray = SunFontManager.this.tmpFontFiles.toArray(fileArray);
                                for (int i = 0; i < fileArray.length; ++i) {
                                    try {
                                        fileArray[i].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(() -> {
                ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
                this.fileCloser = new Thread(threadGroup, runnable);
                this.fileCloser.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(this.fileCloser);
                return null;
            });
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return fileFont;
        }
    }

    public synchronized String getFullNameByFileName(String string) {
        PhysicalFont[] physicalFontArray = this.getPhysicalFonts();
        for (int i = 0; i < physicalFontArray.length; ++i) {
            if (!physicalFontArray[i].platName.equals(string)) continue;
            return physicalFontArray[i].getFontName(null);
        }
        return null;
    }

    @Override
    public synchronized void deRegisterBadFont(Font2D font2D) {
        if (!(font2D instanceof PhysicalFont)) {
            return;
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().severe("Deregister bad font: " + font2D);
        }
        this.replaceFont((PhysicalFont)font2D, this.getDefaultPhysicalFont());
    }

    public synchronized void replaceFont(PhysicalFont physicalFont, PhysicalFont physicalFont2) {
        int n;
        Object[] objectArray;
        if (physicalFont.handle.font2D != physicalFont) {
            return;
        }
        if (physicalFont == physicalFont2) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().severe("Can't replace bad font with itself " + physicalFont);
            }
            objectArray = this.getPhysicalFonts();
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == physicalFont2) continue;
                physicalFont2 = objectArray[n];
                break;
            }
            if (physicalFont == physicalFont2) {
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().severe("This is bad. No good physicalFonts found.");
                }
                return;
            }
        }
        physicalFont.handle.font2D = physicalFont2;
        this.physicalFonts.remove(physicalFont.fullName);
        this.fullNameToFont.remove(physicalFont.fullName.toLowerCase(Locale.ENGLISH));
        FontFamily.remove(physicalFont);
        if (this.localeFullNamesToFont != null) {
            objectArray = this.localeFullNamesToFont.entrySet().toArray(new Map.Entry[0]);
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n].getValue() != physicalFont) continue;
                try {
                    objectArray[n].setValue(physicalFont2);
                    continue;
                }
                catch (Exception exception) {
                    this.localeFullNamesToFont.remove(objectArray[n].getKey());
                }
            }
        }
        for (int i = 0; i < this.maxCompFont; ++i) {
            if (physicalFont2.getRank() <= 2) continue;
            this.compFonts[i].replaceComponentFont(physicalFont, physicalFont2);
        }
    }

    private synchronized void loadLocaleNames() {
        if (this.localeFullNamesToFont != null) {
            return;
        }
        this.localeFullNamesToFont = new HashMap();
        Font2D[] font2DArray = this.getRegisteredFonts();
        for (int i = 0; i < font2DArray.length; ++i) {
            if (!(font2DArray[i] instanceof TrueTypeFont)) continue;
            TrueTypeFont trueTypeFont = (TrueTypeFont)font2DArray[i];
            String[] stringArray = trueTypeFont.getAllFullNames();
            for (int j = 0; j < stringArray.length; ++j) {
                this.localeFullNamesToFont.put(stringArray[j], trueTypeFont);
            }
            FontFamily fontFamily = FontFamily.getFamily(trueTypeFont.familyName);
            if (fontFamily == null) continue;
            FontFamily.addLocaleNames(fontFamily, trueTypeFont.getAllFamilyNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Font2D findFont2DAllLocales(String string, int n) {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Searching localised font names for:" + string);
        }
        if (this.localeFullNamesToFont == null) {
            this.loadLocaleNames();
        }
        String string2 = string.toLowerCase();
        Font2D font2D = null;
        FontFamily fontFamily = FontFamily.getLocaleFamily(string2);
        if (fontFamily != null) {
            font2D = fontFamily.getFont(n);
            if (font2D == null) {
                font2D = fontFamily.getClosestStyle(n);
            }
            if (font2D != null) {
                return font2D;
            }
        }
        Object object = this;
        synchronized (object) {
            font2D = this.localeFullNamesToFont.get(string);
        }
        if (font2D != null) {
            if (font2D.style == n || n == 0) {
                return font2D;
            }
            fontFamily = FontFamily.getFamily(font2D.getFamilyName(null));
            if (fontFamily != null) {
                object = fontFamily.getFont(n);
                if (object != null) {
                    return object;
                }
                object = fontFamily.getClosestStyle(n);
                if (object != null) {
                    if (!((Font2D)object).canDoStyle(n)) {
                        object = null;
                    }
                    return object;
                }
            }
        }
        return font2D;
    }

    public boolean maybeUsingAlternateCompositeFonts() {
        return this._usingAlternateComposites || this._usingPerAppContextComposites;
    }

    public boolean usingAlternateCompositeFonts() {
        return this._usingAlternateComposites || this._usingPerAppContextComposites && AppContext.getAppContext().get(CompositeFont.class) != null;
    }

    private static boolean maybeMultiAppContext() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager securityManager = System.getSecurityManager();
                return new Boolean(securityManager instanceof AppletSecurity);
            }
        });
        return bl;
    }

    @Override
    public synchronized void useAlternateFontforJALocales() {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Entered useAlternateFontforJALocales().");
        }
        if (!FontUtilities.isWindows) {
            return;
        }
        if (!SunFontManager.maybeMultiAppContext()) {
            gAltJAFont = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            appContext.put(altJAFontKey, altJAFontKey);
        }
    }

    public boolean usingAlternateFontforJALocales() {
        if (!SunFontManager.maybeMultiAppContext()) {
            return gAltJAFont;
        }
        AppContext appContext = AppContext.getAppContext();
        return appContext.get(altJAFontKey) == altJAFontKey;
    }

    @Override
    public synchronized void preferLocaleFonts() {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Entered preferLocaleFonts().");
        }
        if (!FontConfiguration.willReorderForStartupLocale()) {
            return;
        }
        if (!SunFontManager.maybeMultiAppContext()) {
            if (this.gLocalePref) {
                return;
            }
            this.gLocalePref = true;
            this.createCompositeFonts(this.fontNameCache, this.gLocalePref, this.gPropPref);
            this._usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(localeFontKey) == localeFontKey) {
                return;
            }
            appContext.put(localeFontKey, localeFontKey);
            boolean bl = appContext.get(proportionalFontKey) == proportionalFontKey;
            ConcurrentHashMap<String, Font2D> concurrentHashMap = new ConcurrentHashMap<String, Font2D>();
            appContext.put(CompositeFont.class, concurrentHashMap);
            this._usingPerAppContextComposites = true;
            this.createCompositeFonts(concurrentHashMap, true, bl);
        }
    }

    @Override
    public synchronized void preferProportionalFonts() {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Entered preferProportionalFonts().");
        }
        if (!FontConfiguration.hasMonoToPropMap()) {
            return;
        }
        if (!SunFontManager.maybeMultiAppContext()) {
            if (this.gPropPref) {
                return;
            }
            this.gPropPref = true;
            this.createCompositeFonts(this.fontNameCache, this.gLocalePref, this.gPropPref);
            this._usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(proportionalFontKey) == proportionalFontKey) {
                return;
            }
            appContext.put(proportionalFontKey, proportionalFontKey);
            boolean bl = appContext.get(localeFontKey) == localeFontKey;
            ConcurrentHashMap<String, Font2D> concurrentHashMap = new ConcurrentHashMap<String, Font2D>();
            appContext.put(CompositeFont.class, concurrentHashMap);
            this._usingPerAppContextComposites = true;
            this.createCompositeFonts(concurrentHashMap, bl, true);
        }
    }

    private static HashSet<String> getInstalledNames() {
        if (installedNames == null) {
            int n;
            Locale locale = SunFontManager.getSystemStartupLocale();
            SunFontManager sunFontManager = SunFontManager.getInstance();
            String[] stringArray = sunFontManager.getInstalledFontFamilyNames(locale);
            Font[] fontArray = sunFontManager.getAllInstalledFonts();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n].toLowerCase(locale));
            }
            for (n = 0; n < fontArray.length; ++n) {
                hashSet.add(fontArray[n].getFontName(locale).toLowerCase(locale));
            }
            installedNames = hashSet;
        }
        return installedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerFont(Font font) {
        Object object;
        Hashtable<String, Object> hashtable;
        Hashtable<String, FontFamily> hashtable2;
        if (font == null) {
            return false;
        }
        HashSet<String> hashSet = regFamilyKey;
        synchronized (hashSet) {
            if (this.createdByFamilyName == null) {
                this.createdByFamilyName = new Hashtable();
                this.createdByFullName = new Hashtable();
            }
        }
        if (!FontAccess.getFontAccess().isCreatedFont(font)) {
            return false;
        }
        hashSet = SunFontManager.getInstalledNames();
        Locale locale = SunFontManager.getSystemStartupLocale();
        String string = font.getFamily(locale).toLowerCase();
        String string2 = font.getFontName(locale).toLowerCase();
        if (hashSet.contains(string) || hashSet.contains(string2)) {
            return false;
        }
        if (!SunFontManager.maybeMultiAppContext()) {
            hashtable2 = this.createdByFamilyName;
            hashtable = this.createdByFullName;
            this.fontsAreRegistered = true;
        } else {
            object = AppContext.getAppContext();
            hashtable2 = (Hashtable<String, FontFamily>)((AppContext)object).get(regFamilyKey);
            hashtable = (Hashtable<String, Object>)((AppContext)object).get(regFullNameKey);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, FontFamily>();
                hashtable = new Hashtable<String, Object>();
                ((AppContext)object).put(regFamilyKey, hashtable2);
                ((AppContext)object).put(regFullNameKey, hashtable);
            }
            this.fontsAreRegisteredPerAppContext = true;
        }
        object = FontUtilities.getFont2D(font);
        int n = ((Font2D)object).getStyle();
        FontFamily fontFamily = (FontFamily)hashtable2.get(string);
        if (fontFamily == null) {
            fontFamily = new FontFamily(font.getFamily(locale));
            hashtable2.put(string, fontFamily);
        }
        if (this.fontsAreRegistered) {
            this.removeFromCache(fontFamily.getFont(0));
            this.removeFromCache(fontFamily.getFont(1));
            this.removeFromCache(fontFamily.getFont(2));
            this.removeFromCache(fontFamily.getFont(3));
            this.removeFromCache((Font2D)hashtable.get(string2));
        }
        fontFamily.setFont((Font2D)object, n);
        hashtable.put(string2, object);
        return true;
    }

    private void removeFromCache(Font2D font2D) {
        if (font2D == null) {
            return;
        }
        String[] stringArray = ((ConcurrentHashMap.CollectionView)((Object)this.fontNameCache.keySet())).toArray(STR_ARRAY);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.fontNameCache.get(stringArray[i]) != font2D) continue;
            this.fontNameCache.remove(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<String, String> getCreatedFontFamilyNames() {
        Object object;
        Hashtable hashtable;
        if (this.fontsAreRegistered) {
            hashtable = this.createdByFamilyName;
        } else if (this.fontsAreRegisteredPerAppContext) {
            object = AppContext.getAppContext();
            hashtable = (Hashtable)((AppContext)object).get(regFamilyKey);
        } else {
            return null;
        }
        object = SunFontManager.getSystemStartupLocale();
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (FontFamily fontFamily : hashtable.values()) {
                Font2D font2D = fontFamily.getFont(0);
                if (font2D == null) {
                    font2D = fontFamily.getClosestStyle(0);
                }
                String string = font2D.getFamilyName((Locale)object);
                treeMap.put(string.toLowerCase((Locale)object), string);
            }
            return treeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Font[] getCreatedFonts() {
        Object object;
        Hashtable hashtable;
        if (this.fontsAreRegistered) {
            hashtable = this.createdByFullName;
        } else if (this.fontsAreRegisteredPerAppContext) {
            object = AppContext.getAppContext();
            hashtable = (Hashtable)((AppContext)object).get(regFullNameKey);
        } else {
            return null;
        }
        object = SunFontManager.getSystemStartupLocale();
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Font[] fontArray = new Font[hashtable.size()];
            int n = 0;
            for (Font2D font2D : hashtable.values()) {
                fontArray[n++] = new Font(font2D.getFontName((Locale)object), 0, 1);
            }
            return fontArray;
        }
    }

    protected String[] getPlatformFontDirs(boolean bl) {
        if (this.pathDirs != null) {
            return this.pathDirs;
        }
        String string = this.getPlatformFontPath(bl);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.pathDirs = arrayList.toArray(new String[0]);
        return this.pathDirs;
    }

    protected abstract String[] getDefaultPlatformFont();

    private void addDirFonts(String string, File file, FilenameFilter filenameFilter, int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        String[][] stringArray3 = new String[stringArray.length][];
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            String string2 = null;
            if (bl3) {
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string2 == null) {
                string2 = string + File.separator + stringArray[i];
            }
            if (this.registeredFontFiles.contains(string2)) continue;
            if (this.badFonts != null && this.badFonts.contains(string2)) {
                if (!FontUtilities.debugFonts()) continue;
                FontUtilities.getLogger().warning("skip bad font " + string2);
                continue;
            }
            this.registeredFontFiles.add(string2);
            if (FontUtilities.debugFonts() && FontUtilities.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                String string3 = "Registering font " + string2;
                String[] stringArray4 = this.getNativeNames(string2, null);
                if (stringArray4 == null) {
                    string3 = string3 + " with no native name";
                } else {
                    string3 = string3 + " with native name(s) " + stringArray4[0];
                    for (int j = 1; j < stringArray4.length; ++j) {
                        string3 = string3 + ", " + stringArray4[j];
                    }
                }
                FontUtilities.getLogger().info(string3);
            }
            stringArray2[n3] = string2;
            stringArray3[n3++] = this.getNativeNames(string2, null);
        }
        this.registerFonts(stringArray2, stringArray3, n3, n, bl, n2, bl2);
    }

    protected String[] getNativeNames(String string, String string2) {
        return null;
    }

    protected String getFileNameFromPlatformName(String string) {
        return this.fontConfig.getFileNameFromPlatformName(string);
    }

    @Override
    public FontConfiguration getFontConfiguration() {
        return this.fontConfig;
    }

    public String getPlatformFontPath(boolean bl) {
        if (this.fontPath == null) {
            this.fontPath = this.getFontPath(bl);
        }
        return this.fontPath;
    }

    public static boolean isOpenJDK() {
        return FontUtilities.isOpenJDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFonts() {
        if (this.discoveredAllFonts) {
            return;
        }
        SunFontManager sunFontManager = this;
        synchronized (sunFontManager) {
            if (FontUtilities.debugFonts()) {
                Thread.dumpStack();
                FontUtilities.getLogger().info("SunGraphicsEnvironment.loadFonts() called");
            }
            this.initialiseDeferredFonts();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SunFontManager.this.fontPath == null) {
                        SunFontManager.this.fontPath = SunFontManager.this.getPlatformFontPath(noType1Font);
                        SunFontManager.this.registerFontDirs(SunFontManager.this.fontPath);
                    }
                    if (SunFontManager.this.fontPath != null && !SunFontManager.this.gotFontsFromPlatform()) {
                        SunFontManager.this.registerFontsOnPath(SunFontManager.this.fontPath, false, 6, false, true);
                        SunFontManager.this.loadedAllFontFiles = true;
                    }
                    SunFontManager.this.registerOtherFontFiles(SunFontManager.this.registeredFontFiles);
                    SunFontManager.this.discoveredAllFonts = true;
                    return null;
                }
            });
        }
    }

    protected void registerFontDirs(String string) {
    }

    private void registerFontsOnPath(String string, boolean bl, int n, boolean bl2, boolean bl3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                this.registerFontsInDir(stringTokenizer.nextToken(), bl, n, bl2, bl3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void registerFontsInDir(String string) {
        this.registerFontsInDir(string, true, 2, true, false);
    }

    protected void registerFontsInDir(String string, boolean bl, int n, boolean bl2, boolean bl3) {
        File file = new File(string);
        this.addDirFonts(string, file, ttFilter, 0, bl, n == 6 ? 3 : n, bl2, bl3);
        this.addDirFonts(string, file, t1Filter, 1, bl, n == 6 ? 4 : n, bl2, bl3);
    }

    protected void registerFontDir(String string) {
    }

    public synchronized String getDefaultFontFile() {
        if (this.defaultFontFileName == null) {
            this.initDefaultFonts();
        }
        return this.defaultFontFileName;
    }

    private void initDefaultFonts() {
        if (!SunFontManager.isOpenJDK()) {
            this.defaultFontName = lucidaFontName;
            this.defaultFontFileName = this.useAbsoluteFontFileNames() ? jreFontDirName + File.separator + "LucidaSansRegular.ttf" : "LucidaSansRegular.ttf";
        }
    }

    protected boolean useAbsoluteFontFileNames() {
        return true;
    }

    protected abstract FontConfiguration createFontConfiguration();

    public abstract FontConfiguration createFontConfiguration(boolean var1, boolean var2);

    public synchronized String getDefaultFontFaceName() {
        if (this.defaultFontName == null) {
            this.initDefaultFonts();
        }
        return this.defaultFontName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFontFiles() {
        this.loadFonts();
        if (this.loadedAllFontFiles) {
            return;
        }
        SunFontManager sunFontManager = this;
        synchronized (sunFontManager) {
            if (FontUtilities.debugFonts()) {
                Thread.dumpStack();
                FontUtilities.getLogger().info("loadAllFontFiles() called");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SunFontManager.this.fontPath == null) {
                        SunFontManager.this.fontPath = SunFontManager.this.getPlatformFontPath(noType1Font);
                    }
                    if (SunFontManager.this.fontPath != null) {
                        SunFontManager.this.registerFontsOnPath(SunFontManager.this.fontPath, false, 6, false, true);
                    }
                    SunFontManager.this.loadedAllFontFiles = true;
                    return null;
                }
            });
        }
    }

    private void initCompositeFonts(FontConfiguration fontConfiguration, ConcurrentHashMap<String, Font2D> concurrentHashMap) {
        String[] stringArray;
        Object object;
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Initialising composite fonts");
        }
        int n = fontConfiguration.getNumberCoreFonts();
        String[] stringArray2 = fontConfiguration.getPlatformFontNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            object = this.getFileNameFromPlatformName(string);
            stringArray = null;
            if (object == null || ((String)object).equals(string)) {
                object = string;
            } else {
                if (i < n) {
                    this.addFontToPlatformFontPath(string);
                }
                stringArray = this.getNativeNames((String)object, string);
            }
            this.registerFontFile((String)object, stringArray, 2, true);
        }
        this.registerPlatformFontsUsedByFontConfiguration();
        CompositeFontDescriptor[] compositeFontDescriptorArray = fontConfiguration.get2DCompositeFontInfo();
        for (int i = 0; i < compositeFontDescriptorArray.length; ++i) {
            object = compositeFontDescriptorArray[i];
            stringArray = ((CompositeFontDescriptor)object).getComponentFileNames();
            String[] stringArray3 = ((CompositeFontDescriptor)object).getComponentFaceNames();
            if (missingFontFiles != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!missingFontFiles.contains(stringArray[j])) continue;
                    stringArray[j] = this.getDefaultFontFile();
                    stringArray3[j] = this.getDefaultFontFaceName();
                }
            }
            if (concurrentHashMap != null) {
                SunFontManager.registerCompositeFont(((CompositeFontDescriptor)object).getFaceName(), stringArray, stringArray3, ((CompositeFontDescriptor)object).getCoreComponentCount(), ((CompositeFontDescriptor)object).getExclusionRanges(), ((CompositeFontDescriptor)object).getExclusionRangeLimits(), true, concurrentHashMap);
            } else {
                this.registerCompositeFont(((CompositeFontDescriptor)object).getFaceName(), stringArray, stringArray3, ((CompositeFontDescriptor)object).getCoreComponentCount(), ((CompositeFontDescriptor)object).getExclusionRanges(), ((CompositeFontDescriptor)object).getExclusionRangeLimits(), true);
            }
            if (!FontUtilities.debugFonts()) continue;
            FontUtilities.getLogger().info("registered " + ((CompositeFontDescriptor)object).getFaceName());
        }
    }

    protected void addFontToPlatformFontPath(String string) {
    }

    protected void registerFontFile(String string, String[] stringArray, int n, boolean bl) {
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        int n2 = ttFilter.accept(null, string) ? 0 : (t1Filter.accept(null, string) ? 1 : 5);
        this.registeredFontFiles.add(string);
        if (bl) {
            this.registerDeferredFont(string, string, stringArray, n2, false, n);
        } else {
            this.registerFontFile(string, stringArray, n2, false, n);
        }
    }

    protected void registerPlatformFontsUsedByFontConfiguration() {
    }

    protected void addToMissingFontFileList(String string) {
        if (missingFontFiles == null) {
            missingFontFiles = new HashSet();
        }
        missingFontFiles.add(string);
    }

    private boolean isNameForRegisteredFile(String string) {
        String string2 = this.getFileNameForFontName(string);
        if (string2 == null) {
            return false;
        }
        return this.registeredFontFiles.contains(string2);
    }

    public void createCompositeFonts(ConcurrentHashMap<String, Font2D> concurrentHashMap, boolean bl, boolean bl2) {
        FontConfiguration fontConfiguration = this.createFontConfiguration(bl, bl2);
        this.initCompositeFonts(fontConfiguration, concurrentHashMap);
    }

    @Override
    public Font[] getAllInstalledFonts() {
        Font[] fontArray;
        if (this.allFonts == null) {
            int n;
            Object[] objectArray;
            this.loadFonts();
            fontArray = new TreeMap();
            Font2D[] font2DArray = this.getRegisteredFonts();
            for (int i = 0; i < font2DArray.length; ++i) {
                if (font2DArray[i] instanceof NativeFont) continue;
                fontArray.put(font2DArray[i].getFontName(null), font2DArray[i]);
            }
            String[] stringArray = this.getFontNamesFromPlatform();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.isNameForRegisteredFile(stringArray[i])) continue;
                    fontArray.put(stringArray[i], null);
                }
            }
            String[] stringArray2 = null;
            if (fontArray.size() > 0) {
                stringArray2 = new String[fontArray.size()];
                objectArray = fontArray.keySet().toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    stringArray2[n] = (String)objectArray[n];
                }
            }
            objectArray = new Font[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                objectArray[n] = new Font(stringArray2[n], 0, 1);
                Font2D font2D = (Font2D)fontArray.get(stringArray2[n]);
                if (font2D == null) continue;
                FontAccess.getFontAccess().setFont2D((Font)objectArray[n], font2D.handle);
            }
            this.allFonts = objectArray;
        }
        fontArray = new Font[this.allFonts.length];
        System.arraycopy(this.allFonts, 0, fontArray, 0, this.allFonts.length);
        return fontArray;
    }

    @Override
    public String[] getInstalledFontFamilyNames(Locale locale) {
        Object[] objectArray;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.allFamilies != null && this.lastDefaultLocale != null && locale.equals(this.lastDefaultLocale)) {
            String[] stringArray = new String[this.allFamilies.length];
            System.arraycopy(this.allFamilies, 0, stringArray, 0, this.allFamilies.length);
            return stringArray;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = "Serif";
        treeMap.put(string.toLowerCase(), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(), string);
        if (locale.equals(SunFontManager.getSystemStartupLocale()) && this.getFamilyNamesFromPlatform(treeMap, locale)) {
            this.getJREFontFamilyNames(treeMap, locale);
        } else {
            this.loadFontFiles();
            objectArray = this.getPhysicalFonts();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof NativeFont) continue;
                String string2 = objectArray[i].getFamilyName(locale);
                treeMap.put(string2.toLowerCase(locale), string2);
            }
        }
        this.addNativeFontFamilyNames(treeMap, locale);
        objectArray = new String[treeMap.size()];
        Object[] objectArray2 = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray[i] = treeMap.get(objectArray2[i]);
        }
        if (locale.equals(Locale.getDefault())) {
            this.lastDefaultLocale = locale;
            this.allFamilies = new String[objectArray.length];
            System.arraycopy(objectArray, 0, this.allFamilies, 0, this.allFamilies.length);
        }
        return objectArray;
    }

    protected void addNativeFontFamilyNames(TreeMap<String, String> treeMap, Locale locale) {
    }

    public void register1dot0Fonts() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = "/usr/openwin/lib/X11/fonts/Type1";
                SunFontManager.this.registerFontsInDir(string, true, 4, false, false);
                return null;
            }
        });
    }

    protected void getJREFontFamilyNames(TreeMap<String, String> treeMap, Locale locale) {
        this.registerDeferredJREFonts(jreFontDirName);
        PhysicalFont[] physicalFontArray = this.getPhysicalFonts();
        for (int i = 0; i < physicalFontArray.length; ++i) {
            if (physicalFontArray[i] instanceof NativeFont) continue;
            String string = physicalFontArray[i].getFamilyName(locale);
            treeMap.put(string.toLowerCase(locale), string);
        }
    }

    private static Locale getSystemStartupLocale() {
        if (systemLocale == null) {
            systemLocale = (Locale)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("file.encoding", "");
                    String string2 = System.getProperty("sun.jnu.encoding");
                    if (string2 != null && !string2.equals(string)) {
                        return Locale.ROOT;
                    }
                    String string3 = System.getProperty("user.language", "en");
                    String string4 = System.getProperty("user.country", "");
                    String string5 = System.getProperty("user.variant", "");
                    return new Locale(string3, string4, string5);
                }
            });
        }
        return systemLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPool(FileFont fileFont) {
        FileFont fileFont2 = null;
        int n = -1;
        FileFont[] fileFontArray = this.fontFileCache;
        synchronized (this.fontFileCache) {
            for (int i = 0; i < 20; ++i) {
                if (this.fontFileCache[i] == fileFont) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (this.fontFileCache[i] != null || n >= 0) continue;
                n = i;
            }
            if (n >= 0) {
                this.fontFileCache[n] = fileFont;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            fileFont2 = this.fontFileCache[this.lastPoolIndex];
            this.fontFileCache[this.lastPoolIndex] = fileFont;
            this.lastPoolIndex = (this.lastPoolIndex + 1) % 20;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (fileFont2 != null) {
                fileFont2.close();
            }
            return;
        }
    }

    protected FontUIResource getFontConfigFUIR(String string, int n, int n2) {
        return new FontUIResource(string, n, n2);
    }

    static {
        missingFontFiles = null;
        ttFilter = new TTFilter();
        t1Filter = new T1Filter();
        STR_ARRAY = new String[0];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FontManagerNativeLibrary.load();
                SunFontManager.initIDs();
                switch (StrikeCache.nativeAddressSize) {
                    case 8: {
                        longAddresses = true;
                        break;
                    }
                    case 4: {
                        longAddresses = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected address size");
                    }
                }
                noType1Font = "true".equals(System.getProperty("sun.java2d.noType1Font"));
                jreLibDirName = System.getProperty("java.home", "") + File.separator + "lib";
                jreFontDirName = jreLibDirName + File.separator + "fonts";
                File file = new File(jreFontDirName + File.separator + "LucidaSansRegular.ttf");
                return null;
            }
        });
        altJAFontKey = new Object();
        localeFontKey = new Object();
        proportionalFontKey = new Object();
        gAltJAFont = false;
        installedNames = null;
        regFamilyKey = new Object();
        regFullNameKey = new Object();
        systemLocale = null;
    }

    public static class FamilyDescription {
        public String familyName;
        public String plainFullName;
        public String boldFullName;
        public String italicFullName;
        public String boldItalicFullName;
        public String plainFileName;
        public String boldFileName;
        public String italicFileName;
        public String boldItalicFileName;
    }

    private static final class FontRegistrationInfo {
        String fontFilePath;
        String[] nativeNames;
        int fontFormat;
        boolean javaRasterizer;
        int fontRank;

        FontRegistrationInfo(String string, String[] stringArray, int n, boolean bl, int n2) {
            this.fontFilePath = string;
            this.nativeNames = stringArray;
            this.fontFormat = n;
            this.javaRasterizer = bl;
            this.fontRank = n2;
        }
    }

    private static class TTorT1Filter
    implements FilenameFilter {
        private TTorT1Filter() {
        }

        @Override
        public boolean accept(File file, String string) {
            boolean bl;
            int n = string.length() - 4;
            if (n <= 0) {
                return false;
            }
            boolean bl2 = bl = string.startsWith(".ttf", n) || string.startsWith(".TTF", n) || string.startsWith(".ttc", n) || string.startsWith(".TTC", n) || string.startsWith(".otf", n) || string.startsWith(".OTF", n);
            if (bl) {
                return true;
            }
            if (noType1Font) {
                return false;
            }
            return string.startsWith(".pfa", n) || string.startsWith(".pfb", n) || string.startsWith(".PFA", n) || string.startsWith(".PFB", n);
        }
    }

    private static class T1Filter
    implements FilenameFilter {
        private T1Filter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (noType1Font) {
                return false;
            }
            int n = string.length() - 4;
            if (n <= 0) {
                return false;
            }
            return string.startsWith(".pfa", n) || string.startsWith(".pfb", n) || string.startsWith(".PFA", n) || string.startsWith(".PFB", n);
        }
    }

    private static class TTFilter
    implements FilenameFilter {
        private TTFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            int n = string.length() - 4;
            if (n <= 0) {
                return false;
            }
            return string.startsWith(".ttf", n) || string.startsWith(".TTF", n) || string.startsWith(".ttc", n) || string.startsWith(".TTC", n) || string.startsWith(".otf", n) || string.startsWith(".OTF", n);
        }
    }
}

