/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cliffc.high_scale_lib.Counter;
import org.cliffc.high_scale_lib.IntIterator;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _nbsi_offset;
    private transient NBSI _nbsi;

    private final boolean CAS_nbsi(NBSI old, NBSI nnn) {
        return _unsafe.compareAndSwapObject(this, _nbsi_offset, old, nnn);
    }

    public NonBlockingSetInt() {
        this._nbsi = new NBSI(63, new Counter(), this);
    }

    private NonBlockingSetInt(NonBlockingSetInt a, NonBlockingSetInt b2) {
        this._nbsi = new NBSI(a._nbsi, b2._nbsi, new Counter(), this);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (!NonBlockingSetInt.class.equals(c.getClass())) {
            return super.addAll(c);
        }
        boolean modified = false;
        IntIterator it = ((NonBlockingSetInt)c).intIterator();
        while (it.hasNext()) {
            modified |= this.add(it.next());
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!NonBlockingSetInt.class.equals(c.getClass())) {
            return super.removeAll(c);
        }
        boolean modified = false;
        IntIterator it = ((NonBlockingSetInt)c).intIterator();
        while (it.hasNext()) {
            modified |= this.remove(it.next());
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!NonBlockingSetInt.class.equals(c.getClass())) {
            return super.containsAll(c);
        }
        IntIterator it = ((NonBlockingSetInt)c).intIterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!NonBlockingSetInt.class.equals(c.getClass())) {
            return super.retainAll(c);
        }
        boolean modified = false;
        NonBlockingSetInt nonBlockingSetInt = (NonBlockingSetInt)c;
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            if (nonBlockingSetInt.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            hashCode += it.next();
        }
        return hashCode;
    }

    @Override
    public boolean add(Integer i2) {
        return this.add((int)i2);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Integer && this.remove((Integer)o);
    }

    @Override
    public boolean add(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("" + i2);
        }
        return this._nbsi.add(i2);
    }

    public boolean contains(int i2) {
        return i2 >= 0 && this._nbsi.contains(i2);
    }

    public boolean remove(int i2) {
        return i2 >= 0 && this._nbsi.remove(i2);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    @Override
    public void clear() {
        NBSI cleared = new NBSI(63, new Counter(), this);
        while (!this.CAS_nbsi(this._nbsi, cleared)) {
        }
    }

    @Override
    public String toString() {
        IntIterator it = this.intIterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder().append('[');
        while (true) {
            sb.append(it.next());
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public int sizeInBytes() {
        return this._nbsi.sizeInBytes();
    }

    public NonBlockingSetInt intersect(NonBlockingSetInt op) {
        NonBlockingSetInt res = new NonBlockingSetInt(this, op);
        res._nbsi.intersect(res._nbsi, this._nbsi, op._nbsi);
        return res;
    }

    public NonBlockingSetInt union(NonBlockingSetInt op) {
        NonBlockingSetInt res = new NonBlockingSetInt(this, op);
        res._nbsi.union(res._nbsi, this._nbsi, op._nbsi);
        return res;
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    public IntIterator intIterator() {
        return new NBSIIntIterator();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        NBSI nbsi = this._nbsi;
        int len = this._nbsi._bits.length << 6;
        s2.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            s2.writeBoolean(this._nbsi.contains(i2));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int len = s2.readInt();
        this._nbsi = new NBSI(len, new Counter(), this);
        for (int i2 = 0; i2 < len; ++i2) {
            if (!s2.readBoolean()) continue;
            this._nbsi.add(i2);
        }
    }

    static {
        Field f = null;
        try {
            f = NonBlockingSetInt.class.getDeclaredField("_nbsi");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        _nbsi_offset = _unsafe.objectFieldOffset(f);
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient Counter _size;
        private final long[] _bits;
        private static final int _Lbase = NonBlockingSetInt.access$600().arrayBaseOffset(long[].class);
        private static final int _Lscale = NonBlockingSetInt.access$600().arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset;
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        private final boolean CAS(int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, idx), old, nnn);
        }

        private final boolean CAS_new(NBSI nnn) {
            return _unsafe.compareAndSwapObject(this, _new_offset, null, nnn);
        }

        private static final long mask(int i2) {
            return 1L << (i2 & 0x3F);
        }

        private NBSI(int max_elem, Counter ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            this._copyDone = ctr == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)max_elem + 63L >>> 6)];
            this._nbsi64 = max_elem + 1 >>> 6 == 0 ? null : new NBSI(max_elem + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        private NBSI(NBSI a, NBSI b2, Counter ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            AtomicInteger atomicInteger = this._copyDone = ctr == null ? null : new AtomicInteger();
            if (!NBSI.has_bits(a) && !NBSI.has_bits(b2)) {
                this._bits = null;
                this._nbsi64 = null;
                this._sum_bits_length = 0;
                return;
            }
            if (!NBSI.has_bits(a)) {
                this._bits = new long[b2._bits.length];
                this._nbsi64 = new NBSI(null, b2._nbsi64, null, null);
            } else if (!NBSI.has_bits(b2)) {
                this._bits = new long[a._bits.length];
                this._nbsi64 = new NBSI(null, a._nbsi64, null, null);
            } else {
                int bit_length2 = a._bits.length > b2._bits.length ? a._bits.length : b2._bits.length;
                this._bits = new long[bit_length2];
                this._nbsi64 = new NBSI(a._nbsi64, b2._nbsi64, null, null);
            }
            this._sum_bits_length = this._bits.length + this._nbsi64._sum_bits_length;
        }

        private static boolean has_bits(NBSI n) {
            return n != null && n._bits != null;
        }

        public boolean add(int i2) {
            long old;
            if (i2 >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(i2).help_copy().add(i2);
            }
            NBSI nbsi = this;
            int j = i2;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i2).help_copy().add(i2);
                }
                if ((old & mask) == 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old | mask));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int i2) {
            long old;
            if (i2 >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().remove(i2);
            }
            NBSI nbsi = this;
            int j = i2;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i2).help_copy().remove(i2);
                }
                if ((old & mask) != 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int i2) {
            if (i2 >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().contains(i2);
            }
            NBSI nbsi = this;
            int j = i2;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            long old = nbsi._bits[j >> 6];
            if (old < 0L) {
                return this.help_copy_impl(i2).help_copy().contains(i2);
            }
            return (old & mask) != 0L;
        }

        public boolean intersect(NBSI dest, NBSI a, NBSI b2) {
            if (!NBSI.has_bits(a) || !NBSI.has_bits(b2)) {
                return true;
            }
            for (int i2 = 0; i2 < dest._bits.length; ++i2) {
                long left2 = a.safe_read_word(i2, 0L);
                long right = b2.safe_read_word(i2, 0L);
                dest._bits[i2] = left2 & right & Long.MAX_VALUE;
            }
            return this.intersect(dest._nbsi64, a._nbsi64, b2._nbsi64);
        }

        public boolean union(NBSI dest, NBSI a, NBSI b2) {
            if (!NBSI.has_bits(a) && !NBSI.has_bits(b2)) {
                return true;
            }
            if (NBSI.has_bits(a) || NBSI.has_bits(b2)) {
                for (int i2 = 0; i2 < dest._bits.length; ++i2) {
                    long left2 = a == null ? 0L : a.safe_read_word(i2, 0L);
                    long right = b2 == null ? 0L : b2.safe_read_word(i2, 0L);
                    dest._bits[i2] = (left2 | right) & Long.MAX_VALUE;
                }
            }
            return this.union(dest._nbsi64, a == null ? null : a._nbsi64, b2 == null ? null : b2._nbsi64);
        }

        private long safe_read_word(int i2, long default_word) {
            if (i2 >= this._bits.length) {
                return default_word;
            }
            long word = this._bits[i2];
            if (word < 0L) {
                NBSI nb = this.help_copy_impl(i2);
                if (nb._non_blocking_set_int == null) {
                    return default_word;
                }
                word = nb.help_copy()._bits[i2];
            }
            return word;
        }

        public int sizeInBytes() {
            return this._bits.length;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int i2) {
            if (this._new == null) {
                int sz = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(sz, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI top_nbsi = this._non_blocking_set_int._nbsi;
            int HELP = 8;
            int idx = top_nbsi._copyIdx.getAndAdd(512);
            for (int i2 = 0; i2 < 8; ++i2) {
                int j = idx + i2 * 64;
                top_nbsi.help_copy_impl(j %= top_nbsi._bits.length << 6);
                top_nbsi.help_copy_impl(j + 63);
            }
            if (top_nbsi._copyDone.get() != top_nbsi._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(top_nbsi, top_nbsi._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int i2) {
            NBSI old = this;
            NBSI nnn = this._new;
            if (nnn == null) {
                return this;
            }
            int j = i2;
            while ((j & 0x3F) == 63) {
                old = old._nbsi64;
                nnn = nnn._nbsi64;
                j >>= 6;
            }
            long bits = old._bits[j >> 6];
            while (bits >= 0L) {
                long oldbits = bits;
                if (old.CAS(j >> 6, oldbits, bits |= NBSI.mask(63))) {
                    if (oldbits != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                bits = old._bits[j >> 6];
            }
            if (bits != NBSI.mask(63)) {
                long new_bits = nnn._bits[j >> 6];
                if (new_bits == 0L) {
                    new_bits = bits & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nnn.CAS(j >> 6, 0L, new_bits)) {
                        new_bits = nnn._bits[j >> 6];
                    }
                    assert (new_bits != 0L);
                }
                if (old.CAS(j >> 6, bits, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int d, String msg) {
            for (int i2 = 0; i2 < d; ++i2) {
                System.out.print("  ");
            }
            System.out.println(msg);
        }

        private void print(int d) {
            StringBuilder buf = new StringBuilder();
            buf.append("NBSI - _bits.len=");
            NBSI x = this;
            while (x != null) {
                buf.append(" " + x._bits.length);
                x = x._nbsi64;
            }
            this.print(d, buf.toString());
            x = this;
            while (x != null) {
                for (int i2 = 0; i2 < x._bits.length; ++i2) {
                    System.out.print(Long.toHexString(x._bits[i2]) + " ");
                }
                x = x._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(d, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(d, "__has_new - ");
                this._new.print(d + 1);
            }
        }

        static {
            Field f = null;
            try {
                f = NBSI.class.getDeclaredField("_new");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            _new_offset = _unsafe.objectFieldOffset(f);
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSIIntIterator intIterator;

        iter() {
            this.intIterator = new NBSIIntIterator();
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public Integer next() {
            return this.intIterator.next();
        }

        @Override
        public void remove() {
            this.intIterator.remove();
        }
    }

    private class NBSIIntIterator
    implements IntIterator {
        NBSI nbsi;
        int index = -1;
        int prev = -1;

        NBSIIntIterator() {
            this.nbsi = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        private void advance() {
            do {
                ++this.index;
                while (this.index >> 6 >= this.nbsi._bits.length) {
                    if (this.nbsi._new == null) {
                        this.index = -2;
                        return;
                    }
                    this.nbsi = this.nbsi._new;
                }
            } while (!this.nbsi.contains(this.index));
        }

        @Override
        public int next() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            this.prev = this.index;
            this.advance();
            return this.prev;
        }

        @Override
        public boolean hasNext() {
            return this.index != -2;
        }

        @Override
        public void remove() {
            if (this.prev == -1) {
                throw new IllegalStateException();
            }
            this.nbsi.remove(this.prev);
            this.prev = -1;
        }
    }
}

