/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.ByteList;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final String name;
    private final Encoding encoding;

    public SymbolNode(ISourcePosition position, String name2, Encoding encoding2, int cr) {
        super(position, false);
        this.name = name2;
        this.encoding = encoding2 == USASCIIEncoding.INSTANCE || cr == 16 ? USASCIIEncoding.INSTANCE : encoding2;
    }

    public SymbolNode(ISourcePosition position, ByteList value2) {
        super(position, false);
        this.name = value2.toString().intern();
        if (value2.getEncoding() != USASCIIEncoding.INSTANCE) {
            int size2 = value2.realSize();
            this.encoding = value2.getEncoding().strLength(value2.unsafeBytes(), value2.begin(), size2) == size2 ? USASCIIEncoding.INSTANCE : value2.getEncoding();
        } else {
            this.encoding = USASCIIEncoding.INSTANCE;
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

